/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JettyIniProcessor {
    @NonNls
    private static final String START_INI_FILE = "start.ini";
    @NonNls
    private static final String OPTIONS_PARAM_PREFIX = "OPTIONS=";
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("^([^#].*)=(.*)$");
    private static final Pattern MODULE_PATTERN = Pattern.compile("(?:#\\s*)?--module=(.+)");
    private final File myIniFile;

    public JettyIniProcessor(String workDir) {
        this(JettyIniProcessor.getDefaultIniFile(workDir));
    }

    @NotNull
    public static File getDefaultIniFile(@NotNull String workingDirectory) {
        if (workingDirectory == null) {
            JettyIniProcessor.$$$reportNull$$$0(0);
        }
        File file = new File(workingDirectory, START_INI_FILE);
        if (file == null) {
            JettyIniProcessor.$$$reportNull$$$0(1);
        }
        return file;
    }

    public JettyIniProcessor(File iniFile) {
        this.myIniFile = iniFile;
    }

    public File getIniFile() {
        return this.myIniFile;
    }

    public void process() {
        try {
            String[] iniLines;
            String iniContent = FileUtil.loadFile((File)this.myIniFile);
            for (String iniLine : iniLines = iniContent.split("\n")) {
                iniLine = iniLine.trim();
                Matcher matcher = PARAMETER_PATTERN.matcher(iniLine);
                Matcher moduleMatcher = MODULE_PATTERN.matcher(iniLine);
                if (moduleMatcher.matches()) {
                    this.processModuleLine(moduleMatcher.group(1), iniLine.startsWith("#"));
                    continue;
                }
                if (iniLine.isEmpty() || iniLine.startsWith("#") || iniLine.startsWith("-") || iniLine.startsWith(OPTIONS_PARAM_PREFIX)) {
                    this.processNonPathLine(iniLine);
                    continue;
                }
                if (matcher.matches()) {
                    this.processNonPathLine(iniLine);
                    this.processParameter(matcher.group(1), matcher.group(2));
                    continue;
                }
                this.processPathLine(iniLine);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void processNonPathLine(String iniLine) {
    }

    protected void processParameter(String paramName, String value) {
    }

    protected void processPathLine(String path) {
    }

    protected void processModuleLine(String moduleName, boolean isCommented) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/oss/jetty/server/JettyIniProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/oss/jetty/server/JettyIniProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultIniFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultIniFile";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

