/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.flat;

import com.android.tools.adtui.flat.FlatUiUtils;
import com.intellij.icons.AllIcons;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

class FlatComboBoxUI
extends BasicComboBoxUI {
    private final MouseAdapter myHoverAdapter = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            FlatComboBoxUI.this.myHover = true;
            FlatComboBoxUI.this.comboBox.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            FlatComboBoxUI.this.myHover = false;
            FlatComboBoxUI.this.comboBox.repaint();
        }
    };
    private boolean myHover;

    FlatComboBoxUI() {
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.comboBox.addMouseListener(this.myHoverAdapter);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this.myHoverAdapter);
    }

    @Override
    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox){

            @Override
            protected void configurePopup() {
                super.configurePopup();
                this.setBorderPainted(false);
                this.setBorder((Border)JBUI.Borders.empty());
            }

            @Override
            protected void firePopupMenuWillBecomeInvisible() {
                super.firePopupMenuWillBecomeInvisible();
                this.comboBox.repaint();
            }
        };
    }

    @Override
    protected JButton createArrowButton() {
        FlatArrowButton button = new FlatArrowButton();
        button.addMouseListener(this.myHoverAdapter);
        return button;
    }

    @Override
    protected void installDefaults() {
        this.padding = JBUI.insets((int)0, (int)0, (int)0, (int)2);
        this.squareButton = false;
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension size = super.getMinimumSize(c);
        return new Dimension(size.width, Math.max(size.height, JBUI.scale((int)25)));
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.myHover || this.isPopupVisible(this.comboBox) || c.isFocusOwner()) {
            FlatUiUtils.paintBackground(g, c);
        }
        super.paint(g, c);
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        c.setFont(this.comboBox.getFont());
        c.setBackground(UIUtil.TRANSPARENT_COLOR);
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        if (this.padding != null) {
            x = bounds.x + this.padding.left;
            y = bounds.y + this.padding.top;
            w = bounds.width - (this.padding.left + this.padding.right);
            h = bounds.height - (this.padding.top + this.padding.bottom);
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, x, y, w, h, shouldValidate);
    }

    private static class FlatArrowButton
    extends JButton {
        FlatArrowButton() {
            this.setUI(null);
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return new JBDimension(15, 25);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Dimension size = this.getSize();
            AllIcons.General.ArrowDownSmall.paintIcon(this, g, 0, size.height / 2 - 2);
        }
    }
}

