/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.model.event.EventAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.Nullable;

public interface SimpleEventRenderer<E> {
    public void draw(Component var1, Graphics2D var2, AffineTransform var3, double var4, @Nullable EventAction<E> var6);

    default public void draw(Component parent, Graphics2D g2d, AffineTransform transform, double length) {
        this.draw(parent, g2d, transform, length, null);
    }

    public static ImageIcon createImageIconWithBackgroundBorder(Icon icon, int margin, Color borderColor) {
        BufferedImage originalImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        BufferedImage borderImage = new BufferedImage(icon.getIconWidth() + margin * 2, icon.getIconHeight() + margin * 2, 2);
        Graphics2D g2d = originalImage.createGraphics();
        icon.paintIcon(null, g2d, 0, 0);
        for (int y = 0; y < originalImage.getHeight(); ++y) {
            for (int x = 0; x < originalImage.getWidth(); ++x) {
                Color color = new Color(originalImage.getRGB(x, y), true);
                if (color.getAlpha() <= 0) continue;
                for (int ny = y - margin; ny <= y + margin; ++ny) {
                    for (int nx = x - margin; nx <= x + margin; ++nx) {
                        if ((x - nx) * (x - nx) + (y - ny) * (y - ny) > margin * margin) continue;
                        borderImage.setRGB(nx + margin, ny + margin, borderColor.getRGB());
                    }
                }
            }
        }
        g2d = borderImage.createGraphics();
        icon.paintIcon(null, g2d, margin, margin);
        return new ImageIcon(borderImage);
    }
}

