/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.core;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.clones.configuration.DuplicateSettings;
import com.jetbrains.clones.core.CommonUtilsKt;
import com.jetbrains.clones.core.HashInfo;
import com.jetbrains.clones.core.LightNodeKey;
import com.jetbrains.clones.languagescope.DuplicateScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0015H\u0002J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u001b\u001a\u00020\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/clones/core/LightAstNodeHasher;", "", "scope", "Lcom/jetbrains/clones/languagescope/DuplicateScope;", "ast", "Lcom/intellij/lang/LighterAST;", "settings", "Lcom/jetbrains/clones/configuration/DuplicateSettings;", "(Lcom/jetbrains/clones/languagescope/DuplicateScope;Lcom/intellij/lang/LighterAST;Lcom/jetbrains/clones/configuration/DuplicateSettings;)V", "cache", "Ljava/util/HashMap;", "Lcom/jetbrains/clones/core/LightNodeKey;", "Lcom/jetbrains/clones/core/HashInfo;", "Lkotlin/collections/HashMap;", "computeAndCache", "", "node", "Lcom/intellij/lang/LighterASTNode;", "children", "", "computeAndCacheLeaf", "Lcom/intellij/lang/LighterASTTokenNode;", "computeAndCacheNode", "nodeChildren", "computeLeafHash", "", "getHashInfo", "getRangeInfo", "nodes", "intellij.platform.duplicatesDetector"})
public final class LightAstNodeHasher {
    private final HashMap<LightNodeKey, HashInfo> cache;
    private final DuplicateScope scope;
    private final LighterAST ast;
    private final DuplicateSettings settings;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HashInfo getHashInfo(@NotNull LighterASTNode node) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        LightNodeKey key = new LightNodeKey(node.getStartOffset(), node.getEndOffset());
        Map map2 = map = (Map)this.cache;
        if (!map2.containsKey(key)) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            List list = this.ast.getChildren(node);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ast.getChildren(node)");
            Iterable iterable = $receiver$iv = (Iterable)list;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                LighterASTNode it;
                LighterASTNode lighterASTNode = it = (LighterASTNode)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)lighterASTNode, (String)"it");
                if (this.scope.isNoise(this.ast, lighterASTNode)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List indexedChildren = (List)destination$iv$iv;
            this.computeAndCache(node, indexedChildren);
        }
        HashInfo hashInfo = this.cache.get(key);
        if (hashInfo == null) {
            Intrinsics.throwNpe();
        }
        return hashInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HashInfo getRangeInfo(@NotNull List<? extends LighterASTNode> nodes) {
        HashInfo it;
        void $receiver$iv$iv;
        Object object;
        Collection collection;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        boolean bl;
        Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
        Collection collection2 = nodes;
        boolean bl2 = bl = !collection2.isEmpty();
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (nodes.size() == 1) {
            return this.getHashInfo((LighterASTNode)CollectionsKt.first(nodes));
        }
        Iterable iterable = $receiver$iv = (Iterable)nodes;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it2;
            LighterASTNode lighterASTNode = (LighterASTNode)item$iv$iv;
            collection = destination$iv$iv;
            object = this.getHashInfo((LighterASTNode)it2);
            collection.add(object);
        }
        List hashNodes = (List)destination$iv$iv;
        Iterable $receiver$iv2 = hashNodes;
        Iterable iterable2 = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            HashInfo $i$f$mapTo = (HashInfo)item$iv$iv;
            collection = destination$iv$iv2;
            object = it.getHash();
            collection.add(object);
        }
        long hash = CommonUtilsKt.longHash((List)destination$iv$iv2);
        Iterable $receiver$iv3 = hashNodes;
        int sum$iv = 0;
        for (Object element$iv : $receiver$iv3) {
            it = (HashInfo)element$iv;
            int n = sum$iv;
            int n2 = it.getWeight();
            sum$iv = n + n2;
        }
        int weight = sum$iv;
        return new HashInfo(hash, weight);
    }

    public final void computeAndCache(@NotNull LighterASTNode node, @NotNull List<? extends LighterASTNode> children) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(children, (String)"children");
        if (node instanceof LighterASTTokenNode) {
            this.computeAndCacheLeaf((LighterASTTokenNode)node);
        } else {
            this.computeAndCacheNode(node, children);
        }
    }

    private final void computeAndCacheLeaf(LighterASTTokenNode node) {
        long hash = this.computeLeafHash(node);
        int weight = this.scope.weightOf(this.ast, (LighterASTNode)node);
        HashInfo info = new HashInfo(hash, weight);
        LightNodeKey key = new LightNodeKey(node.getStartOffset(), node.getEndOffset());
        Map map = this.cache;
        HashInfo hashInfo = info;
        map.put(key, hashInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final void computeAndCacheNode(LighterASTNode node, List<? extends LighterASTNode> nodeChildren) {
        long hash = this.scope.getNormalizedHash(this, this.ast, node, nodeChildren);
        Iterable $receiver$iv = nodeChildren;
        int sum$iv = 0;
        for (Object element$iv : $receiver$iv) {
            void it;
            LighterASTNode lighterASTNode = (LighterASTNode)element$iv;
            int n = sum$iv;
            int n2 = this.getHashInfo((LighterASTNode)it).getWeight();
            sum$iv = n + n2;
        }
        int weight = sum$iv + this.scope.weightOf(this.ast, node);
        HashInfo info = new HashInfo(hash, weight);
        LightNodeKey key = new LightNodeKey(node.getStartOffset(), node.getEndOffset());
        Map map = this.cache;
        HashInfo hashInfo = info;
        map.put(key, hashInfo);
    }

    private final long computeLeafHash(LighterASTTokenNode node) {
        long l;
        if (!this.scope.isAnonymized(this.ast, node)) {
            l = node.getText().hashCode();
        } else {
            IElementType iElementType = node.getTokenType();
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"node.tokenType");
            l = iElementType.getIndex();
        }
        return l;
    }

    public LightAstNodeHasher(@NotNull DuplicateScope scope, @NotNull LighterAST ast, @NotNull DuplicateSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)ast, (String)"ast");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.scope = scope;
        this.ast = ast;
        this.settings = settings;
        this.cache = new HashMap();
    }
}

