/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.core;

import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.clones.configuration.DuplicateSettings;
import com.jetbrains.clones.core.CommonUtilsKt;
import com.jetbrains.clones.core.DuplicateProcessor;
import com.jetbrains.clones.core.LightAstNodeHasher;
import com.jetbrains.clones.core.SimpleLightAstTraverser;
import com.jetbrains.clones.core.postprocessing.FilterIntersectedDuplicatesKt;
import com.jetbrains.clones.core.postprocessing.FilterSmallClonesKt;
import com.jetbrains.clones.core.postprocessing.TrimEdgesKt;
import com.jetbrains.clones.core.postprocessing.UniteNearbyClonesKt;
import com.jetbrains.clones.index.HashFragmentIndex;
import com.jetbrains.clones.languagescope.DuplicateScope;
import com.jetbrains.clones.structures.HashFragment;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.clones.structures.TextFragment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0002'(B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00162\u0006\u0010\u001e\u001a\u00020\u001fJ*\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u00160\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00162\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00162\u0006\u0010%\u001a\u00020\u001fH\u0002J\u0016\u0010&\u001a\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006)"}, d2={"Lcom/jetbrains/clones/core/DuplicateProcessor;", "", "project", "Lcom/intellij/openapi/project/Project;", "ast", "Lcom/intellij/lang/LighterAST;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "settings", "Lcom/jetbrains/clones/configuration/DuplicateSettings;", "scope", "Lcom/jetbrains/clones/languagescope/DuplicateScope;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/LighterAST;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/clones/configuration/DuplicateSettings;Lcom/jetbrains/clones/languagescope/DuplicateScope;)V", "hasher", "Lcom/jetbrains/clones/core/LightAstNodeHasher;", "tooManyDuplicatesLevel", "", "getTooManyDuplicatesLevel", "()I", "computeAndCacheHashInfo", "", "findClones", "", "Lcom/jetbrains/clones/structures/TextClone;", "psiFile", "Lcom/intellij/psi/PsiFile;", "minCloneSize", "gapSize", "findHashFragments", "Lcom/jetbrains/clones/structures/HashFragment;", "root", "Lcom/intellij/lang/LighterASTNode;", "findNodeRanges", "nodeRange", "isInseparable", "", "getIndexedChildren", "node", "hashFragmentOf", "Analyzer", "Indexer", "intellij.platform.duplicatesDetector"})
public class DuplicateProcessor {
    private final int tooManyDuplicatesLevel = 50;
    private final LightAstNodeHasher hasher;
    private final Project project;
    private final LighterAST ast;
    private final VirtualFile file;
    private final DuplicateSettings settings;
    private final DuplicateScope scope;

    public final int getTooManyDuplicatesLevel() {
        return this.tooManyDuplicatesLevel;
    }

    private final void computeAndCacheHashInfo() {
        LighterASTNode lighterASTNode = this.ast.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)lighterASTNode, (String)"ast.root");
        Sequence<Pair<LighterASTNode, List<LighterASTNode>>> $receiver$iv = new SimpleLightAstTraverser(this.ast, lighterASTNode, null, null, 12, null).expand((Function1<? super LighterASTNode, ? extends List<? extends LighterASTNode>>)((Function1)new Function1<LighterASTNode, List<? extends LighterASTNode>>(this){
            final /* synthetic */ DuplicateProcessor this$0;

            @NotNull
            public final List<LighterASTNode> invoke(@NotNull LighterASTNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return DuplicateProcessor.access$getIndexedChildren(this.this$0, it);
            }
            {
                this.this$0 = duplicateProcessor;
                super(1);
            }
        })).postOrderTraverse();
        for (Object element$iv : $receiver$iv) {
            Pair $node_children = (Pair)element$iv;
            LighterASTNode node = (LighterASTNode)$node_children.component1();
            List children = (List)$node_children.component2();
            this.hasher.computeAndCache(node, children);
        }
    }

    @NotNull
    public final List<TextClone> findClones(@NotNull PsiFile psiFile, int minCloneSize, int gapSize) {
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        this.computeAndCacheHashInfo();
        return new Analyzer(minCloneSize, gapSize).findClones$intellij_platform_duplicatesDetector(psiFile);
    }

    @NotNull
    public final List<HashFragment> findHashFragments(@NotNull LighterASTNode root) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        return new Indexer().findHashFragments(root);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LighterASTNode> getIndexedChildren(LighterASTNode node) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List list = this.ast.getChildren(node);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ast.getChildren(node)");
        Iterable iterable = $receiver$iv = (Iterable)list;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            LighterASTNode it;
            LighterASTNode lighterASTNode = it = (LighterASTNode)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)lighterASTNode, (String)"it");
            if (this.scope.isNoise(this.ast, lighterASTNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final HashFragment hashFragmentOf(List<? extends LighterASTNode> nodeRange) {
        boolean bl;
        Collection collection = nodeRange;
        boolean bl2 = bl = !collection.isEmpty();
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long hash = this.hasher.getRangeInfo(nodeRange).getHash();
        TextRange range = new TextRange(((LighterASTNode)CollectionsKt.first(nodeRange)).getStartOffset(), ((LighterASTNode)CollectionsKt.last(nodeRange)).getEndOffset());
        return new HashFragment(hash, this.file, range);
    }

    private final List<List<LighterASTNode>> findNodeRanges(List<? extends LighterASTNode> nodeRange, boolean isInseparable) {
        return isInseparable ? CollectionsKt.listOf(nodeRange) : CommonUtilsKt.weightedWindow(nodeRange, this.settings.getWindow(), (Function1)new Function1<LighterASTNode, Integer>(this){
            final /* synthetic */ DuplicateProcessor this$0;

            public final int invoke(@NotNull LighterASTNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return DuplicateProcessor.access$getHasher$p(this.this$0).getHashInfo(it).getWeight();
            }
            {
                this.this$0 = duplicateProcessor;
                super(1);
            }
        });
    }

    public DuplicateProcessor(@NotNull Project project, @NotNull LighterAST ast, @NotNull VirtualFile file, @NotNull DuplicateSettings settings, @NotNull DuplicateScope scope) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)ast, (String)"ast");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        this.project = project;
        this.ast = ast;
        this.file = file;
        this.settings = settings;
        this.scope = scope;
        this.tooManyDuplicatesLevel = 50;
        this.hasher = new LightAstNodeHasher(this.scope, this.ast, this.settings);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/clones/core/DuplicateProcessor$Indexer;", "", "(Lcom/jetbrains/clones/core/DuplicateProcessor;)V", "findHashFragments", "", "Lcom/jetbrains/clones/structures/HashFragment;", "root", "Lcom/intellij/lang/LighterASTNode;", "isIndexed", "", "node", "intellij.platform.duplicatesDetector"})
    public final class Indexer {
        private final boolean isIndexed(LighterASTNode node) {
            boolean isNotSmall = DuplicateProcessor.this.hasher.getHashInfo(node).getWeight() >= DuplicateProcessor.this.settings.getWindow();
            boolean isNotIgnored = !DuplicateProcessor.this.scope.isIgnoredAsDuplicate(DuplicateProcessor.this.ast, node);
            boolean isNotNoise = !DuplicateProcessor.this.scope.isNoise(DuplicateProcessor.this.ast, node);
            return isNotSmall && isNotIgnored && isNotNoise;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<HashFragment> findHashFragments(@NotNull LighterASTNode root) {
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            List result = new ArrayList();
            Sequence $receiver$iv = SequencesKt.onEach(new SimpleLightAstTraverser(DuplicateProcessor.this.ast, root, null, null, 12, null).expand((Function1<? super LighterASTNode, ? extends List<? extends LighterASTNode>>)((Function1)new Function1<LighterASTNode, List<? extends LighterASTNode>>(this){
                final /* synthetic */ Indexer this$0;

                @NotNull
                public final List<LighterASTNode> invoke(@NotNull LighterASTNode it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return DuplicateProcessor.access$getIndexedChildren(this.this$0.DuplicateProcessor.this, it);
                }
                {
                    this.this$0 = indexer;
                    super(1);
                }
            })).postOrderTraverse(), (Function1)((Function1)new Function1<Pair<? extends LighterASTNode, ? extends List<? extends LighterASTNode>>, Unit>(this){
                final /* synthetic */ Indexer this$0;

                public final void invoke(@NotNull Pair<? extends LighterASTNode, ? extends List<? extends LighterASTNode>> $node_children) {
                    Intrinsics.checkParameterIsNotNull($node_children, (String)"<name for destructuring parameter 0>");
                    LighterASTNode node = (LighterASTNode)$node_children.component1();
                    List children = (List)$node_children.component2();
                    DuplicateProcessor.access$getHasher$p(this.this$0.DuplicateProcessor.this).computeAndCache(node, children);
                }
                {
                    this.this$0 = indexer;
                    super(1);
                }
            }));
            for (Object element$iv : $receiver$iv) {
                void $receiver$iv$iv;
                Iterable $receiver$iv2;
                Pair $node_children = (Pair)element$iv;
                LighterASTNode node = (LighterASTNode)$node_children.component1();
                List children = (List)$node_children.component2();
                if (!this.isIndexed(node)) continue;
                List windows = DuplicateProcessor.this.findNodeRanges(children, DuplicateProcessor.this.scope.isInseparableAsDuplicate(DuplicateProcessor.this.ast, node));
                Iterable iterable = $receiver$iv2 = (Iterable)windows;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    List list = (List)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    HashFragment hashFragment = DuplicateProcessor.this.hashFragmentOf((List)it);
                    collection.add(hashFragment);
                }
                List hashFragments = (List)destination$iv$iv;
                result.addAll(hashFragments);
            }
            return result;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\nH\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/clones/core/DuplicateProcessor$Analyzer;", "", "minCloneSize", "", "maxGap", "(Lcom/jetbrains/clones/core/DuplicateProcessor;II)V", "getMaxGap", "()I", "getMinCloneSize", "findAnalyzedElements", "", "Lcom/intellij/lang/LighterASTNode;", "root", "findClones", "Lcom/jetbrains/clones/structures/TextClone;", "psiFile", "Lcom/intellij/psi/PsiFile;", "findClones$intellij_platform_duplicatesDetector", "isAnalyzed", "", "node", "isDuplicated", "searchClones", "searchDuplicatesInHashFragments", "hashFragments", "Lcom/jetbrains/clones/structures/HashFragment;", "intellij.platform.duplicatesDetector"})
    public final class Analyzer {
        private final int minCloneSize;
        private final int maxGap;

        @NotNull
        public final List<TextClone> findClones$intellij_platform_duplicatesDetector(@NotNull PsiFile psiFile) {
            Iterable list$iv$iv;
            LighterASTNode it;
            Iterable $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
            DuplicateScope duplicateScope = DuplicateProcessor.this.scope;
            FileASTNode fileASTNode = psiFile.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileASTNode, (String)"psiFile.node");
            LighterAST lighterAST = fileASTNode.getLighterAST();
            Intrinsics.checkExpressionValueIsNotNull((Object)lighterAST, (String)"psiFile.node.lighterAST");
            Iterable $receiver$iv = duplicateScope.findIndexedElements(lighterAST);
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (LighterASTNode)element$iv$iv;
                list$iv$iv = this.findAnalyzedElements(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (LighterASTNode)element$iv$iv;
                list$iv$iv = this.searchClones(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final boolean isAnalyzed(LighterASTNode node) {
            LighterASTNode lighterASTNode = DuplicateProcessor.this.ast.getParent(node);
            if (lighterASTNode == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)lighterASTNode, (String)"ast.getParent(node) ?: return false");
            LighterASTNode parentNode = lighterASTNode;
            boolean ignored = DuplicateProcessor.this.scope.isIgnoredAsDuplicate(DuplicateProcessor.this.ast, parentNode);
            boolean inseparable = DuplicateProcessor.this.scope.isInseparableAsDuplicate(DuplicateProcessor.this.ast, parentNode);
            boolean hasDuplicates = this.isDuplicated(node);
            if (DuplicateProcessor.this.scope.isIgnoredAsDuplicate(DuplicateProcessor.this.ast, node)) {
                return false;
            }
            if (hasDuplicates) {
                if (ignored) {
                    return true;
                }
                return inseparable && !this.isDuplicated(parentNode);
            }
            return true;
        }

        private final List<LighterASTNode> findAnalyzedElements(LighterASTNode root) {
            Function1<LighterASTNode, Boolean> shouldNotExpand$ = new Function1<LighterASTNode, Boolean>(this){
                final /* synthetic */ Analyzer this$0;

                public final boolean invoke(@NotNull LighterASTNode node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return Analyzer.access$isDuplicated(this.this$0, node) && !DuplicateProcessor.access$getScope$p(this.this$0.DuplicateProcessor.this).isIgnoredAsDuplicate(DuplicateProcessor.access$getAst$p(this.this$0.DuplicateProcessor.this), node);
                }
                {
                    this.this$0 = analyzer;
                    super(1);
                }
            };
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(new SimpleLightAstTraverser(DuplicateProcessor.this.ast, root, null, null, 12, null).expand((Function1<? super LighterASTNode, ? extends List<? extends LighterASTNode>>)((Function1)new Function1<LighterASTNode, List<? extends LighterASTNode>>(this, shouldNotExpand$){
                final /* synthetic */ Analyzer this$0;
                final /* synthetic */ findAnalyzedElements.1 $shouldNotExpand$1;

                @NotNull
                public final List<LighterASTNode> invoke(@NotNull LighterASTNode it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$shouldNotExpand$1.invoke(it) ? CollectionsKt.emptyList() : DuplicateProcessor.access$getIndexedChildren(this.this$0.DuplicateProcessor.this, it);
                }
                {
                    this.this$0 = analyzer;
                    this.$shouldNotExpand$1 = var2_2;
                    super(1);
                }
            })).ignore((Function1<? super LighterASTNode, Boolean>)((Function1)new Function1<LighterASTNode, Boolean>(this){
                final /* synthetic */ Analyzer this$0;

                public final boolean invoke(@NotNull LighterASTNode it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return DuplicateProcessor.access$getHasher$p(this.this$0.DuplicateProcessor.this).getHashInfo(it).getWeight() < DuplicateProcessor.access$getSettings$p(this.this$0.DuplicateProcessor.this).getWindow() || DuplicateProcessor.access$getScope$p(this.this$0.DuplicateProcessor.this).isNoise(DuplicateProcessor.access$getAst$p(this.this$0.DuplicateProcessor.this), it);
                }
                {
                    this.this$0 = analyzer;
                    super(1);
                }
            })).postOrderTraverse(), (Function1)((Function1)new Function1<Pair<? extends LighterASTNode, ? extends List<? extends LighterASTNode>>, Boolean>(this, root){
                final /* synthetic */ Analyzer this$0;
                final /* synthetic */ LighterASTNode $root;

                public final boolean invoke(@NotNull Pair<? extends LighterASTNode, ? extends List<? extends LighterASTNode>> $node_$_$) {
                    Intrinsics.checkParameterIsNotNull($node_$_$, (String)"<name for destructuring parameter 0>");
                    LighterASTNode node = (LighterASTNode)$node_$_$.component1();
                    return Intrinsics.areEqual((Object)node, (Object)this.$root) || Analyzer.access$isAnalyzed(this.this$0, node);
                }
                {
                    this.this$0 = analyzer;
                    this.$root = lighterASTNode;
                    super(1);
                }
            })), (Function1)findAnalyzedElements.5.INSTANCE));
        }

        /*
         * WARNING - void declaration
         */
        private final List<TextClone> searchClones(LighterASTNode node) {
            void $receiver$iv$iv;
            void $receiver$iv;
            List indexedChildren = DuplicateProcessor.this.getIndexedChildren(node);
            Iterable iterable = DuplicateProcessor.this.findNodeRanges(indexedChildren, DuplicateProcessor.this.scope.isInseparableAsDuplicate(DuplicateProcessor.this.ast, node));
            void var5_4 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                List list = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                HashFragment hashFragment = DuplicateProcessor.this.hashFragmentOf((List)it);
                collection.add(hashFragment);
            }
            List hashFragments = (List)destination$iv$iv;
            return this.searchDuplicatesInHashFragments(hashFragments);
        }

        private final boolean isDuplicated(LighterASTNode node) {
            long hash = DuplicateProcessor.this.hasher.getHashInfo(node).getHash();
            HashFragment hashFragment = new HashFragment(hash, DuplicateProcessor.this.file, new TextRange(node.getStartOffset(), node.getEndOffset()));
            List<TextClone> duplicates = this.searchDuplicatesInHashFragments(CollectionsKt.listOf((Object)hashFragment));
            Collection collection = duplicates;
            return !collection.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        private final List<TextClone> searchDuplicatesInHashFragments(List<HashFragment> hashFragments) {
            Object main;
            TextClone textClone;
            TextClone it;
            Collection collection;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv = hashFragments;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                HashFragment hashFragment = (HashFragment)item$iv$iv;
                collection = destination$iv$iv;
                textClone = new TextClone(((HashFragment)((Object)it)).getTextFragment(), HashFragmentIndex.Companion.findTextRanges(DuplicateProcessor.this.project, ((HashFragment)((Object)it)).getHash()));
                collection.add(textClone);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (TextClone)element$iv$iv;
                if (!(it.getDuplicates().size() < DuplicateProcessor.this.getTooManyDuplicatesLevel())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void $receiver$iv$iv2;
                void $receiver$iv2;
                TextClone textClone2;
                void $main_duplicates;
                it = (TextClone)item$iv$iv;
                collection = destination$iv$iv;
                main = $main_duplicates.component1();
                List<TextFragment> duplicates = $main_duplicates.component2();
                Iterable $i$f$filter = duplicates;
                TextFragment textFragment = main;
                TextClone textClone3 = textClone2;
                TextClone textClone4 = textClone2;
                void var14_16 = $receiver$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    TextFragment it2 = (TextFragment)element$iv$iv;
                    if (UniteNearbyClonesKt.intersects(it2, (TextFragment)main)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv2;
                textClone3(textFragment, list);
                textClone = textClone4;
                collection.add(textClone);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (TextClone)element$iv$iv;
                main = it.getDuplicates();
                if (!(!main.isEmpty())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = FilterSmallClonesKt.filterSmallClones(FilterIntersectedDuplicatesKt.filterIntersectedDuplicates(UniteNearbyClonesKt.uniteTextRanges((List)destination$iv$iv, this.maxGap)), DuplicateProcessor.this.project, DuplicateProcessor.this.hasher, DuplicateProcessor.this.scope, this.minCloneSize);
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (TextClone)item$iv$iv;
                collection = destination$iv$iv;
                textClone = TrimEdgesKt.trimEdges(it, DuplicateProcessor.this.project, DuplicateProcessor.this.scope);
                collection.add(textClone);
            }
            return (List)destination$iv$iv;
        }

        public final int getMinCloneSize() {
            return this.minCloneSize;
        }

        public final int getMaxGap() {
            return this.maxGap;
        }

        public Analyzer(int minCloneSize, int maxGap) {
            this.minCloneSize = minCloneSize;
            this.maxGap = maxGap;
        }

        public static final /* synthetic */ boolean access$isDuplicated(Analyzer $this, @NotNull LighterASTNode node) {
            return $this.isDuplicated(node);
        }

        public static final /* synthetic */ boolean access$isAnalyzed(Analyzer $this, @NotNull LighterASTNode node) {
            return $this.isAnalyzed(node);
        }
    }
}

