/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.clones.configuration.PluginLabels;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.clones.toolwindow.DuplicateViewManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/clones/ShowDuplicatesLikeThisFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "report", "Lcom/jetbrains/clones/structures/TextClone;", "(Lcom/jetbrains/clones/structures/TextClone;)V", "fixName", "", "version", "", "Ljava/lang/Long;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "isValid", "", "startInWriteAction", "intellij.platform.duplicatesDetector"})
public final class ShowDuplicatesLikeThisFix
implements LocalQuickFix {
    private final Long version;
    private final String fixName;
    private final TextClone report;

    private final boolean isValid() {
        Document document = FileDocumentManager.getInstance().getDocument(this.report.getMain().getFile());
        return Intrinsics.areEqual((Object)(document != null ? Long.valueOf(document.getModificationStamp()) : null), (Object)this.version);
    }

    @NotNull
    public String getName() {
        return this.fixName;
    }

    @NotNull
    public String getFamilyName() {
        String string = PluginLabels.INSTANCE.getMessage("duplicate.inspection.fix.family", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PluginLabels.getMessage(\u2026e.inspection.fix.family\")");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        if (this.isValid()) {
            DuplicateViewManager.Companion.getInstance(project).showClonesData(this.report);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public ShowDuplicatesLikeThisFix(@NotNull TextClone report) {
        Intrinsics.checkParameterIsNotNull((Object)report, (String)"report");
        this.report = report;
        Document document = FileDocumentManager.getInstance().getDocument(this.report.getMain().getFile());
        this.version = document != null ? Long.valueOf(document.getModificationStamp()) : null;
        IntRange lines = this.report.getMain().getLines();
        String string = PluginLabels.INSTANCE.getMessage("duplicate.inspection.fix.name", new Object[]{(int)lines.getStart(), (int)lines.getEndInclusive()});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PluginLabels.getMessage(\u2026tart, lines.endInclusive)");
        this.fixName = string;
    }
}

