/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.clones.DuplicateProblemDescriptor;
import com.jetbrains.clones.ShowDuplicatesLikeThisFix;
import com.jetbrains.clones.configuration.PluginLabels;
import com.jetbrains.clones.configuration.panel.InspectionController;
import com.jetbrains.clones.core.DuplicateProcessor;
import com.jetbrains.clones.extractMethod.ExtractDuplicatedJavaMethodFix;
import com.jetbrains.clones.languagescope.DuplicateScopeExtension;
import com.jetbrains.clones.structures.TextClone;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\"\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006$"}, d2={"Lcom/jetbrains/clones/DuplicateInspectionProvider;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "maxGap", "", "getMaxGap", "()I", "setMaxGap", "(I)V", "minCloneLength", "getMinCloneLength", "setMinCloneLength", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "createOptionsPanel", "Ljavax/swing/JComponent;", "createProblemDescriptor", "manger", "textClone", "Lcom/jetbrains/clones/structures/TextClone;", "findElementAndRange", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/util/TextRange;", "textRange", "getDisplayName", "", "getStaticDescription", "intellij.platform.duplicatesDetector"})
public final class DuplicateInspectionProvider
extends LocalInspectionTool {
    private int minCloneLength = 30;
    private int maxGap = 2;

    public final int getMinCloneLength() {
        return this.minCloneLength;
    }

    public final void setMinCloneLength(int n) {
        this.minCloneLength = n;
    }

    public final int getMaxGap() {
        return this.maxGap;
    }

    public final void setMaxGap(int n) {
        this.maxGap = n;
    }

    @NotNull
    public String getDisplayName() {
        String string = PluginLabels.INSTANCE.getMessage("duplicate.inspection.key", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PluginLabels.getMessage(\u2026uplicate.inspection.key\")");
        return string;
    }

    @NotNull
    public String getStaticDescription() {
        String string = PluginLabels.INSTANCE.getMessage("duplicate.inspection.description", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PluginLabels.getMessage(\u2026.inspection.description\")");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        void $receiver$iv$iv;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Project project = file.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file.virtualFile");
        FileASTNode fileASTNode = file.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileASTNode, (String)"file.node");
        LighterAST lighterAST = fileASTNode.getLighterAST();
        Intrinsics.checkExpressionValueIsNotNull((Object)lighterAST, (String)"file.node.lighterAST");
        DuplicateProcessor duplicateProcessor = DuplicateScopeExtension.Companion.createDuplicateProcessor(project, virtualFile, lighterAST);
        if (duplicateProcessor == null) {
            return new ProblemDescriptor[0];
        }
        DuplicateProcessor cloneHelper = duplicateProcessor;
        Iterable iterable = cloneHelper.findClones(file, this.minCloneLength, this.maxGap);
        void var7_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            ProblemDescriptor problemDescriptor;
            Object element$iv$iv = element$iv$iv$iv;
            TextClone textClone = (TextClone)element$iv$iv;
            if (this.createProblemDescriptor(manager, textClone, isOnTheFly) == null) continue;
            ProblemDescriptor it$iv$iv = problemDescriptor;
            destination$iv$iv.add(it$iv$iv);
        }
        List problems = (List)destination$iv$iv;
        Collection thisCollection$iv = $receiver$iv = (Collection)problems;
        ProblemDescriptor[] problemDescriptorArray = thisCollection$iv.toArray(new ProblemDescriptor[0]);
        if (problemDescriptorArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return problemDescriptorArray;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new InspectionController(this).getPanel();
    }

    /*
     * WARNING - void declaration
     */
    private final ProblemDescriptor createProblemDescriptor(InspectionManager manger, TextClone textClone, boolean isOnTheFly) {
        void element;
        Project project = manger.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"manger.project");
        Project project2 = project;
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(textClone.getMain().getFile());
        if (psiFile == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"PsiManager.getInstance(p\u2026le(textClone.main.file)!!");
        PsiFile file = psiFile;
        IntRange lines = textClone.getMain().getLines();
        LocalQuickFix showDuplicatesFix = isOnTheFly ? (LocalQuickFix)new ShowDuplicatesLikeThisFix(textClone) : null;
        Pair<PsiElement, TextRange> pair = this.findElementAndRange(file, textClone.getMain().getRange());
        if (pair == null) {
            return null;
        }
        Pair<PsiElement, TextRange> pair2 = pair;
        PsiElement psiElement = (PsiElement)pair2.component1();
        TextRange range = (TextRange)pair2.component2();
        String message = isOnTheFly ? PluginLabels.INSTANCE.getMessage("duplicate.inspection.problem", new Object[0]) : PluginLabels.INSTANCE.getMessage("duplicate.inspection.problem.details", new Object[]{(int)lines.getStart(), (int)lines.getEndInclusive()});
        return (ProblemDescriptor)new DuplicateProblemDescriptor((PsiElement)element, range, message, ProblemHighlightType.WEAK_WARNING, textClone, isOnTheFly, showDuplicatesFix, ExtractDuplicatedJavaMethodFix.Companion.createFix(project2, textClone));
    }

    private final Pair<PsiElement, TextRange> findElementAndRange(PsiFile file, TextRange textRange) {
        PsiElement psiElement = file.findElementAt(textRange.getStartOffset());
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"file.findElementAt(textR\u2026artOffset) ?: return null");
        PsiElement start = psiElement;
        PsiElement psiElement2 = file.findElementAt(textRange.getEndOffset() - 1);
        if (psiElement2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"file.findElementAt(textR\u2026ffset - 1) ?: return null");
        PsiElement end = psiElement2;
        PsiElement element = PsiTreeUtil.findCommonParent((PsiElement)start, (PsiElement)end);
        PsiElement psiElement3 = element;
        if (psiElement3 == null || (psiElement3 = psiElement3.getTextRange()) == null) {
            return null;
        }
        int offset = psiElement3.getStartOffset();
        return new Pair((Object)element, (Object)textRange.shiftLeft(offset));
    }
}

