/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.CreatePropertyFix;
import com.intellij.lang.properties.references.I18nizeQuickFixModel;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCreatePropertyFix
extends CreatePropertyFix {
    private static final Logger LOG = Logger.getInstance(JavaCreatePropertyFix.class);

    public JavaCreatePropertyFix() {
    }

    public JavaCreatePropertyFix(PsiElement element, String key, List<PropertiesFile> propertiesFiles) {
        super(element, key, propertiesFiles);
    }

    protected Couple<String> doAction(Project project, PsiElement psiElement, I18nizeQuickFixModel model) {
        Couple result = super.doAction(project, psiElement, model);
        if (result != null && psiElement instanceof PsiLiteralExpression) {
            String key = (String)result.first;
            StringBuilder buffer = new StringBuilder();
            buffer.append('\"');
            StringUtil.escapeStringCharacters((int)key.length(), (String)key, (StringBuilder)buffer);
            buffer.append('\"');
            try {
                WriteAction.run(() -> {
                    PsiExpression newKeyLiteral = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(buffer.toString(), null);
                    psiElement.replace((PsiElement)newKeyLiteral);
                });
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        return result;
    }

    @Nullable
    protected Couple<String> invokeAction(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement psiElement, @Nullable String suggestedKey, @Nullable String suggestedValue, @Nullable List<PropertiesFile> propertiesFiles) {
        if (project == null) {
            JavaCreatePropertyFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JavaCreatePropertyFix.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            JavaCreatePropertyFix.$$$reportNull$$$0(2);
        }
        PsiLiteralExpression literalExpression = psiElement instanceof PsiLiteralExpression ? (PsiLiteralExpression)psiElement : null;
        String propertyValue = suggestedValue == null ? "" : suggestedValue;
        JavaI18nizeQuickFixDialog dialog = new JavaI18nizeQuickFixDialog(project, file, literalExpression, propertyValue, JavaCreatePropertyFix.createDefaultCustomization((String)suggestedKey, propertiesFiles), false, false);
        return this.doAction(project, psiElement, (I18nizeQuickFixModel)dialog);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/i18n/JavaCreatePropertyFix";
        objectArray[2] = "invokeAction";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

