/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.graph;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.graph.PageflowEdge;
import com.intellij.seam.graph.PageflowNode;
import com.intellij.seam.graph.impl.DecisionNode;
import com.intellij.seam.graph.impl.EndStateNode;
import com.intellij.seam.graph.impl.PageNode;
import com.intellij.seam.graph.impl.PageflowBasicEdge;
import com.intellij.seam.graph.impl.PageflowBasicNode;
import com.intellij.seam.graph.impl.ProcessStateNode;
import com.intellij.seam.graph.impl.StartStateNode;
import com.intellij.seam.model.xml.PageflowDomModelManager;
import com.intellij.seam.model.xml.PageflowModel;
import com.intellij.seam.model.xml.pageflow.Decision;
import com.intellij.seam.model.xml.pageflow.EndState;
import com.intellij.seam.model.xml.pageflow.Page;
import com.intellij.seam.model.xml.pageflow.PageElements;
import com.intellij.seam.model.xml.pageflow.PageflowDefinition;
import com.intellij.seam.model.xml.pageflow.PageflowTransitionHolder;
import com.intellij.seam.model.xml.pageflow.ProcessState;
import com.intellij.seam.model.xml.pageflow.StartState;
import com.intellij.seam.model.xml.pageflow.Transition;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageflowDataModel
extends GraphDataModel<PageflowNode, PageflowEdge> {
    private final Collection<PageflowNode> myNodes = new HashSet<PageflowNode>();
    private final Collection<PageflowEdge> myEdges = new HashSet<PageflowEdge>();
    protected final Map<PsiFile, NodesGroup> myGroups = new HashMap<PsiFile, NodesGroup>();
    private final Project myProject;
    private final XmlFile myFile;
    @NonNls
    private static final String UNDEFINED_NAME = "Undefined";

    public PageflowDataModel(XmlFile file) {
        this.myFile = file;
        this.myProject = file.getProject();
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Collection<PageflowNode> getNodes() {
        Collection<PageflowNode> collection = this.getNodes(true);
        if (collection == null) {
            PageflowDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<PageflowNode> getNodes(boolean refresh) {
        if (refresh) {
            this.refreshDataModel();
        }
        Collection<PageflowNode> collection = this.myNodes;
        if (collection == null) {
            PageflowDataModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public Collection<PageflowEdge> getEdges() {
        Collection<PageflowEdge> collection = this.myEdges;
        if (collection == null) {
            PageflowDataModel.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public PageflowNode getSourceNode(PageflowEdge pageflowBasicEdge) {
        PageflowNode pageflowNode = pageflowBasicEdge.getSource();
        if (pageflowNode == null) {
            PageflowDataModel.$$$reportNull$$$0(3);
        }
        return pageflowNode;
    }

    @NotNull
    public PageflowNode getTargetNode(PageflowEdge pageflowBasicEdge) {
        PageflowNode pageflowNode = pageflowBasicEdge.getTarget();
        if (pageflowNode == null) {
            PageflowDataModel.$$$reportNull$$$0(4);
        }
        return pageflowNode;
    }

    @NotNull
    public String getNodeName(PageflowNode pageflowBasicNode) {
        if ("" == null) {
            PageflowDataModel.$$$reportNull$$$0(5);
        }
        return "";
    }

    @NotNull
    public String getEdgeName(PageflowEdge pageflowBasicEdge) {
        String string = pageflowBasicEdge.getName();
        if (string == null) {
            PageflowDataModel.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PageflowEdge createEdge(@NotNull PageflowNode from, @NotNull PageflowNode to) {
        if (from == null) {
            PageflowDataModel.$$$reportNull$$$0(7);
        }
        if (to == null) {
            PageflowDataModel.$$$reportNull$$$0(8);
        }
        String toName = to.getName();
        Object element = from.getIdentifyingElement();
        if (element instanceof PageflowTransitionHolder) {
            return (PageflowEdge)WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> {
                if (from == null) {
                    PageflowDataModel.$$$reportNull$$$0(9);
                }
                if (to == null) {
                    PageflowDataModel.$$$reportNull$$$0(10);
                }
                Transition transition = ((PageflowTransitionHolder)element).addTransition();
                transition.getTo().setStringValue(toName);
                return new PageflowBasicEdge(from, to, (Transition)transition.createStableCopy(), false);
            });
        }
        return null;
    }

    public void dispose() {
    }

    private void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    private void clearAll() {
        this.myNodes.clear();
        this.myEdges.clear();
    }

    public void updateDataModel() {
        PageflowDefinition pageflowDefinition = this.getPageflowDefinition();
        if (pageflowDefinition == null) {
            return;
        }
        Map<String, List<PageNode>> allPageNodes = this.getPageNodes(pageflowDefinition);
        Map<String, List<DecisionNode>> allDecisionNodes = this.getDecisionNodes(pageflowDefinition);
        Map<String, List<EndStateNode>> allEndStates = this.getEndStateNodes(pageflowDefinition);
        Map<String, List<ProcessStateNode>> allProcessStates = this.getProcessStateNodes(pageflowDefinition);
        StartState startState = pageflowDefinition.getStartState();
        if (DomUtil.hasXml((DomElement)startState)) {
            StartStateNode startStateNode = new StartStateNode(startState.getName().getStringValue(), (StartState)startState.createStableCopy());
            this.addNode(startStateNode);
            this.addTransitions(startStateNode, startState.getTransitions(), allPageNodes, allDecisionNodes, allEndStates, allProcessStates);
        }
        for (List<PageNode> list : allPageNodes.values()) {
            for (PageNode pageNode : list) {
                this.addTransitions(pageNode, ((PageElements)pageNode.getIdentifyingElement()).getTransitions(), allPageNodes, allDecisionNodes, allEndStates, allProcessStates);
            }
        }
        for (List<PageflowBasicNode> list : allDecisionNodes.values()) {
            for (DecisionNode decisionNode : list) {
                this.addTransitions(decisionNode, ((Decision)decisionNode.getIdentifyingElement()).getTransitions(), allPageNodes, allDecisionNodes, allEndStates, allProcessStates);
            }
        }
        for (List<PageflowBasicNode> list : allProcessStates.values()) {
            for (ProcessStateNode processStateNode : list) {
                this.addTransitions(processStateNode, ((ProcessState)processStateNode.getIdentifyingElement()).getTransitions(), allPageNodes, allDecisionNodes, allEndStates, allProcessStates);
            }
        }
    }

    private Map<String, List<ProcessStateNode>> getProcessStateNodes(PageflowDefinition pageflowDefinition) {
        HashMap<String, List<ProcessStateNode>> processStateNodes = new HashMap<String, List<ProcessStateNode>>();
        for (ProcessState processState : pageflowDefinition.getProcessStates()) {
            String name = processState.getName().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                name = UNDEFINED_NAME;
            }
            if (!processStateNodes.containsKey(name)) {
                processStateNodes.put(name, new ArrayList());
            }
            ProcessStateNode node = new ProcessStateNode(name, (ProcessState)processState.createStableCopy());
            ((List)processStateNodes.get(name)).add(node);
            this.addNode(node);
        }
        return processStateNodes;
    }

    private Map<String, List<EndStateNode>> getEndStateNodes(PageflowDefinition pageflowDefinition) {
        HashMap<String, List<EndStateNode>> endStateNodes = new HashMap<String, List<EndStateNode>>();
        for (EndState endState : pageflowDefinition.getEndStates()) {
            String name = endState.getName().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                name = UNDEFINED_NAME;
            }
            if (!endStateNodes.containsKey(name)) {
                endStateNodes.put(name, new ArrayList());
            }
            EndStateNode node = new EndStateNode(name, (EndState)endState.createStableCopy());
            ((List)endStateNodes.get(name)).add(node);
            this.addNode(node);
        }
        return endStateNodes;
    }

    private void addTransitions(PageflowNode<? extends DomElement> sourceNode, List<Transition> transitions, Map<String, List<PageNode>> allPageNodes, Map<String, List<DecisionNode>> allDecisionNodes, Map<String, List<EndStateNode>> allEndStates, Map<String, List<ProcessStateNode>> allProcessStates) {
        for (Transition transition : transitions) {
            List<ProcessStateNode> targetProcessStateNodes;
            List<EndStateNode> list;
            List<DecisionNode> targetDecisionNodes;
            String targetNodeName = transition.getTo().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)targetNodeName)) continue;
            List<PageNode> targetPageNodes = allPageNodes.get(targetNodeName);
            if (targetPageNodes != null) {
                for (PageNode pageNode : targetPageNodes) {
                    this.addTransition(new PageflowBasicEdge(sourceNode, pageNode, (Transition)transition.createStableCopy(), targetPageNodes.size() > 1 || allDecisionNodes.containsKey(targetNodeName) || allEndStates.containsKey(targetNodeName) || allProcessStates.containsKey(targetNodeName)));
                }
            }
            if ((targetDecisionNodes = allDecisionNodes.get(targetNodeName)) != null) {
                for (Object targetNode2 : targetDecisionNodes) {
                    this.addTransition(new PageflowBasicEdge(sourceNode, (PageflowNode)targetNode2, (Transition)transition.createStableCopy(), targetDecisionNodes.size() > 1 || allPageNodes.containsKey(targetNodeName) || allEndStates.containsKey(targetNodeName) || allProcessStates.containsKey(targetNodeName)));
                }
            }
            if ((list = allEndStates.get(targetNodeName)) != null) {
                Object targetNode2;
                targetNode2 = list.iterator();
                while (targetNode2.hasNext()) {
                    EndStateNode targetNode = (EndStateNode)targetNode2.next();
                    this.addTransition(new PageflowBasicEdge(sourceNode, targetNode, (Transition)transition.createStableCopy(), list.size() > 1 || allPageNodes.containsKey(targetNodeName) || allDecisionNodes.containsKey(targetNodeName) || allProcessStates.containsKey(targetNodeName)));
                }
            }
            if ((targetProcessStateNodes = allProcessStates.get(targetNodeName)) == null) continue;
            for (ProcessStateNode targetNode : targetProcessStateNodes) {
                this.addTransition(new PageflowBasicEdge(sourceNode, targetNode, (Transition)transition.createStableCopy(), targetProcessStateNodes.size() > 1 || allPageNodes.containsKey(targetNodeName) || allDecisionNodes.containsKey(targetNodeName) || allEndStates.containsKey(targetNodeName)));
            }
        }
    }

    private void addNode(PageflowNode node) {
        this.myNodes.add(node);
    }

    private void addTransition(PageflowEdge edge) {
        this.myEdges.add(edge);
    }

    private Map<String, List<DecisionNode>> getDecisionNodes(PageflowDefinition pageflowDefinition) {
        HashMap<String, List<DecisionNode>> decisions = new HashMap<String, List<DecisionNode>>();
        for (Decision decision : pageflowDefinition.getDecisions()) {
            String name = decision.getName().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                name = UNDEFINED_NAME;
            }
            if (!decisions.containsKey(name)) {
                decisions.put(name, new ArrayList());
            }
            DecisionNode decisionNode = new DecisionNode(name, (Decision)decision.createStableCopy());
            this.addNode(decisionNode);
            ((List)decisions.get(name)).add(decisionNode);
        }
        return decisions;
    }

    private Map<String, List<PageNode>> getPageNodes(PageflowDefinition pageflowDefinition) {
        HashMap<String, List<PageNode>> pages = new HashMap<String, List<PageNode>>();
        for (Page page : pageflowDefinition.getPages()) {
            this.addPageNode(pages, page);
        }
        this.addPageNode(pages, pageflowDefinition.getStartPage());
        return pages;
    }

    private void addPageNode(Map<String, List<PageNode>> pages, PageElements page) {
        if (!DomUtil.hasXml((DomElement)page)) {
            return;
        }
        String name = page.getName().getStringValue();
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            name = UNDEFINED_NAME;
        }
        if (!pages.containsKey(name)) {
            pages.put(name, new ArrayList());
        }
        PageNode pageNode = new PageNode(name, (PageElements)page.createStableCopy());
        pages.get(name).add(pageNode);
        this.addNode(pageNode);
    }

    @Nullable
    public PageflowDefinition getPageflowDefinition() {
        PageflowModel model = this.getModel();
        if (model == null || model.getRoots().size() != 1) {
            return null;
        }
        return (PageflowDefinition)((DomFileElement)model.getRoots().get(0)).getRootElement();
    }

    public PageflowModel getModel() {
        return PageflowDomModelManager.getInstance(this.myProject).getPageflowModel(this.myFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/seam/graph/PageflowDataModel";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/seam/graph/PageflowDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createEdge$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

