/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.usageView.UsageInfo;
import org.jetbrains.android.refactoring.AppCompatMigrationEntry;
import org.jetbrains.android.refactoring.MigrateToAppCompatUtil;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class MigrateToAppCompatUsageInfo
extends UsageInfo {
    MigrateToAppCompatUsageInfo(@NotNull PsiReference reference) {
        if (reference == null) {
            MigrateToAppCompatUsageInfo.$$$reportNull$$$0(0);
        }
        super(reference);
    }

    MigrateToAppCompatUsageInfo(@NotNull PsiElement element) {
        if (element == null) {
            MigrateToAppCompatUsageInfo.$$$reportNull$$$0(1);
        }
        super(element);
    }

    @Nullable
    public abstract PsiElement applyChange(@NotNull PsiMigration var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "reference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ChangeXmlAttrValueUsageInfo
    extends MigrateToAppCompatUsageInfo {
        private final AppCompatMigrationEntry.AttributeValueMigrationEntry myEntry;

        ChangeXmlAttrValueUsageInfo(@NotNull PsiElement element, @NotNull AppCompatMigrationEntry.AttributeValueMigrationEntry entry) {
            if (element == null) {
                ChangeXmlAttrValueUsageInfo.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                ChangeXmlAttrValueUsageInfo.$$$reportNull$$$0(1);
            }
            super(element);
            this.myEntry = entry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            PsiElement element;
            XmlAttribute currentAttr;
            if (migration == null) {
                ChangeXmlAttrValueUsageInfo.$$$reportNull$$$0(2);
            }
            if ((currentAttr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)(element = this.getElement()), XmlAttribute.class, (boolean)false)) == null) {
                return null;
            }
            PsiFile file = element.getContainingFile();
            assert (file instanceof XmlFile);
            currentAttr.setValue(this.myEntry.myNewAttrValue);
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ChangeXmlAttrValueUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ChangeXmlAttrUsageInfo
    extends MigrateToAppCompatUsageInfo {
        private final AppCompatMigrationEntry.AttributeMigrationEntry myEntry;

        ChangeXmlAttrUsageInfo(@NotNull PsiElement element, @NotNull AppCompatMigrationEntry.AttributeMigrationEntry entry) {
            if (element == null) {
                ChangeXmlAttrUsageInfo.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                ChangeXmlAttrUsageInfo.$$$reportNull$$$0(1);
            }
            super(element);
            this.myEntry = entry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            PsiElement element;
            XmlAttribute currentAttr;
            if (migration == null) {
                ChangeXmlAttrUsageInfo.$$$reportNull$$$0(2);
            }
            if ((currentAttr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)(element = this.getElement()), XmlAttribute.class, (boolean)false)) == null || !currentAttr.getLocalName().equals(this.myEntry.myOldAttributeName)) {
                return element;
            }
            PsiFile file = element.getContainingFile();
            assert (file instanceof XmlFile);
            if (StringUtil.isEmpty((String)this.myEntry.myNewNamespace)) {
                currentAttr.setName(this.myEntry.myNewAttributeName);
            } else {
                String prefixUsed = AndroidResourceUtil.ensureNamespaceImported((XmlFile)file, this.myEntry.myNewNamespace, null);
                currentAttr.setName(prefixUsed + ":" + this.myEntry.myNewAttributeName);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ChangeXmlAttrUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ChangeXmlTagUsageInfo
    extends MigrateToAppCompatUsageInfo {
        private final AppCompatMigrationEntry.XmlTagMigrationEntry myEntry;

        ChangeXmlTagUsageInfo(@NotNull PsiElement element, @NotNull AppCompatMigrationEntry.XmlTagMigrationEntry entry) {
            if (element == null) {
                ChangeXmlTagUsageInfo.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                ChangeXmlTagUsageInfo.$$$reportNull$$$0(1);
            }
            super(element);
            this.myEntry = entry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            PsiElement element;
            XmlTag xmlTag;
            if (migration == null) {
                ChangeXmlTagUsageInfo.$$$reportNull$$$0(2);
            }
            if ((xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(element = this.getElement()), XmlTag.class, (boolean)false)) == null || !xmlTag.getLocalName().equals(this.myEntry.myOldTagName)) {
                return element;
            }
            PsiFile file = element.getContainingFile();
            assert (file instanceof XmlFile);
            if (!StringUtil.isEmpty((String)this.myEntry.myNewNamespace)) {
                String prefixUsed = AndroidResourceUtil.ensureNamespaceImported((XmlFile)file, this.myEntry.myNewNamespace, null);
                xmlTag.setName(prefixUsed + ":" + this.myEntry.myNewTagName);
            } else {
                xmlTag.setName(this.myEntry.myNewTagName);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ChangeXmlTagUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ReplaceMethodUsageInfo
    extends MigrateToAppCompatUsageInfo {
        private final AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry myEntry;

        ReplaceMethodUsageInfo(@NotNull PsiReference element, @NotNull AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry entry) {
            if (element == null) {
                ReplaceMethodUsageInfo.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                ReplaceMethodUsageInfo.$$$reportNull$$$0(1);
            }
            super(element);
            this.myEntry = entry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration psiMigration) {
            PsiElement element;
            if (psiMigration == null) {
                ReplaceMethodUsageInfo.$$$reportNull$$$0(2);
            }
            if (!((element = this.getElement()) instanceof PsiReference) || !this.isValid()) {
                return null;
            }
            PsiReference reference = (PsiReference)element;
            PsiClass psiClass = MigrateToAppCompatUtil.findOrCreateClass(this.getProject(), psiMigration, this.myEntry.myNewClassName);
            String methodFragment = this.myEntry.myNewMethodName;
            if (!(element instanceof PsiReferenceExpression) || ((PsiReferenceExpression)element).getQualifierExpression() == null) {
                return null;
            }
            PsiMethodCallExpression oldMethodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiMethodCallExpression.class);
            if (oldMethodCall == null) {
                return null;
            }
            PsiExpressionList argList = oldMethodCall.getArgumentList();
            PsiExpression qualifierExpression = ((PsiReferenceExpression)element).getQualifierExpression();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            String methodCallText = "Foo." + methodFragment + "()";
            PsiMethodCallExpression call = (PsiMethodCallExpression)factory.createExpressionFromText(methodCallText, null);
            PsiExpressionList newArgList = call.getArgumentList();
            PsiExpression[] prevExpressions = argList.getExpressions();
            if (prevExpressions.length == 0) {
                newArgList.add((PsiElement)qualifierExpression);
            } else {
                for (int i = 0; i < prevExpressions.length; ++i) {
                    PsiExpression arg = prevExpressions[i];
                    if (this.myEntry.myQualifierParamIndex == i) {
                        newArgList.add((PsiElement)qualifierExpression);
                    }
                    newArgList.add((PsiElement)arg);
                }
            }
            ((PsiReferenceExpression)call.getMethodExpression().getQualifierExpression()).bindToElement((PsiElement)psiClass);
            return oldMethodCall.replace((PsiElement)call);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiMigration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ReplaceMethodUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ChangeCustomViewUsageInfo
    extends MigrateToAppCompatUsageInfo {
        private final String mySuggestedSuperClass;

        ChangeCustomViewUsageInfo(@NotNull PsiElement element, @NotNull String suggestedSuperClass) {
            if (element == null) {
                ChangeCustomViewUsageInfo.$$$reportNull$$$0(0);
            }
            if (suggestedSuperClass == null) {
                ChangeCustomViewUsageInfo.$$$reportNull$$$0(1);
            }
            super(element);
            this.mySuggestedSuperClass = suggestedSuperClass;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            if (migration == null) {
                ChangeCustomViewUsageInfo.$$$reportNull$$$0(2);
            }
            PsiClass psiClass = MigrateToAppCompatUtil.findOrCreateClass(this.getProject(), migration, this.mySuggestedSuperClass);
            PsiElement element = this.getElement();
            assert (element != null);
            if (!element.isValid()) {
                return null;
            }
            PsiReference reference = element.getReference();
            if (reference != null) {
                return reference.bindToElement((PsiElement)psiClass);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suggestedSuperClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ChangeCustomViewUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ChangeThemeUsageInfo
    extends ChangeStyleUsageInfo {
        ChangeThemeUsageInfo(@NotNull XmlAttributeValue element, @NotNull String fromValue, @NotNull String toValue) {
            if (element == null) {
                ChangeThemeUsageInfo.$$$reportNull$$$0(0);
            }
            if (fromValue == null) {
                ChangeThemeUsageInfo.$$$reportNull$$$0(1);
            }
            if (toValue == null) {
                ChangeThemeUsageInfo.$$$reportNull$$$0(2);
            }
            super((PsiElement)element, fromValue, toValue);
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            XmlAttributeValue attributeValue;
            if (migration == null) {
                ChangeThemeUsageInfo.$$$reportNull$$$0(3);
            }
            if ((attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlAttributeValue.class, (boolean)false)) == null) {
                return null;
            }
            String value = attributeValue.getValue();
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlAttribute.class, (boolean)true);
            if (attribute != null && value != null && value.equals(this.myFromValue)) {
                attribute.setValue(this.myToValue);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ChangeThemeUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ChangeStyleUsageInfo
    extends MigrateToAppCompatUsageInfo {
        protected final String myFromValue;
        protected final String myToValue;

        ChangeStyleUsageInfo(@NotNull PsiElement element, @NotNull String fromValue, @NotNull String toValue) {
            if (element == null) {
                ChangeStyleUsageInfo.$$$reportNull$$$0(0);
            }
            if (fromValue == null) {
                ChangeStyleUsageInfo.$$$reportNull$$$0(1);
            }
            if (toValue == null) {
                ChangeStyleUsageInfo.$$$reportNull$$$0(2);
            }
            super(element);
            this.myFromValue = fromValue;
            this.myToValue = toValue;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            XmlAttributeValue attributeValue;
            PsiElement element;
            XmlTag tag;
            if (migration == null) {
                ChangeStyleUsageInfo.$$$reportNull$$$0(3);
            }
            if ((tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(element = this.getElement()), XmlTag.class, (boolean)false)) == null) {
                return null;
            }
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class, (boolean)false);
            XmlAttributeValue xmlAttributeValue = attributeValue = attribute == null ? null : attribute.getValueElement();
            if (attribute != null && attributeValue != null) {
                tag.setAttribute(attribute.getName(), this.myToValue);
            } else {
                XmlTagValue tagValue = tag.getValue();
                tagValue.setText(this.myToValue);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ChangeStyleUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ClassMigrationUsageInfo
    extends MigrateToAppCompatUsageInfo {
        final AppCompatMigrationEntry.ClassMigrationEntry mapEntry;

        ClassMigrationUsageInfo(@NotNull UsageInfo info, @NotNull AppCompatMigrationEntry.ClassMigrationEntry mapEntry) {
            if (info == null) {
                ClassMigrationUsageInfo.$$$reportNull$$$0(0);
            }
            if (mapEntry == null) {
                ClassMigrationUsageInfo.$$$reportNull$$$0(1);
            }
            super(info.getElement());
            this.mapEntry = mapEntry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration psiMigration) {
            if (psiMigration == null) {
                ClassMigrationUsageInfo.$$$reportNull$$$0(2);
            }
            PsiClass aClass = MigrateToAppCompatUtil.findOrCreateClass(this.getProject(), psiMigration, this.mapEntry.myNewName);
            PsiElement element = this.getElement();
            if (element == null || !element.isValid()) {
                return element;
            }
            if (element instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element;
                return referenceElement.bindToElement((PsiElement)aClass);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapEntry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiMigration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ClassMigrationUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ChangeMethodUsageInfo
    extends MigrateToAppCompatUsageInfo {
        final AppCompatMigrationEntry.MethodMigrationEntry myEntry;

        ChangeMethodUsageInfo(PsiReference ref, @NotNull AppCompatMigrationEntry.MethodMigrationEntry entry) {
            if (entry == null) {
                ChangeMethodUsageInfo.$$$reportNull$$$0(0);
            }
            super(ref);
            this.myEntry = entry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            PsiElement element;
            if (migration == null) {
                ChangeMethodUsageInfo.$$$reportNull$$$0(1);
            }
            if ((element = this.getElement()) instanceof PsiReference && this.isValid()) {
                PsiReference reference = (PsiReference)element;
                String newName2 = this.myEntry.myNewMethodName;
                return reference.handleElementRename(newName2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ChangeMethodUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

