/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.repository.GradleVersion;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.templates.IdeGoogleMavenRepository;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.SmartHashSet;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AppCompatMigrationEntry;
import org.jetbrains.android.refactoring.AppCompatPublicDotTxtLookup;
import org.jetbrains.android.refactoring.AppCompatStyleMigration;
import org.jetbrains.android.refactoring.MigrateToAppCompatUsageInfo;
import org.jetbrains.android.refactoring.MigrateToAppCompatUsageViewDescriptor;
import org.jetbrains.android.refactoring.MigrateToAppCompatUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrateToAppCompatProcessor
extends BaseRefactoringProcessor {
    static final int MIGRATION_ENTRY_SIZE = 35;
    static final String ATTR_ACTION_VIEW_CLASS = "actionViewClass";
    static final String ANDROID_WIDGET_SEARCH_VIEW_CLASS = "android.widget.SearchView";
    static final String SUPPORT_V7_WIDGET_SEARCH_VIEW_CLASS = "android.support.v7.widget.SearchView";
    static final String ANDROID_WIDGET_SHARE_PROVIDER_CLASS = "android.widget.ShareActionProvider";
    static final String ATTR_ACTION_PROVIDER_CLASS = "actionProviderClass";
    static final String CLASS_SUPPORT_FRAGMENT_ACTIVITY = "android.support.v4.app.FragmentActivity";
    private final Module[] myModules;
    private final List<AppCompatMigrationEntry> myMigrationMap;
    private AppCompatStyleMigration myAppCompatStyleMigration;
    private PsiElement[] myElements;
    private final boolean myCreateAppCompatStyleInstance;
    private List<SmartPsiElementPointer<PsiElement>> myRefsToShorten;
    private List<MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo> myClassMigrations;
    private final Set<VirtualFile> myPsiFilesWithActivityImports;
    private final Set<VirtualFile> myPsiFilesWithFragmentActivityImports;
    private PsiMigration myPsiMigration;

    protected MigrateToAppCompatProcessor(@NotNull Project project) {
        if (project == null) {
            MigrateToAppCompatProcessor.$$$reportNull$$$0(0);
        }
        this(project, MigrateToAppCompatProcessor.buildMigrationMap(), null);
    }

    protected MigrateToAppCompatProcessor(Project project, List<AppCompatMigrationEntry> migrationMap, @Nullable AppCompatStyleMigration appCompatStyleMigration) {
        super(project, null);
        this.myElements = PsiElement.EMPTY_ARRAY;
        this.myModules = ModuleManager.getInstance((Project)project).getModules();
        this.myMigrationMap = migrationMap;
        this.myAppCompatStyleMigration = appCompatStyleMigration;
        this.myCreateAppCompatStyleInstance = this.myAppCompatStyleMigration == null;
        this.myPsiFilesWithFragmentActivityImports = new SmartHashSet();
        this.myPsiFilesWithActivityImports = new SmartHashSet();
        this.myPsiMigration = this.startMigration(project);
    }

    private PsiMigration startMigration(Project project) {
        return PsiMigrationManager.getInstance((Project)project).startMigration();
    }

    @NotNull
    static List<AppCompatMigrationEntry> buildMigrationMap() {
        ArrayList mapEntries = Lists.newArrayListWithExpectedSize((int)35);
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.app.Activity", "android.support.v7.app.AppCompatActivity"));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.support.v7.app.ActionBarActivity", "android.support.v7.app.AppCompatActivity"));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry(CLASS_SUPPORT_FRAGMENT_ACTIVITY, "android.support.v7.app.AppCompatActivity"));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.app.ActionBar", "android.support.v7.app.ActionBar"));
        mapEntries.add(new AppCompatMigrationEntry.MethodMigrationEntry("android.app.Activity", "getActionBar", "android.support.v7.app.AppCompatActivity", "getSupportActionBar"));
        mapEntries.add(new AppCompatMigrationEntry.MethodMigrationEntry("android.app.Activity", "setActionBar", "android.support.v7.app.AppCompatActivity", "setSupportActionBar"));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.widget.Toolbar", "android.support.v7.widget.Toolbar"));
        mapEntries.add(new AppCompatMigrationEntry.XmlTagMigrationEntry("android.widget.Toolbar", "", "android.support.v7.widget.Toolbar", "", 1));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.app.Fragment", "android.support.v4.app.Fragment"));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.app.FragmentTransaction", "android.support.v4.app.FragmentTransaction"));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.app.FragmentManager", "android.support.v4.app.FragmentManager"));
        mapEntries.add(new AppCompatMigrationEntry.MethodMigrationEntry("android.app.Activity", "getFragmentManager", "android.support.v7.app.AppCompatActivity", "getSupportFragmentManager"));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.app.AlertDialog", "android.support.v7.app.AlertDialog"));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry(ANDROID_WIDGET_SEARCH_VIEW_CLASS, SUPPORT_V7_WIDGET_SEARCH_VIEW_CLASS));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry(ANDROID_WIDGET_SHARE_PROVIDER_CLASS, "android.support.v7.widget.ShareActionProvider"));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.view.ActionProvider", "android.support.v4.view.ActionProvider"));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "getActionProvider", "android.support.v4.view.MenuItemCompat", "getActionProvider", 0));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "getActionView", "android.support.v4.view.MenuItemCompat", "getActionView", 0));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "collapseActionView", "android.support.v4.view.MenuItemCompat", "collapseActionView", 0));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "expandActionView", "android.support.v4.view.MenuItemCompat", "expandActionView", 0));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "setActionProvider", "android.support.v4.view.MenuItemCompat", "setActionProvider", 0));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "setActionView", "android.support.v4.view.MenuItemCompat", "setActionView", 0));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "isActionViewExpanded", "android.support.v4.view.MenuItemCompat", "isActionViewExpanded", 0));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "setShowAsAction", "android.support.v4.view.MenuItemCompat", "setShowAsAction", 0));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.view.MenuItem.OnActionExpandListener", "android.support.v4.view.MenuItemCompat.OnActionExpandListener"));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "setOnActionExpandListener", "android.support.v4.view.MenuItemCompat", "setOnActionExpandListener", 0));
        mapEntries.add(new AppCompatMigrationEntry.AttributeMigrationEntry("showAsAction", "http://schemas.android.com/apk/res/android", "showAsAction", "http://schemas.android.com/apk/res-auto", 2, "item"));
        mapEntries.add(new AppCompatMigrationEntry.AttributeMigrationEntry(ATTR_ACTION_VIEW_CLASS, "http://schemas.android.com/apk/res/android", ATTR_ACTION_VIEW_CLASS, "http://schemas.android.com/apk/res-auto", 2, "item"));
        mapEntries.add(new AppCompatMigrationEntry.AttributeValueMigrationEntry(ANDROID_WIDGET_SEARCH_VIEW_CLASS, SUPPORT_V7_WIDGET_SEARCH_VIEW_CLASS, ATTR_ACTION_VIEW_CLASS, "http://schemas.android.com/apk/res/android", 2, "item"));
        mapEntries.add(new AppCompatMigrationEntry.AttributeMigrationEntry(ATTR_ACTION_PROVIDER_CLASS, "http://schemas.android.com/apk/res/android", ATTR_ACTION_PROVIDER_CLASS, "http://schemas.android.com/apk/res-auto", 2, "item"));
        mapEntries.add(new AppCompatMigrationEntry.AttributeValueMigrationEntry(ANDROID_WIDGET_SHARE_PROVIDER_CLASS, "android.support.v7.widget.ShareActionProvider", ATTR_ACTION_PROVIDER_CLASS, "http://schemas.android.com/apk/res/android", 2, "item"));
        mapEntries.add(new AppCompatMigrationEntry(3));
        mapEntries.add(new AppCompatMigrationEntry(4));
        mapEntries.add(new AppCompatMigrationEntry.AttributeMigrationEntry("src", "http://schemas.android.com/apk/res/android", "srcCompat", "http://schemas.android.com/apk/res-auto", 1, "ImageView", "ImageButton"));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.widget.ListPopupWindow", "android.support.v7.widget.ListPopupWindow"));
        ImmutableList immutableList = ImmutableList.copyOf((Collection)mapEntries);
        if (immutableList == null) {
            MigrateToAppCompatProcessor.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            MigrateToAppCompatProcessor.$$$reportNull$$$0(2);
        }
        MigrateToAppCompatUsageViewDescriptor migrateToAppCompatUsageViewDescriptor = new MigrateToAppCompatUsageViewDescriptor(this.myElements);
        if (migrateToAppCompatUsageViewDescriptor == null) {
            MigrateToAppCompatProcessor.$$$reportNull$$$0(3);
        }
        return migrateToAppCompatUsageViewDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected UsageInfo[] findUsages() {
        this.myPsiFilesWithFragmentActivityImports.clear();
        this.myPsiFilesWithActivityImports.clear();
        if (this.myCreateAppCompatStyleInstance) {
            this.createAppCompatStyleMigration();
        }
        ArrayList<UsageInfo> infos = new ArrayList<UsageInfo>();
        try {
            ArrayList menuXmlOperations = Lists.newArrayListWithExpectedSize((int)10);
            ArrayList layoutXmlOperations = Lists.newArrayListWithExpectedSize((int)10);
            for (AppCompatMigrationEntry entry : this.myMigrationMap) {
                switch (entry.getType()) {
                    case 1: {
                        AppCompatMigrationEntry.ClassMigrationEntry classMigrationEntry = (AppCompatMigrationEntry.ClassMigrationEntry)entry;
                        List<UsageInfo> usages = MigrateToAppCompatUtil.findClassUsages(this.myProject, classMigrationEntry.myOldName);
                        boolean isActivity = classMigrationEntry.myOldName.equals("android.app.Activity");
                        boolean isFragmentActivity = classMigrationEntry.myOldName.equals(CLASS_SUPPORT_FRAGMENT_ACTIVITY);
                        for (UsageInfo usageInfo : usages) {
                            PsiElement element = usageInfo.getElement();
                            if (isActivity) {
                                PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
                                if (psiMethod != null && (MethodUtils.hasSuper((PsiMethod)psiMethod) || MethodUtils.isOverridden((PsiMethod)psiMethod))) {
                                    VirtualFile containingFile = element.getContainingFile().getVirtualFile();
                                    this.myPsiFilesWithActivityImports.add(containingFile);
                                    continue;
                                }
                            } else if (isFragmentActivity && PsiTreeUtil.getParentOfType((PsiElement)element, PsiVariable.class) != null) {
                                VirtualFile containingFile = element.getContainingFile().getVirtualFile();
                                this.myPsiFilesWithFragmentActivityImports.add(containingFile);
                                continue;
                            }
                            infos.add(new MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo(usageInfo, classMigrationEntry));
                        }
                        break;
                    }
                    case 2: {
                        Module[] methodEntry = (Module[])entry;
                        Collection<PsiReference> refs = MigrateToAppCompatUtil.findChangeMethodRefs(this.myProject, (AppCompatMigrationEntry.MethodMigrationEntry)methodEntry);
                        for (PsiReference ref : refs) {
                            infos.add(new MigrateToAppCompatUsageInfo.ChangeMethodUsageInfo(ref, (AppCompatMigrationEntry.MethodMigrationEntry)methodEntry));
                        }
                        break;
                    }
                    case 3: {
                        for (Module module : this.myModules) {
                            AndroidFacet facet = AndroidFacet.getInstance(module);
                            if (facet == null) continue;
                            infos.addAll(this.myAppCompatStyleMigration.findStyleElementsToBeModified(this.myProject, facet));
                        }
                        break;
                    }
                    case 4: {
                        infos.addAll(MigrateToAppCompatUtil.findCustomViewsUsages(this.myProject, this.myModules));
                        break;
                    }
                    case 5: {
                        AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry callMigrationEntry = (AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry)entry;
                        Collection<PsiReference> refs = MigrateToAppCompatUtil.findChangeMethodRefs(this.myProject, callMigrationEntry);
                        for (PsiReference ref : refs) {
                            infos.add(new MigrateToAppCompatUsageInfo.ReplaceMethodUsageInfo(ref, callMigrationEntry));
                        }
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        AppCompatMigrationEntry.XmlElementMigration op = (AppCompatMigrationEntry.XmlElementMigration)entry;
                        if (op.isMenuOperation()) {
                            menuXmlOperations.add((AppCompatMigrationEntry.XmlElementMigration)entry);
                        }
                        if (!op.isLayoutOperation()) break;
                        layoutXmlOperations.add((AppCompatMigrationEntry.XmlElementMigration)entry);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled type " + entry.getType()));
                    }
                }
                infos.addAll(MigrateToAppCompatUtil.findUsagesOfXmlElements(this.myProject, this.myModules, menuXmlOperations, ResourceType.MENU));
                infos.addAll(MigrateToAppCompatUtil.findUsagesOfXmlElements(this.myProject, this.myModules, layoutXmlOperations, ResourceType.LAYOUT));
            }
        }
        finally {
            ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(this::finishMigration), this.myProject.getDisposed());
        }
        MigrateToAppCompatUtil.removeUnneededUsages(infos);
        UsageInfo[] usageInfoArray = infos.toArray(new UsageInfo[infos.size()]);
        if (usageInfoArray == null) {
            MigrateToAppCompatProcessor.$$$reportNull$$$0(4);
        }
        return usageInfoArray;
    }

    private void finishMigration() {
        if (this.myPsiMigration != null) {
            this.myPsiMigration.finish();
            this.myPsiMigration = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            MigrateToAppCompatProcessor.$$$reportNull$$$0(5);
        }
        this.finishMigration();
        PsiMigration psiMigration = PsiMigrationManager.getInstance((Project)this.myProject).startMigration();
        this.myClassMigrations = Lists.newArrayList();
        this.myRefsToShorten = Lists.newArrayList();
        try {
            CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.myProject);
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
            for (UsageInfo usage : usages) {
                PsiElement psiElement = null;
                if (usage instanceof MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo) {
                    MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo classMigrationUsageInfo = (MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo)usage;
                    this.myClassMigrations.add(classMigrationUsageInfo);
                    psiElement = classMigrationUsageInfo.applyChange(psiMigration);
                } else if (usage instanceof MigrateToAppCompatUsageInfo) {
                    psiElement = ((MigrateToAppCompatUsageInfo)usage).applyChange(psiMigration);
                }
                if (psiElement == null) continue;
                this.myRefsToShorten.add((SmartPsiElementPointer<PsiElement>)smartPointerManager.createSmartPsiElementPointer(psiElement));
            }
            for (Module module : this.computeModulesNeedingAppCompat()) {
                GradleBuildModel buildModel = GradleBuildModel.get(module);
                if (buildModel == null) continue;
                AndroidModel base = buildModel.android();
                String version = base == null ? null : (String)base.compileSdkVersion().value();
                JavaProjectModelModificationService.getInstance((Project)this.myProject).addDependency(module, (ExternalLibraryDescriptor)new AppCompatLibraryDescriptor(version));
            }
        }
        catch (IncorrectOperationException e) {
            RefactoringUIUtil.processIncorrectOperation((Project)this.myProject, (IncorrectOperationException)e);
        }
        finally {
            psiMigration.finish();
        }
    }

    protected void performPsiSpoilingRefactoring() {
        this.postProcessClassMigrations(this.myClassMigrations);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        for (SmartPsiElementPointer<PsiElement> pointer : this.myRefsToShorten) {
            PsiElement element = pointer.getElement();
            if (element == null) continue;
            styleManager.shortenClassReferences(element);
            styleManager.optimizeImports(element.getContainingFile());
        }
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.migrate.to.appcompat";
    }

    @NotNull
    protected String getCommandName() {
        String string = AndroidBundle.message("android.refactoring.migratetoappcompat", new Object[0]);
        if (string == null) {
            MigrateToAppCompatProcessor.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected boolean skipNonCodeUsages() {
        return true;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            MigrateToAppCompatProcessor.$$$reportNull$$$0(7);
        }
        this.finishMigration();
        this.myPsiMigration = this.startMigration(this.myProject);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            MigrateToAppCompatProcessor.$$$reportNull$$$0(8);
        }
        if (((UsageInfo[])refUsages.get()).length == 0) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                Messages.showInfoMessage((Project)this.myProject, (String)RefactoringBundle.message((String)"migration.no.usages.found.in.the.project"), (String)AndroidBundle.message("android.refactoring.migratetoappcompat", new Object[0]));
            }
            return false;
        }
        this.setPreviewUsages(true);
        return true;
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElements(this.myElements);
        return data;
    }

    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            MigrateToAppCompatProcessor.$$$reportNull$$$0(9);
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElements(this.myElements);
        return data;
    }

    Set<Module> computeModulesNeedingAppCompat() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Module[] sortedModules = moduleManager.getSortedModules();
        SmartHashSet modulesWithTransitiveAppCompat = new SmartHashSet();
        SmartHashSet modulesNeedingAppCompat = new SmartHashSet();
        for (Module module : sortedModules) {
            AndroidModuleModel model = AndroidModuleModel.get(module);
            if (model == null) continue;
            if (!modulesWithTransitiveAppCompat.contains(module) && !DependencyManagementUtil.dependsOn(module, GoogleMavenArtifactId.APP_COMPAT_V7)) {
                modulesNeedingAppCompat.add(module);
                modulesWithTransitiveAppCompat.add(module);
            }
            modulesWithTransitiveAppCompat.addAll(moduleManager.getModuleDependentModules(module));
        }
        return modulesNeedingAppCompat;
    }

    private void postProcessClassMigrations(List<MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo> classMigrations) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        PsiClass activityClass = psiFacade.findClass("android.app.Activity", scope);
        PsiClass fragmentActivityClass = psiFacade.findClass(CLASS_SUPPORT_FRAGMENT_ACTIVITY, scope);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        classMigrations.stream().filter(u -> u.getElement() != null && u.getElement().isValid()).map(u -> u.getElement() == null ? null : u.getElement().getContainingFile()).filter(Objects::nonNull).distinct().forEach(psiFile -> {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (this.myPsiFilesWithActivityImports.contains(virtualFile) && activityClass != null) {
                codeStyleManager.addImport((PsiJavaFile)psiFile, activityClass);
            } else if (this.myPsiFilesWithFragmentActivityImports.contains(virtualFile) && fragmentActivityClass != null) {
                codeStyleManager.addImport((PsiJavaFile)psiFile, fragmentActivityClass);
            }
            codeStyleManager.optimizeImports(psiFile);
        });
    }

    private void createAppCompatStyleMigration() {
        AndroidVersion highest = new AndroidVersion(21);
        for (Module module : this.myModules) {
            String version;
            GradleBuildModel build = GradleBuildModel.get(module);
            if (build == null || build.android() == null || (version = (String)build.android().compileSdkVersion().value()) == null) continue;
            try {
                AndroidVersion current = new AndroidVersion(StringUtil.trimStart((String)version, (String)"android-"));
                if (current.compareTo(highest) <= 0) continue;
                highest = current;
            }
            catch (AndroidVersion.AndroidVersionException androidVersionException) {
                // empty catch block
            }
        }
        AndroidVersion finalAndroidVersion = highest;
        Predicate<GradleVersion> filter = v -> v.toString().startsWith(Integer.toString(finalAndroidVersion.getApiLevel()));
        GradleVersion version = IdeGoogleMavenRepository.INSTANCE.findVersion(GoogleMavenArtifactId.APP_COMPAT_V7.getMavenGroupId(), GoogleMavenArtifactId.APP_COMPAT_V7.getMavenArtifactId(), filter, finalAndroidVersion.isPreview());
        this.myAppCompatStyleMigration = AppCompatPublicDotTxtLookup.getInstance().createAppCompatStyleMigration(version == null ? "26.1.0" : version.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/refactoring/MigrateToAppCompatProcessor";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMigrationMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AppCompatLibraryDescriptor
    extends ExternalLibraryDescriptor {
        private AppCompatLibraryDescriptor(@Nullable String minVersion) {
            super(GoogleMavenArtifactId.APP_COMPAT_V7.getMavenGroupId(), GoogleMavenArtifactId.APP_COMPAT_V7.getMavenArtifactId(), minVersion, null);
        }

        @NotNull
        public List<String> getLibraryClassesRoots() {
            List<String> list = Collections.emptyList();
            if (list == null) {
                AppCompatLibraryDescriptor.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/MigrateToAppCompatProcessor$AppCompatLibraryDescriptor", "getLibraryClassesRoots"));
        }
    }
}

