/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.resources.StyleItem;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.util.ErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRefactoringUtil {
    private AndroidRefactoringUtil() {
    }

    @Nullable
    static StyleRefData getParentStyle(@NotNull Style style) {
        ResourceValue parentStyleRefValue;
        if (style == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(0);
        }
        if ((parentStyleRefValue = (ResourceValue)style.getParentStyle().getValue()) != null) {
            String parentStyleName = parentStyleRefValue.getResourceName();
            if (parentStyleName != null) {
                return new StyleRefData(parentStyleName, parentStyleRefValue.getNamespace());
            }
        } else {
            int idx;
            String styleName = style.getName().getStringValue();
            if (styleName != null && (idx = styleName.lastIndexOf(46)) > 0) {
                return new StyleRefData(styleName.substring(0, idx), null);
            }
        }
        return null;
    }

    @Nullable
    static Map<AndroidAttributeInfo, String> computeAttributeMap(@NotNull Style style, @NotNull ErrorReporter errorReporter, @NotNull String errorReportTitle) {
        if (style == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(1);
        }
        if (errorReporter == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(2);
        }
        if (errorReportTitle == null) {
            AndroidRefactoringUtil.$$$reportNull$$$0(3);
        }
        HashMap attributeValues = new HashMap();
        for (StyleItem item : style.getItems()) {
            String nsPrefix;
            String attributeName = item.getName().getStringValue();
            String attributeValue = item.getStringValue();
            if (attributeName == null || attributeName.length() <= 0 || attributeValue == null) continue;
            int idx = attributeName.indexOf(58);
            String localName = idx >= 0 ? attributeName.substring(idx + 1) : attributeName;
            String string = nsPrefix = idx >= 0 ? attributeName.substring(0, idx) : null;
            if (nsPrefix != null) {
                if (!"android".equals(nsPrefix)) {
                    errorReporter.report(RefactoringBundle.getCannotRefactorMessage((String)("Unknown XML attribute prefix '" + nsPrefix + ":'")), errorReportTitle);
                    return null;
                }
            } else {
                errorReporter.report(RefactoringBundle.getCannotRefactorMessage((String)"The style contains attribute without 'android' prefix."), errorReportTitle);
                return null;
            }
            attributeValues.put(new AndroidAttributeInfo(localName, nsPrefix), attributeValue);
        }
        return attributeValues;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorReporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorReportTitle";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/refactoring/AndroidRefactoringUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentStyle";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "computeAttributeMap";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

