/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.newProject;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFrameworkDetector;
import org.jetbrains.android.importDependencies.ImportDependenciesUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.importWizard.EclipseNatureImporter;

public class AndroidEclipseNatureImporter
extends EclipseNatureImporter {
    private static final Set<String> ADT_INTERNAL_LIBS = new HashSet(Arrays.asList("com.android.ide.eclipse.adt.ANDROID_FRAMEWORK", "com.android.ide.eclipse.adt.LIBRARIES"));

    @NotNull
    public String getNatureName() {
        if ("com.android.ide.eclipse.adt.AndroidNature" == null) {
            AndroidEclipseNatureImporter.$$$reportNull$$$0(0);
        }
        return "com.android.ide.eclipse.adt.AndroidNature";
    }

    public Set<String> getProvidedCons() {
        return ADT_INTERNAL_LIBS;
    }

    public void doImport(@NotNull Project project, @NotNull List<Module> modules) {
        if (project == null) {
            AndroidEclipseNatureImporter.$$$reportNull$$$0(1);
        }
        if (modules == null) {
            AndroidEclipseNatureImporter.$$$reportNull$$$0(2);
        }
        for (Module module : modules) {
            VirtualFile contentRoot = AndroidEclipseNatureImporter.chooseMainContentRoot(module);
            if (contentRoot == null) {
                AndroidUtils.reportImportErrorToEventLog("Cannot find content root containing AndroidManifest.xml file", module.getName(), project);
                continue;
            }
            AndroidFacet facet = AndroidUtils.addAndroidFacetInWriteAction(module, contentRoot, false);
            final ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            AndroidFrameworkDetector.doImportSdkAndFacetConfiguration(facet, modifiableModel);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    modifiableModel.commit();
                }
            });
        }
        ImportDependenciesUtil.doImportDependencies(project, modules, true);
    }

    @Nullable
    private static VirtualFile chooseMainContentRoot(@NotNull Module module) {
        VirtualFile[] roots;
        if (module == null) {
            AndroidEclipseNatureImporter.$$$reportNull$$$0(3);
        }
        if ((roots = ModuleRootManager.getInstance((Module)module).getContentRoots()).length == 0) {
            return null;
        }
        if (roots.length == 1) {
            return roots[0];
        }
        for (VirtualFile root : roots) {
            if (root.findChild("AndroidManifest.xml") == null) continue;
            return root;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/newProject/AndroidEclipseNatureImporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNatureName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/newProject/AndroidEclipseNatureImporter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doImport";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "chooseMainContentRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

