/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.idea.lint.SuppressLintIntentionAction;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.collect.Lists;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.android.inspections.lint.AndroidLintExternalAnnotator;
import org.jetbrains.android.inspections.lint.AndroidLintGlobalInspectionContext;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFixProvider;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.android.inspections.lint.SetAttributeQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidLintInspectionBase
extends GlobalInspectionTool {
    public static final String LINT_INSPECTION_PREFIX = "AndroidLint";
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.lint.AndroidLintInspectionBase");
    private static final Object ISSUE_MAP_LOCK = new Object();
    private static volatile Map<Issue, String> ourIssue2InspectionShortName;
    private static volatile List<Tools> ourDynamicTools;
    private static boolean ourRegisterDynamicToolsFromTests;
    protected final Issue myIssue;
    private String[] myGroupPath;
    private final String myDisplayName;

    protected AndroidLintInspectionBase(@NotNull String displayName, @NotNull Issue issue2) {
        if (displayName == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(0);
        }
        if (issue2 == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(1);
        }
        this.myIssue = issue2;
        this.myDisplayName = displayName;
    }

    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        if (startElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(3);
        }
        if (message == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(4);
        }
        AndroidLintQuickFix[] fixes = this.getQuickFixes(startElement, endElement, message);
        if (fixData != null && fixes.length == 0) {
            AndroidLintQuickFix[] androidLintQuickFixArray = AndroidLintInspectionBase.createFixes(startElement.getContainingFile(), fixData);
            if (androidLintQuickFixArray == null) {
                AndroidLintInspectionBase.$$$reportNull$$$0(5);
            }
            return androidLintQuickFixArray;
        }
        if (fixes == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(6);
        }
        return fixes;
    }

    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(8);
        }
        if (message == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(9);
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = this.getQuickFixes(message);
        if (androidLintQuickFixArray == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(10);
        }
        return androidLintQuickFixArray;
    }

    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
        if (message == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(11);
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(12);
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }

    @NotNull
    public IntentionAction[] getIntentions(@NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (startElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(13);
        }
        if (endElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(14);
        }
        if (IntentionAction.EMPTY_ARRAY == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(15);
        }
        return IntentionAction.EMPTY_ARRAY;
    }

    public boolean isGraphNeeded() {
        return false;
    }

    @NotNull
    public AndroidLintQuickFix[] getAllFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData, @NotNull AndroidLintQuickFixProvider[] fixProviders, @NotNull Issue issue2) {
        if (startElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(16);
        }
        if (endElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(17);
        }
        if (message == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(18);
        }
        if (fixProviders == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(19);
        }
        if (issue2 == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(20);
        }
        ArrayList result = new ArrayList(4);
        PsiFile file = startElement.getContainingFile();
        if (file != null && AndroidLintExternalAnnotator.isKotlin(file.getFileType())) {
            for (AndroidLintQuickFixProvider provider : fixProviders) {
                AndroidLintQuickFix[] fixes = provider.getQuickFixes(issue2, startElement, endElement, message, fixData);
                Collections.addAll(result, fixes);
            }
            if (!(result.isEmpty() || fixData != null && result.size() == 1 && ((AndroidLintQuickFix)result.get(0)).getName().startsWith("Suppress: "))) {
                AndroidLintQuickFix[] androidLintQuickFixArray = result.toArray(AndroidLintQuickFix.EMPTY_ARRAY);
                if (androidLintQuickFixArray == null) {
                    AndroidLintInspectionBase.$$$reportNull$$$0(21);
                }
                return androidLintQuickFixArray;
            }
        }
        AndroidLintQuickFix[] fixes = this.getQuickFixes(startElement, endElement, message, fixData);
        Collections.addAll(result, fixes);
        AndroidLintQuickFix[] androidLintQuickFixArray = result.toArray(AndroidLintQuickFix.EMPTY_ARRAY);
        if (androidLintQuickFixArray == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(22);
        }
        return androidLintQuickFixArray;
    }

    @NotNull
    public LocalQuickFix[] getLocalQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData, @NotNull AndroidLintQuickFixProvider[] fixProviders, @NotNull Issue issue2) {
        AndroidLintQuickFix[] fixes;
        if (startElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(23);
        }
        if (endElement == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(24);
        }
        if (message == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(25);
        }
        if (fixProviders == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(26);
        }
        if (issue2 == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(27);
        }
        if ((fixes = this.getAllFixes(startElement, endElement, message, fixData, fixProviders, issue2)).length == 0) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                AndroidLintInspectionBase.$$$reportNull$$$0(28);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ArrayList<MyLocalQuickFix> result = new ArrayList<MyLocalQuickFix>(fixes.length);
        for (AndroidLintQuickFix fix : fixes) {
            if (!fix.isApplicable(startElement, endElement, AndroidQuickfixContexts.BatchContext.TYPE)) continue;
            result.add(new MyLocalQuickFix(fix));
        }
        LocalQuickFix[] localQuickFixArray = result.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(29);
        }
        return localQuickFixArray;
    }

    public void runInspection(@NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        AndroidLintGlobalInspectionContext androidLintContext;
        if (scope == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(30);
        }
        if (manager == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(31);
        }
        if (globalContext == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(32);
        }
        if (problemDescriptionsProcessor == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(33);
        }
        if ((androidLintContext = (AndroidLintGlobalInspectionContext)globalContext.getExtension(AndroidLintGlobalInspectionContext.ID)) == null) {
            return;
        }
        Map<Issue, Map<File, List<ProblemData>>> problemMap = androidLintContext.getResults();
        if (problemMap == null) {
            return;
        }
        Map<File, List<ProblemData>> file2ProblemList = problemMap.get(this.myIssue);
        if (file2ProblemList == null) {
            return;
        }
        for (Map.Entry<File, List<ProblemData>> entry : file2ProblemList.entrySet()) {
            File file = entry.getKey();
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (vFile == null) continue;
            ApplicationManager.getApplication().runReadAction(() -> {
                ProblemDescriptor[] descriptors;
                PsiDirectory psiDirectory;
                PsiManager psiManager;
                PsiFile psiFile;
                if (globalContext == null) {
                    AndroidLintInspectionBase.$$$reportNull$$$0(49);
                }
                if (manager == null) {
                    AndroidLintInspectionBase.$$$reportNull$$$0(50);
                }
                if (problemDescriptionsProcessor == null) {
                    AndroidLintInspectionBase.$$$reportNull$$$0(51);
                }
                if ((psiFile = (psiManager = PsiManager.getInstance((Project)globalContext.getProject())).findFile(vFile)) != null) {
                    ProblemDescriptor[] descriptors2 = this.computeProblemDescriptors((PsiElement)psiFile, manager, (List)entry.getValue());
                    if (descriptors2.length > 0) {
                        problemDescriptionsProcessor.addProblemElement((RefEntity)globalContext.getRefManager().getReference((PsiElement)psiFile), (CommonProblemDescriptor[])descriptors2);
                    }
                } else if (vFile.isDirectory() && (psiDirectory = psiManager.findDirectory(vFile)) != null && (descriptors = this.computeProblemDescriptors((PsiElement)psiDirectory, manager, (List)entry.getValue())).length > 0) {
                    problemDescriptionsProcessor.addProblemElement((RefEntity)globalContext.getRefManager().getReference((PsiElement)psiDirectory), (CommonProblemDescriptor[])descriptors);
                }
            });
        }
    }

    @NotNull
    private ProblemDescriptor[] computeProblemDescriptors(@NotNull PsiElement psiFile, @NotNull InspectionManager manager, @NotNull List<ProblemData> problems) {
        if (psiFile == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(34);
        }
        if (manager == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(35);
        }
        if (problems == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(36);
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        AndroidLintQuickFixProvider[] fixProviders = (AndroidLintQuickFixProvider[])AndroidLintQuickFixProvider.EP_NAME.getExtensions();
        for (ProblemData problemData : problems) {
            String originalMessage = problemData.getMessage();
            String formattedMessage = "<html>" + TextFormat.RAW.convertTo(originalMessage, TextFormat.HTML_WITH_UNICODE) + "</html>";
            LintFix quickfixData = problemData.getQuickfixData();
            TextRange range = problemData.getTextRange();
            Issue issue2 = problemData.getIssue();
            if (range.getStartOffset() == range.getEndOffset()) {
                if (psiFile instanceof PsiBinaryFile || psiFile instanceof PsiDirectory) {
                    LocalQuickFix[] fixes = this.getLocalQuickFixes(psiFile, psiFile, originalMessage, quickfixData, fixProviders, issue2);
                    result.add(new NonTextFileProblemDescriptor((PsiFileSystemItem)psiFile, formattedMessage, fixes));
                    continue;
                }
                if (this.isSuppressedFor(psiFile)) continue;
                result.add(manager.createProblemDescriptor(psiFile, formattedMessage, false, this.getLocalQuickFixes(psiFile, psiFile, originalMessage, quickfixData, fixProviders, issue2), ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                continue;
            }
            PsiElement startElement = psiFile.findElementAt(range.getStartOffset());
            PsiElement endElement = psiFile.findElementAt(range.getEndOffset() - 1);
            if (startElement == null || endElement == null || this.isSuppressedFor(startElement)) continue;
            result.add(manager.createProblemDescriptor(startElement, endElement, formattedMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, this.getLocalQuickFixes(startElement, endElement, originalMessage, quickfixData, fixProviders, issue2)));
        }
        ProblemDescriptor[] problemDescriptorArray = result.toArray(new ProblemDescriptor[result.size()]);
        if (problemDescriptorArray == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(37);
        }
        return problemDescriptorArray;
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        SuppressLintQuickFix suppressLintQuickFix = new SuppressLintQuickFix(this.myIssue);
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{suppressLintQuickFix};
        if (suppressQuickFixArray == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(38);
        }
        return suppressQuickFixArray;
    }

    public static void invalidateInspectionShortName2IssueMap() {
        ourIssue2InspectionShortName = null;
        ourDynamicTools = null;
    }

    public static void setRegisterDynamicToolsFromTests(boolean registerDynamicToolsFromTests) {
        ourRegisterDynamicToolsFromTests = registerDynamicToolsFromTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static List<Tools> getDynamicTools() {
        Object object = ISSUE_MAP_LOCK;
        synchronized (object) {
            return ourDynamicTools;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDynamicTools() {
        Object object = ISSUE_MAP_LOCK;
        synchronized (object) {
            ourDynamicTools = null;
        }
    }

    @Nullable
    public static Issue findIssueByShortName(@Nullable Project project, @NotNull String name) {
        if (name == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(39);
        }
        String inspectionName = name.startsWith(LINT_INSPECTION_PREFIX) ? name : LINT_INSPECTION_PREFIX + name;
        Issue issue2 = null;
        List<Tools> tools = AndroidLintInspectionBase.getDynamicTools();
        if (tools != null) {
            for (Tools tool : tools) {
                InspectionProfileEntry e;
                if (!inspectionName.equals(tool.getShortName()) || !((e = tool.getTool().getTool()) instanceof AndroidLintInspectionBase)) continue;
                issue2 = ((AndroidLintInspectionBase)e).getIssue();
                break;
            }
        }
        if (issue2 == null && project != null) {
            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
            for (InspectionToolWrapper e : profile.getInspectionTools(null)) {
                InspectionProfileEntry entry;
                if (!inspectionName.equals(e.getShortName()) || !((entry = e.getTool()) instanceof AndroidLintInspectionBase)) continue;
                issue2 = ((AndroidLintInspectionBase)entry).getIssue();
            }
        }
        return issue2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInspectionShortNameByIssue(@NotNull Project project, @NotNull Issue issue2) {
        if (project == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(40);
        }
        if (issue2 == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(41);
        }
        Object object = ISSUE_MAP_LOCK;
        synchronized (object) {
            String name;
            if (ourIssue2InspectionShortName == null) {
                ourIssue2InspectionShortName = new HashMap();
                InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
                for (InspectionToolWrapper e : profile.getInspectionTools(null)) {
                    InspectionProfileEntry entry;
                    String shortName = e.getShortName();
                    if (!shortName.startsWith(LINT_INSPECTION_PREFIX) || !((entry = e.getTool()) instanceof AndroidLintInspectionBase)) continue;
                    Issue s = ((AndroidLintInspectionBase)entry).getIssue();
                    ourIssue2InspectionShortName.put(s, shortName);
                }
            }
            if ((name = ourIssue2InspectionShortName.get(issue2)) == null && (!ApplicationManager.getApplication().isUnitTestMode() || ourRegisterDynamicToolsFromTests)) {
                AndroidLintInspectionBase tool = AndroidLintInspectionBase.createInspection(issue2);
                LintInspectionFactory factory = new LintInspectionFactory(tool);
                InspectionProfileImpl base = InspectionProfileKt.getBASE_PROFILE();
                InspectionProfileImpl current = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
                base.addTool(project, (InspectionToolWrapper)factory, (Map)new THashMap());
                current.addTool(project, (InspectionToolWrapper)factory, (Map)new THashMap());
                name = tool.getShortName();
                ourIssue2InspectionShortName.put(issue2, name);
                ToolsImpl tools = current.getToolsOrNull(name, project);
                if (tools != null) {
                    if (ourDynamicTools == null) {
                        ourDynamicTools = new ArrayList<Tools>();
                    }
                    ourDynamicTools.add((Tools)tools);
                }
            }
            return name;
        }
    }

    private static AndroidLintInspectionBase createInspection(Issue issue2) {
        return new AndroidLintInspectionBase(issue2.getBriefDescription(TextFormat.TEXT), issue2){};
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        Category category = this.myIssue.getCategory();
        while (category.getParent() != null) {
            category = category.getParent();
        }
        String string = AndroidBundle.message("android.lint.inspections.group.name", new Object[0]) + ": " + category.getName();
        if (string == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    public String[] getGroupPath() {
        if (this.myGroupPath == null) {
            Category category = this.myIssue.getCategory();
            int count = 2;
            for (Category curr = category; curr != null; curr = curr.getParent()) {
                ++count;
            }
            String[] path = new String[count];
            while (category != null) {
                path[--count] = category.getName();
                category = category.getParent();
            }
            assert (count == 2);
            path[0] = AndroidBundle.message("android.inspections.group.name", new Object[0]);
            path[1] = AndroidBundle.message("android.lint.inspections.subgroup.name", new Object[0]);
            this.myGroupPath = path;
        }
        if (this.myGroupPath == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(43);
        }
        return this.myGroupPath;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(44);
        }
        return string;
    }

    public String getStaticDescription() {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("<html><body>");
        sb.append(this.myIssue.getBriefDescription(TextFormat.HTML));
        sb.append("<br><br>");
        sb.append(this.myIssue.getExplanation(TextFormat.HTML));
        List urls = this.myIssue.getMoreInfo();
        if (!urls.isEmpty()) {
            boolean separated = false;
            for (String url : urls) {
                if (this.myIssue.getExplanation(TextFormat.RAW).contains(url)) continue;
                if (!separated) {
                    sb.append("<br><br>");
                    separated = true;
                } else {
                    sb.append("<br>");
                }
                sb.append("<a href=\"");
                sb.append(url);
                sb.append("\">");
                sb.append(url);
                sb.append("</a>");
            }
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    public boolean isEnabledByDefault() {
        return this.myIssue.isEnabledByDefault();
    }

    @NotNull
    public String getShortName() {
        String string = LINT_INSPECTION_PREFIX + this.myIssue.getId();
        if (string == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        Severity defaultSeverity = this.myIssue.getDefaultSeverity();
        HighlightDisplayLevel displayLevel = AndroidLintInspectionBase.toHighlightDisplayLevel(defaultSeverity);
        HighlightDisplayLevel highlightDisplayLevel = displayLevel != null ? displayLevel : HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(46);
        }
        return highlightDisplayLevel;
    }

    @Nullable
    static HighlightDisplayLevel toHighlightDisplayLevel(@NotNull Severity severity) {
        if (severity == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(47);
        }
        switch (severity) {
            case ERROR: {
                return HighlightDisplayLevel.ERROR;
            }
            case FATAL: {
                return HighlightDisplayLevel.ERROR;
            }
            case WARNING: {
                return HighlightDisplayLevel.WARNING;
            }
            case INFORMATIONAL: {
                return HighlightDisplayLevel.WEAK_WARNING;
            }
            case IGNORE: {
                return null;
            }
        }
        LOG.error("Unknown severity " + severity);
        return null;
    }

    private static boolean isSingleFileScope(EnumSet<Scope> scopes) {
        if (scopes.size() != 1) {
            return false;
        }
        Scope scope = (Scope)scopes.iterator().next();
        return scope == Scope.JAVA_FILE || scope == Scope.RESOURCE_FILE || scope == Scope.MANIFEST || scope == Scope.PROGUARD_FILE || scope == Scope.OTHER;
    }

    public boolean worksInBatchModeOnly() {
        Implementation implementation = this.myIssue.getImplementation();
        if (AndroidLintInspectionBase.isSingleFileScope(implementation.getScope())) {
            return false;
        }
        for (EnumSet scopes : implementation.getAnalysisScopes()) {
            if (!AndroidLintInspectionBase.isSingleFileScope(scopes)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Issue getIssue() {
        Issue issue2 = this.myIssue;
        if (issue2 == null) {
            AndroidLintInspectionBase.$$$reportNull$$$0(48);
        }
        return issue2;
    }

    public static AndroidLintQuickFix[] createFixes(@Nullable PsiFile file, @Nullable LintFix lintFix) {
        if (lintFix instanceof LintFix.ReplaceString) {
            LintFix.ReplaceString data = (LintFix.ReplaceString)lintFix;
            String regexp = data.oldPattern != null ? data.oldPattern : (data.oldString != null ? "(" + Pattern.quote(data.oldString) + ")" : null);
            ReplaceStringQuickFix fix = new ReplaceStringQuickFix(data.getDisplayName(), regexp, data.replacement);
            if (data.shortenNames) {
                fix.setShortenNames(true);
            }
            if (data.reformat) {
                fix.setFormat(true);
            }
            if (data.range != null && file != null) {
                Position start = data.range.getStart();
                Position end = data.range.getEnd();
                if (start != null && end != null) {
                    SmartPointerManager manager = SmartPointerManager.getInstance((Project)file.getProject());
                    int startOffset = start.getOffset();
                    int endOffset = end.getOffset();
                    if (endOffset > startOffset) {
                        TextRange textRange = TextRange.create((int)startOffset, (int)Math.max(startOffset, endOffset));
                        SmartPsiFileRange smartRange = manager.createSmartPsiFileRangePointer(file, textRange);
                        fix.setRange(smartRange);
                    }
                }
            }
            return new AndroidLintQuickFix[]{fix};
        }
        if (lintFix instanceof LintFix.SetAttribute) {
            LintFix.SetAttribute data = (LintFix.SetAttribute)lintFix;
            if (data.value == null) {
                return new AndroidLintQuickFix[]{new RemoteAttributeFix(data)};
            }
            return new AndroidLintQuickFix[]{new SetAttributeQuickFix(data.getDisplayName(), data.attribute, data.namespace, data.value, data.dot, data.mark)};
        }
        if (lintFix instanceof LintFix.LintFixGroup) {
            LintFix.LintFixGroup group = (LintFix.LintFixGroup)lintFix;
            ArrayList fixList = Lists.newArrayList();
            for (LintFix fix : group.fixes) {
                Collections.addAll(fixList, AndroidLintInspectionBase.createFixes(file, fix));
            }
            AndroidLintQuickFix[] fixes = fixList.toArray(AndroidLintQuickFix.EMPTY_ARRAY);
            switch (group.type) {
                case COMPOSITE: {
                    return new AndroidLintQuickFix[]{new CompositeLintFix(lintFix.getDisplayName(), fixes)};
                }
                case ALTERNATIVES: {
                    return fixes;
                }
            }
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 20: 
            case 27: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase";
                break;
            }
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixProviders";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 31: 
            case 35: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 32: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 33: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentions";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFixes";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalQuickFixes";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "computeProblemDescriptors";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIntentions";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAllFixes";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLocalQuickFixes";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "runInspection";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "computeProblemDescriptors";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findIssueByShortName";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionShortNameByIssue";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "toHighlightDisplayLevel";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runInspection$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NonTextFileProblemDescriptor
    implements ProblemDescriptor {
        private final PsiFileSystemItem myFile;
        private final String myMessage;
        private final LocalQuickFix[] myFixes;
        private ProblemGroup myGroup;

        NonTextFileProblemDescriptor(@NotNull PsiFileSystemItem file, @NotNull String message, @NotNull LocalQuickFix[] fixes) {
            if (file == null) {
                NonTextFileProblemDescriptor.$$$reportNull$$$0(0);
            }
            if (message == null) {
                NonTextFileProblemDescriptor.$$$reportNull$$$0(1);
            }
            if (fixes == null) {
                NonTextFileProblemDescriptor.$$$reportNull$$$0(2);
            }
            this.myFile = file;
            this.myMessage = message;
            this.myFixes = fixes;
        }

        public PsiElement getPsiElement() {
            return this.myFile;
        }

        public PsiElement getStartElement() {
            return this.myFile;
        }

        public PsiElement getEndElement() {
            return this.myFile;
        }

        public TextRange getTextRangeInElement() {
            return new TextRange(0, 0);
        }

        public int getLineNumber() {
            return 0;
        }

        @NotNull
        public ProblemHighlightType getHighlightType() {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            if (problemHighlightType == null) {
                NonTextFileProblemDescriptor.$$$reportNull$$$0(3);
            }
            return problemHighlightType;
        }

        public boolean isAfterEndOfLine() {
            return false;
        }

        public void setTextAttributes(TextAttributesKey key) {
        }

        @Nullable
        public ProblemGroup getProblemGroup() {
            return this.myGroup;
        }

        public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
            this.myGroup = problemGroup;
        }

        public boolean showTooltip() {
            return false;
        }

        @NotNull
        public String getDescriptionTemplate() {
            String string = this.myMessage;
            if (string == null) {
                NonTextFileProblemDescriptor.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public QuickFix[] getFixes() {
            return this.myFixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$NonTextFileProblemDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$NonTextFileProblemDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlightType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptionTemplate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class MyLocalQuickFix
    implements LocalQuickFix {
        private final AndroidLintQuickFix myLintQuickFix;

        MyLocalQuickFix(@NotNull AndroidLintQuickFix lintQuickFix) {
            if (lintQuickFix == null) {
                MyLocalQuickFix.$$$reportNull$$$0(0);
            }
            this.myLintQuickFix = lintQuickFix;
        }

        @NotNull
        public String getName() {
            String string = this.myLintQuickFix.getName();
            if (string == null) {
                MyLocalQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myLintQuickFix.getName();
            if (string == null) {
                MyLocalQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyLocalQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MyLocalQuickFix.$$$reportNull$$$0(4);
            }
            this.myLintQuickFix.apply(descriptor.getStartElement(), descriptor.getEndElement(), AndroidQuickfixContexts.BatchContext.getInstance());
        }

        public boolean startInWriteAction() {
            return this.myLintQuickFix.startInWriteAction();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lintQuickFix";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$MyLocalQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$MyLocalQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class RemoteAttributeFix
    implements AndroidLintQuickFix {
        private final LintFix.SetAttribute myData;

        RemoteAttributeFix(LintFix.SetAttribute data) {
            this.myData = data;
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            XmlAttribute attribute;
            if (startElement == null) {
                RemoteAttributeFix.$$$reportNull$$$0(0);
            }
            if (endElement == null) {
                RemoteAttributeFix.$$$reportNull$$$0(1);
            }
            if (context == null) {
                RemoteAttributeFix.$$$reportNull$$$0(2);
            }
            if ((attribute = this.findAttribute(startElement)) != null && attribute.isValid()) {
                attribute.delete();
            }
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            XmlAttribute attribute;
            if (startElement == null) {
                RemoteAttributeFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                RemoteAttributeFix.$$$reportNull$$$0(4);
            }
            if (contextType == null) {
                RemoteAttributeFix.$$$reportNull$$$0(5);
            }
            return (attribute = this.findAttribute(startElement)) != null && attribute.isValid();
        }

        @Nullable
        private XmlAttribute findAttribute(@NotNull PsiElement startElement) {
            XmlTag tag;
            if (startElement == null) {
                RemoteAttributeFix.$$$reportNull$$$0(6);
            }
            if ((tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false)) == null) {
                return null;
            }
            return this.myData.namespace != null ? tag.getAttribute(this.myData.attribute, this.myData.namespace) : tag.getAttribute(this.myData.attribute);
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myData.getDisplayName();
            if (string == null) {
                RemoteAttributeFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contextType";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$RemoteAttributeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$RemoteAttributeFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findAttribute";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CompositeLintFix
    implements AndroidLintQuickFix {
        private final String myDisplayName;
        private final AndroidLintQuickFix[] myFixes;

        CompositeLintFix(String displayName, AndroidLintQuickFix[] myFixes) {
            this.myDisplayName = displayName;
            this.myFixes = myFixes;
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            if (startElement == null) {
                CompositeLintFix.$$$reportNull$$$0(0);
            }
            if (endElement == null) {
                CompositeLintFix.$$$reportNull$$$0(1);
            }
            if (context == null) {
                CompositeLintFix.$$$reportNull$$$0(2);
            }
            for (AndroidLintQuickFix fix : this.myFixes) {
                fix.apply(startElement, endElement, context);
            }
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            if (startElement == null) {
                CompositeLintFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                CompositeLintFix.$$$reportNull$$$0(4);
            }
            if (contextType == null) {
                CompositeLintFix.$$$reportNull$$$0(5);
            }
            for (AndroidLintQuickFix fix : this.myFixes) {
                if (fix.isApplicable(startElement, endElement, contextType)) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myDisplayName != null ? this.myDisplayName : "Fix";
            if (string == null) {
                CompositeLintFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contextType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$CompositeLintFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$CompositeLintFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LintInspectionFactory
    extends GlobalInspectionToolWrapper {
        private final AndroidLintInspectionBase myInspection;

        private LintInspectionFactory(AndroidLintInspectionBase inspection) {
            super((GlobalInspectionTool)inspection);
            this.myInspection = inspection;
        }

        public boolean isEnabledByDefault() {
            return this.myInspection.isEnabledByDefault();
        }

        @NotNull
        public GlobalInspectionToolWrapper createCopy() {
            LintInspectionFactory lintInspectionFactory = new LintInspectionFactory(AndroidLintInspectionBase.createInspection(this.myInspection.myIssue));
            if (lintInspectionFactory == null) {
                LintInspectionFactory.$$$reportNull$$$0(0);
            }
            return lintInspectionFactory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$LintInspectionFactory", "createCopy"));
        }
    }

    private static class SuppressLintQuickFix
    implements SuppressQuickFix {
        private Issue myIssue;

        private SuppressLintQuickFix(Issue issue2) {
            this.myIssue = issue2;
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            PsiFile file;
            if (project == null) {
                SuppressLintQuickFix.$$$reportNull$$$0(0);
            }
            if (context == null) {
                SuppressLintQuickFix.$$$reportNull$$$0(1);
            }
            return (file = context.getContainingFile()) == null || !AndroidLintExternalAnnotator.isKotlin(file.getFileType());
        }

        public boolean isSuppressAll() {
            return false;
        }

        @NotNull
        public String getName() {
            if ("Suppress with @SuppressLint (Java) or tools:ignore (XML) or lint.xml" == null) {
                SuppressLintQuickFix.$$$reportNull$$$0(2);
            }
            return "Suppress with @SuppressLint (Java) or tools:ignore (XML) or lint.xml";
        }

        @NotNull
        public String getFamilyName() {
            if ("Suppress" == null) {
                SuppressLintQuickFix.$$$reportNull$$$0(3);
            }
            return "Suppress";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement myElement;
            PsiFile file;
            if (project == null) {
                SuppressLintQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                SuppressLintQuickFix.$$$reportNull$$$0(5);
            }
            if ((file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)(myElement = descriptor.getPsiElement()), PsiFile.class, (boolean)false)) != null) {
                new SuppressLintIntentionAction(this.myIssue, myElement).invoke(project, null, file);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$SuppressLintQuickFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$SuppressLintQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

