/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.NamedEnumUtil;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nullable;

public class FormatConverter
extends DelimitedListConverter<AttributeFormat> {
    public FormatConverter() {
        super("|");
    }

    protected AttributeFormat convertString(@Nullable String string, ConvertContext context) {
        if (string == null) {
            return null;
        }
        return (AttributeFormat)NamedEnumUtil.getEnumElementByValue(AttributeFormat.class, (String)StringUtil.capitalize((String)string));
    }

    protected String toString(@Nullable AttributeFormat format) {
        if (format == null) {
            return null;
        }
        return format.name().toLowerCase(Locale.US);
    }

    protected Object[] getReferenceVariants(ConvertContext context, GenericDomValue<? extends List<AttributeFormat>> value) {
        ArrayList variants = new ArrayList();
        Collections.addAll(variants, AttributeFormat.values());
        FormatConverter.filterVariants(variants, value);
        Object[] stringVariants = new String[variants.size()];
        int variantsSize = variants.size();
        for (int i = 0; i < variantsSize; ++i) {
            stringVariants[i] = StringUtil.decapitalize((String)((AttributeFormat)((Object)variants.get(i))).name());
        }
        return stringVariants;
    }

    protected PsiElement resolveReference(@Nullable AttributeFormat s, ConvertContext context) {
        return s == null ? null : context.getReferenceXmlElement();
    }

    protected String getUnresolvedMessage(String value) {
        return MessageFormat.format(AndroidBundle.message("cannot.resolve.format.error", new Object[0]), value);
    }
}

