/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import java.util.Collections;
import java.util.EnumSet;
import org.jetbrains.android.dom.FileDescriptionUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidResourceDomFileDescription<T extends DomElement>
extends DomFileDescription<T> {
    protected final EnumSet<ResourceFolderType> myResourceType;

    public AndroidResourceDomFileDescription(Class<T> rootElementClass, @NonNls String rootTagName, @NotNull EnumSet<ResourceFolderType> resourceTypes) {
        if (resourceTypes == null) {
            AndroidResourceDomFileDescription.$$$reportNull$$$0(0);
        }
        super(rootElementClass, rootTagName, new String[0]);
        this.myResourceType = EnumSet.copyOf(resourceTypes);
    }

    public AndroidResourceDomFileDescription(Class<T> rootElementClass, @NonNls String rootTagName, @NotNull ResourceFolderType resourceType) {
        if (resourceType == null) {
            AndroidResourceDomFileDescription.$$$reportNull$$$0(1);
        }
        this(rootElementClass, rootTagName, EnumSet.of(resourceType));
    }

    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        if (file == null) {
            AndroidResourceDomFileDescription.$$$reportNull$$$0(2);
        }
        for (ResourceFolderType folderType : this.myResourceType) {
            if (!AndroidResourceDomFileDescription.doIsMyFile(file, folderType)) continue;
            return true;
        }
        return false;
    }

    public static boolean doIsMyFile(@NotNull XmlFile file, @NotNull ResourceFolderType folderType) {
        if (file == null) {
            AndroidResourceDomFileDescription.$$$reportNull$$$0(3);
        }
        if (folderType == null) {
            AndroidResourceDomFileDescription.$$$reportNull$$$0(4);
        }
        return FileDescriptionUtils.isResourceOfTypeWithRootTag(file, folderType, Collections.emptySet());
    }

    protected void initializeFileDescription() {
        this.registerNamespacePolicy("android", new String[]{"http://schemas.android.com/apk/res/android"});
    }

    @NotNull
    public EnumSet<ResourceFolderType> getResourceTypes() {
        EnumSet<ResourceFolderType> enumSet = this.myResourceType;
        if (enumSet == null) {
            AndroidResourceDomFileDescription.$$$reportNull$$$0(5);
        }
        return enumSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceTypes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/AndroidResourceDomFileDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/AndroidResourceDomFileDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMyFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doIsMyFile";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

