/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceFileSafeDeleteProcessor
extends SafeDeleteProcessorDelegateBase {
    @Nullable
    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @Nullable Module module, @NotNull Collection<PsiElement> allElementsToDelete) {
        if (element == null) {
            AndroidResourceFileSafeDeleteProcessor.$$$reportNull$$$0(0);
        }
        if (allElementsToDelete == null) {
            AndroidResourceFileSafeDeleteProcessor.$$$reportNull$$$0(1);
        }
        return Collections.singletonList(element);
    }

    public boolean handlesElement(PsiElement element) {
        if (!(element instanceof PsiFile)) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance(element);
        if (facet == null) {
            return false;
        }
        VirtualFile vFile = ((PsiFile)element).getVirtualFile();
        VirtualFile parent = vFile != null ? vFile.getParent() : null;
        VirtualFile resDir = parent != null ? parent.getParent() : null;
        return resDir != null && ModuleResourceManagers.getInstance(facet).getLocalResourceManager().isResourceDir(resDir);
    }

    @Nullable
    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete, @NotNull List<UsageInfo> result) {
        if (element == null) {
            AndroidResourceFileSafeDeleteProcessor.$$$reportNull$$$0(2);
        }
        if (allElementsToDelete == null) {
            AndroidResourceFileSafeDeleteProcessor.$$$reportNull$$$0(3);
        }
        if (result == null) {
            AndroidResourceFileSafeDeleteProcessor.$$$reportNull$$$0(4);
        }
        SafeDeleteProcessor.findGenericElementUsages((PsiElement)element, result, (PsiElement[])allElementsToDelete);
        if (element instanceof PsiFile) {
            PsiField[] fields;
            for (PsiField field : fields = AndroidResourceUtil.findResourceFieldsForFileResource((PsiFile)element, true)) {
                SafeDeleteProcessor.findGenericElementUsages((PsiElement)field, result, (PsiElement[])allElementsToDelete);
            }
        }
        return new NonCodeUsageSearchInfo(SafeDeleteProcessor.getDefaultInsideDeletedCondition((PsiElement[])allElementsToDelete), element);
    }

    @Nullable
    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete, boolean askUser) {
        int r;
        if (element == null) {
            AndroidResourceFileSafeDeleteProcessor.$$$reportNull$$$0(5);
        }
        if (allElementsToDelete == null) {
            AndroidResourceFileSafeDeleteProcessor.$$$reportNull$$$0(6);
        }
        if (allElementsToDelete.size() > 1) {
            return Collections.emptyList();
        }
        AndroidFacet facet = AndroidFacet.getInstance(element);
        assert (facet != null);
        PsiFile file = (PsiFile)element;
        VirtualFile vFile = file.getVirtualFile();
        assert (vFile != null);
        VirtualFile dir = vFile.getParent();
        assert (dir != null);
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)dir.getName());
        if (folderType == null) {
            return Collections.emptyList();
        }
        String type = folderType.getName();
        String name = vFile.getName();
        LocalResourceManager resourceManager = ModuleResourceManagers.getInstance(facet).getLocalResourceManager();
        List<PsiFile> resourceFiles = resourceManager.findResourceFiles(folderType, AndroidCommonUtils.getResourceName((String)type, (String)name), true, false);
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiFile resourceFile : resourceFiles) {
            if (resourceFile.getManager().areElementsEquivalent((PsiElement)file, (PsiElement)resourceFile) || !resourceFile.getName().equals(name)) continue;
            result.add((PsiElement)resourceFile);
        }
        if (!result.isEmpty() && askUser && (r = Messages.showDialog((Project)element.getProject(), (String)"Delete alternative resource files for other configurations?", (String)"Delete", (String[])new String[]{Messages.YES_BUTTON, Messages.NO_BUTTON}, (int)1, (Icon)Messages.getQuestionIcon())) != 0) {
            return Collections.emptyList();
        }
        return result;
    }

    @Nullable
    public Collection<String> findConflicts(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete) {
        if (element == null) {
            AndroidResourceFileSafeDeleteProcessor.$$$reportNull$$$0(7);
        }
        if (allElementsToDelete == null) {
            AndroidResourceFileSafeDeleteProcessor.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Nullable
    public UsageInfo[] preprocessUsages(Project project, UsageInfo[] usages) {
        return usages;
    }

    public void prepareForDeletion(PsiElement element) throws IncorrectOperationException {
    }

    public boolean isToSearchInComments(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allElementsToDelete";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/AndroidResourceFileSafeDeleteProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementsToSearch";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findUsages";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAdditionalElementsToDelete";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findConflicts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

