/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.whatsnew;

import com.android.repository.Revision;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.ui.GuiTestingService;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ResourceUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhatsNew
implements StartupActivity,
DumbAware {
    private static final String RESOURCE_DIR = "whatsNew";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runActivity(@NotNull Project project) {
        WhatsNewService service;
        if (project == null) {
            WhatsNew.$$$reportNull$$$0(0);
        }
        if ((service = (WhatsNewService)ServiceManager.getService(WhatsNewService.class)) == null || !IdeInfo.getInstance().isAndroidStudio()) {
            return;
        }
        WhatsNewData data = service.getState();
        if (GuiTestingService.getInstance().isGuiTestingMode() && !data.myIsUnderTest) {
            return;
        }
        Revision applicationRevision = Revision.parseRevision((String)ApplicationInfo.getInstance().getStrictVersion());
        URL resourceUrl = ResourceUtil.getResource(WhatsNew.class, (String)RESOURCE_DIR, (String)"");
        if (resourceUrl == null) {
            return;
        }
        String messagePath = this.getMessageToShow(data, applicationRevision, resourceUrl);
        if (messagePath != null) {
            try {
                GeneralSettings.getInstance().setShowTipsOnStartup(false);
                String text = WhatsNew.getAccessibleText(messagePath, resourceUrl);
                InputStream stream = WhatsNew.class.getResourceAsStream(messagePath);
                if (stream == null) {
                    stream = new FileInputStream(messagePath);
                }
                try {
                    ImageIcon image = new ImageIcon(ImageIO.read(stream));
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (project == null) {
                            WhatsNew.$$$reportNull$$$0(11);
                        }
                        new WhatsNewDialog(project, image, text).show();
                        ApplicationManager.getApplication().invokeLater(() -> GeneralSettings.getInstance().setShowTipsOnStartup(true));
                    });
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    private static String getAccessibleText(@NotNull String imagePath, @NotNull URL resourceUrl) {
        Path image;
        block6: {
            String string;
            if (imagePath == null) {
                WhatsNew.$$$reportNull$$$0(1);
            }
            if (resourceUrl == null) {
                WhatsNew.$$$reportNull$$$0(2);
            }
            String base = FileUtil.getNameWithoutExtension((String)imagePath);
            image = null;
            try {
                image = WhatsNew.toPath(resourceUrl).resolve(imagePath);
                Path textPath = image.getParent().resolve(base + ".txt");
                if (!Files.exists(textPath, new LinkOption[0])) break block6;
                string = new String(Files.readAllBytes(textPath), Charsets.UTF_8);
            }
            catch (IOException | URISyntaxException exception) {
                WhatsNew.closeFilesystem(image);
                catch (Throwable throwable) {
                    WhatsNew.closeFilesystem(image);
                    throw throwable;
                }
            }
            WhatsNew.closeFilesystem(image);
            return string;
        }
        WhatsNew.closeFilesystem(image);
        return null;
    }

    private static void closeFilesystem(@Nullable Path path) {
        if (path != null) {
            try {
                path.getFileSystem().close();
            }
            catch (IOException | UnsupportedOperationException exception) {
                // empty catch block
            }
        }
    }

    @Nullable
    String getMessageToShow(@NotNull WhatsNewData data, @NotNull Revision applicationRevision, @NotNull URL resourceDir) {
        if (data == null) {
            WhatsNew.$$$reportNull$$$0(3);
        }
        if (applicationRevision == null) {
            WhatsNew.$$$reportNull$$$0(4);
        }
        if (resourceDir == null) {
            WhatsNew.$$$reportNull$$$0(5);
        }
        String seenRevisionStr = data.myRevision;
        Revision seenRevision = null;
        if (seenRevisionStr != null) {
            try {
                seenRevision = Revision.parseRevision((String)seenRevisionStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (seenRevision == null || applicationRevision.compareTo(seenRevision, Revision.PreviewComparison.ASCENDING) > 0) {
            data.myRevision = applicationRevision.toString();
            Path latestMessage = WhatsNew.getLatestMessage(resourceDir);
            if (latestMessage != null) {
                Revision latestMessageRevision = WhatsNew.toRevision(latestMessage);
                Revision truncatedLatestMessageRevision = new Revision(latestMessageRevision.getMajor(), latestMessageRevision.getMinor());
                Revision truncatedApplicationRevision = new Revision(applicationRevision.getMajor(), applicationRevision.getMinor());
                if (truncatedApplicationRevision.compareTo(truncatedLatestMessageRevision) == 0 && (seenRevision == null || seenRevision.compareTo(latestMessageRevision, Revision.PreviewComparison.ASCENDING) < 0)) {
                    return latestMessage.toString();
                }
            }
        }
        return null;
    }

    @NotNull
    private static Revision toRevision(@NotNull Path p) {
        Revision revision;
        if (p == null) {
            WhatsNew.$$$reportNull$$$0(6);
        }
        String revisionStr = com.google.common.io.Files.getNameWithoutExtension((String)p.getFileName().toString());
        try {
            revision = Revision.parseRevision((String)revisionStr);
        }
        catch (RuntimeException exception) {
            Revision revision2 = Revision.NOT_SPECIFIED;
            if (revision2 == null) {
                WhatsNew.$$$reportNull$$$0(8);
            }
            return revision2;
        }
        if (revision == null) {
            WhatsNew.$$$reportNull$$$0(7);
        }
        return revision;
    }

    @Nullable
    private static Path getLatestMessage(@NotNull URL resourceDir) {
        if (resourceDir == null) {
            WhatsNew.$$$reportNull$$$0(9);
        }
        Path dir = null;
        try {
            dir = WhatsNew.toPath(resourceDir);
            Path path = Files.list(dir).filter(p -> p.toString().endsWith(".png")).max((p1, p2) -> WhatsNew.toRevision(p1).compareTo(WhatsNew.toRevision(p2), Revision.PreviewComparison.ASCENDING)).orElse(null);
            return path;
        }
        catch (IOException | URISyntaxException exception) {
        }
        finally {
            WhatsNew.closeFilesystem(dir);
        }
        return null;
    }

    private static Path toPath(@NotNull URL resourceDir) throws URISyntaxException, IOException {
        if (resourceDir == null) {
            WhatsNew.$$$reportNull$$$0(10);
        }
        Path dir = null;
        try {
            dir = Paths.get(resourceDir.toURI());
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            // empty catch block
        }
        if (dir == null) {
            FileSystem filesystem = FileSystems.newFileSystem(resourceDir.toURI(), ImmutableMap.of());
            JarURLConnection connection2 = (JarURLConnection)resourceDir.openConnection();
            dir = filesystem.getPath(connection2.getEntryName(), new String[0]);
        }
        return dir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imagePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceUrl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationRevision";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/welcome/whatsnew/WhatsNew";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/welcome/whatsnew/WhatsNew";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAccessibleText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMessageToShow";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toRevision";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLatestMessage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runActivity$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WhatsNewDialog
    extends DialogWrapper {
        private final Icon myImage;
        private final String myText;

        WhatsNewDialog(@NotNull Project project, @NotNull Icon image, @Nullable String text) {
            if (project == null) {
                WhatsNewDialog.$$$reportNull$$$0(0);
            }
            if (image == null) {
                WhatsNewDialog.$$$reportNull$$$0(1);
            }
            super(project, false);
            this.setModal(true);
            this.myImage = image;
            this.myText = text;
            this.setTitle("What's New");
            this.init();
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction()};
            if (actionArray == null) {
                WhatsNewDialog.$$$reportNull$$$0(2);
            }
            return actionArray;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JBLabel label = new JBLabel(this.myImage);
            if (this.myText != null) {
                label.getAccessibleContext().setAccessibleDescription(this.myText);
            }
            return label;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/welcome/whatsnew/WhatsNew$WhatsNewDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/welcome/whatsnew/WhatsNew$WhatsNewDialog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class WhatsNewData {
        @Tag(value="shownVersion")
        public String myRevision;
        @Transient
        public boolean myIsUnderTest = false;
    }

    @State(name="whatsNew", storages={@Storage(value="androidStudioFirstRun.xml")})
    public static class WhatsNewService
    implements PersistentStateComponent<WhatsNewData> {
        private WhatsNewData myData;

        @NotNull
        public WhatsNewData getState() {
            if (this.myData == null) {
                this.myData = new WhatsNewData();
            }
            WhatsNewData whatsNewData = this.myData;
            if (whatsNewData == null) {
                WhatsNewService.$$$reportNull$$$0(0);
            }
            return whatsNewData;
        }

        public void loadState(@NotNull WhatsNewData state) {
            if (state == null) {
                WhatsNewService.$$$reportNull$$$0(1);
            }
            this.myData = state;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/welcome/whatsnew/WhatsNew$WhatsNewService";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/welcome/whatsnew/WhatsNew$WhatsNewService";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "loadState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

