/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.io.FileOpUtils;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorSolution;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.ElevatedCommandLine;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.deprecated.HaxmInstallSettingsStep;
import com.android.tools.idea.welcome.wizard.deprecated.HaxmUninstallInfoStep;
import com.android.tools.idea.welcome.wizard.deprecated.ProgressStep;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class Haxm
extends InstallableComponent {
    public static final Storage.Unit UI_UNITS = Storage.Unit.MiB;
    public static final Logger LOG = Logger.getInstance(Haxm.class);
    public static final IdDisplay ID_INTEL = IdDisplay.create((String)"intel", (String)"");
    public static final String COMPONENT_PATH = "Hardware_Accelerated_Execution_Manager";
    public static final String REPO_PACKAGE_PATH = "extras;intel;Hardware_Accelerated_Execution_Manager";
    public static final String RUNNING_INTEL_HAXM_INSTALLER_MESSAGE = "Running Intel\u00ae HAXM installer";
    private static final int INTEL_HAXM_INSTALLER_EXIT_CODE_SUCCESS = 0;
    private static final int INTEL_HAXM_INSTALLER_EXIT_CODE_REBOOT_REQUIRED = 2;
    private static final ScopedStateStore.Key<Integer> KEY_EMULATOR_MEMORY_MB = ScopedStateStore.createKey("emulator.memory", ScopedStateStore.Scope.PATH, Integer.class);
    private final ScopedStateStore.Key<Boolean> myIsCustomInstall;
    private ProgressStep myProgressStep;
    private final HaxmInstallationIntention myInstallationIntention;
    private boolean myHaxmInstallerSuccessfullyCompleted;
    private static AccelerationErrorCode ourInitialCheck;

    public Haxm(@NotNull HaxmInstallationIntention installationIntention, @NotNull ScopedStateStore store, @NotNull ScopedStateStore.Key<Boolean> isCustomInstall) {
        if (installationIntention == null) {
            Haxm.$$$reportNull$$$0(0);
        }
        if (store == null) {
            Haxm.$$$reportNull$$$0(1);
        }
        if (isCustomInstall == null) {
            Haxm.$$$reportNull$$$0(2);
        }
        super(store, "Performance (Intel \u00ae HAXM)", "Enables a hardware-assisted virtualization engine (hypervisor) to speed up Android app emulation on your development computer. (Recommended)", installationIntention == HaxmInstallationIntention.INSTALL_WITH_UPDATES, FileOpUtils.create());
        this.myHaxmInstallerSuccessfullyCompleted = false;
        this.myIsCustomInstall = isCustomInstall;
        this.myInstallationIntention = installationIntention;
    }

    public HaxmInstallationIntention getInstallationIntention() {
        return this.myInstallationIntention;
    }

    public boolean isConfiguredSuccessfully() {
        return this.myHaxmInstallerSuccessfullyCompleted;
    }

    public static boolean canRun() {
        if (ourInitialCheck == null) {
            ourInitialCheck = Haxm.checkHaxmInstallation();
        }
        switch (ourInitialCheck) {
            case NO_EMULATOR_INSTALLED: 
            case UNKNOWN_ERROR: {
                return SystemInfo.isMac || SystemInfo.isWindows;
            }
            case NOT_ENOUGH_MEMORY: 
            case ALREADY_INSTALLED: {
                return false;
            }
        }
        switch (ourInitialCheck.getSolution()) {
            case INSTALL_HAXM: 
            case REINSTALL_HAXM: {
                return true;
            }
        }
        return false;
    }

    public static AccelerationErrorCode checkHaxmInstallation() {
        if (!SystemInfo.isWindows && !SystemInfo.isMac) {
            return AccelerationErrorCode.CANNOT_INSTALL_ON_THIS_OS;
        }
        AvdManagerConnection manager = AvdManagerConnection.getDefaultAvdManagerConnection();
        return manager.checkAcceleration();
    }

    @NotNull
    private static GeneralCommandLine addInstallParameters(@NotNull GeneralCommandLine cl, int memorySize) {
        if (cl == null) {
            Haxm.$$$reportNull$$$0(3);
        }
        cl.addParameters(new String[]{"-m", String.valueOf(memorySize)});
        GeneralCommandLine generalCommandLine = cl;
        if (generalCommandLine == null) {
            Haxm.$$$reportNull$$$0(4);
        }
        return generalCommandLine;
    }

    @NotNull
    private static GeneralCommandLine addUninstallParameters(@NotNull GeneralCommandLine cl) {
        if (cl == null) {
            Haxm.$$$reportNull$$$0(5);
        }
        cl.addParameters(new String[]{"-u"});
        GeneralCommandLine generalCommandLine = cl;
        if (generalCommandLine == null) {
            Haxm.$$$reportNull$$$0(6);
        }
        return generalCommandLine;
    }

    private static GeneralCommandLine getMacHaxmCommandLine(File path) throws WizardException {
        Haxm.ensureExistsAndIsExecutable(path, "silent_install.sh");
        File executable = Haxm.ensureExistsAndIsExecutable(path, "HAXM installation");
        return new GeneralCommandLine(new String[]{executable.getAbsolutePath()}).withWorkDirectory(path);
    }

    @NotNull
    private static File ensureExistsAndIsExecutable(File path, String exeName) throws WizardException {
        File executable = new File(path, exeName);
        if (!executable.isFile()) {
            throw new WizardException("HAXM installer executable is missing: " + executable.getAbsolutePath());
        }
        if (executable.canExecute() || executable.setExecutable(true)) {
            File file = executable;
            if (file == null) {
                Haxm.$$$reportNull$$$0(7);
            }
            return file;
        }
        throw new WizardException("Unable to set execute permission bit on HAXM installer executable: " + executable.getAbsolutePath());
    }

    @NotNull
    private static GeneralCommandLine getWindowsHaxmCommandLine(File source) throws IOException {
        File batFile = new File(source, "silent_install.bat");
        File logFile = FileUtil.createTempFile((String)"haxm_log", (String)".txt");
        GeneralCommandLine generalCommandLine = new ElevatedCommandLine(batFile.getAbsolutePath()).withTempFilePrefix("haxm").withWorkDirectory(source).withParameters(new String[]{"-log", logFile.getPath()});
        if (generalCommandLine == null) {
            Haxm.$$$reportNull$$$0(8);
        }
        return generalCommandLine;
    }

    private static int getRecommendedMemoryAllocation() {
        return FirstRunWizardDefaults.getRecommendedHaxmMemory(AvdManagerConnection.getMemorySize());
    }

    @Override
    public void init(@NotNull ProgressStep progressStep) {
        if (progressStep == null) {
            Haxm.$$$reportNull$$$0(9);
        }
        this.myProgressStep = progressStep;
        if (this.myInstallationIntention == HaxmInstallationIntention.INSTALL_WITH_UPDATES || this.myInstallationIntention == HaxmInstallationIntention.INSTALL_WITHOUT_UPDATES) {
            this.myStateStore.put(KEY_EMULATOR_MEMORY_MB, Haxm.getRecommendedMemoryAllocation());
        }
    }

    @Override
    @NotNull
    public Collection<DynamicWizardStep> createSteps() {
        if (this.myInstallationIntention == HaxmInstallationIntention.UNINSTALL) {
            Set<DynamicWizardStep> set = Collections.singleton(new HaxmUninstallInfoStep());
            if (set == null) {
                Haxm.$$$reportNull$$$0(10);
            }
            return set;
        }
        Set<DynamicWizardStep> set = Collections.singleton(new HaxmInstallSettingsStep(this.myIsCustomInstall, this.myKey, KEY_EMULATOR_MEMORY_MB));
        if (set == null) {
            Haxm.$$$reportNull$$$0(11);
        }
        return set;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        File sdkRoot;
        if (installContext == null) {
            Haxm.$$$reportNull$$$0(12);
        }
        if (sdkHandler == null) {
            Haxm.$$$reportNull$$$0(13);
        }
        if ((sdkRoot = sdkHandler.getLocation()) == null) {
            installContext.print("HAXM installer could not be run because SDK root isn't specified", ConsoleViewContentType.ERROR_OUTPUT);
            return;
        }
        if (this.myInstallationIntention == HaxmInstallationIntention.UNINSTALL) {
            this.configureForUninstall(installContext, sdkRoot);
            return;
        }
        AccelerationErrorCode accelerationErrorCode = Haxm.checkHaxmInstallation();
        AccelerationErrorSolution.SolutionCode solution = accelerationErrorCode.getSolution();
        if (accelerationErrorCode == AccelerationErrorCode.ALREADY_INSTALLED) {
            if (this.myInstallationIntention == HaxmInstallationIntention.INSTALL_WITHOUT_UPDATES) {
                this.myHaxmInstallerSuccessfullyCompleted = true;
                return;
            }
            solution = AccelerationErrorSolution.SolutionCode.REINSTALL_HAXM;
        }
        switch (solution) {
            case INSTALL_HAXM: 
            case REINSTALL_HAXM: {
                try {
                    GeneralCommandLine commandLine = this.getInstallCommandLine(sdkRoot);
                    this.runInstaller(installContext, commandLine);
                }
                catch (WizardException | IOException e) {
                    LOG.warn(String.format("Tried to install HAXM on %s OS with %s memory size", Platform.current().name(), String.valueOf(AvdManagerConnection.getMemorySize())), (Throwable)e);
                    installContext.print("Unable to install Intel HAXM\n", ConsoleViewContentType.ERROR_OUTPUT);
                    String message = e.getMessage();
                    if (!StringUtil.endsWithLineBreak((CharSequence)message)) {
                        message = message + "\n";
                    }
                    installContext.print(message, ConsoleViewContentType.ERROR_OUTPUT);
                }
                break;
            }
            case NONE: {
                String message = String.format("Unable to install Intel HAXM\n%1$s\n%2$s\n", accelerationErrorCode.getProblem(), accelerationErrorCode.getSolutionMessage());
                installContext.print(message, ConsoleViewContentType.ERROR_OUTPUT);
                break;
            }
        }
    }

    private void configureForUninstall(@NotNull InstallContext installContext, @NotNull File sdkRoot) {
        if (installContext == null) {
            Haxm.$$$reportNull$$$0(14);
        }
        if (sdkRoot == null) {
            Haxm.$$$reportNull$$$0(15);
        }
        if (Haxm.isInstalled(installContext, sdkRoot)) {
            try {
                GeneralCommandLine commandLine = Haxm.getUninstallCommandLine(sdkRoot);
                this.runInstaller(installContext, commandLine);
            }
            catch (WizardException | IOException e) {
                LOG.warn(String.format("Tried to uninstall HAXM on %s OS", Platform.current().name()), (Throwable)e);
                installContext.print("Unable to uninstall Intel HAXM\n", ConsoleViewContentType.ERROR_OUTPUT);
                String message = e.getMessage();
                if (!StringUtil.endsWithLineBreak((CharSequence)message)) {
                    message = message + "\n";
                }
                installContext.print(message, ConsoleViewContentType.ERROR_OUTPUT);
            }
        } else {
            installContext.print("HAXM is not installed, so not proceeding with its uninstallation.", ConsoleViewContentType.NORMAL_OUTPUT);
            this.myHaxmInstallerSuccessfullyCompleted = true;
        }
    }

    private static boolean isInstalled(@NotNull InstallContext context, @NotNull File sdkRoot) {
        if (context == null) {
            Haxm.$$$reportNull$$$0(16);
        }
        if (sdkRoot == null) {
            Haxm.$$$reportNull$$$0(17);
        }
        try {
            GeneralCommandLine command = Haxm.getInstallerCommandLine(sdkRoot);
            command.addParameter("-v");
            OSProcessHandler processHandler = new OSProcessHandler(command);
            processHandler.startNotify();
            processHandler.waitFor();
            Integer exitCode = processHandler.getExitCode();
            return exitCode != null && exitCode == 0;
        }
        catch (WizardException | ExecutionException | IOException exception) {
            context.print("Failed to determine whether HAXM is installed: " + exception.getMessage(), ConsoleViewContentType.ERROR_OUTPUT);
            return false;
        }
    }

    private void runInstaller(@NotNull InstallContext installContext, @NotNull GeneralCommandLine commandLine) {
        if (installContext == null) {
            Haxm.$$$reportNull$$$0(18);
        }
        if (commandLine == null) {
            Haxm.$$$reportNull$$$0(19);
        }
        try {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.setIndeterminate(true);
                progressIndicator.setText(RUNNING_INTEL_HAXM_INSTALLER_MESSAGE);
            }
            installContext.print("Running Intel\u00ae HAXM installer\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            final StringBuffer output = new StringBuffer();
            process.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    output.append(event.getText());
                    super.onTextAvailable(event, outputType);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/idea/welcome/install/Haxm$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.myProgressStep.attachToProcess((ProcessHandler)process);
            int exitCode = process.runProcess().getExitCode();
            if (exitCode != 0) {
                if (SystemInfo.isWindows && exitCode == 2) {
                    String rebootMessage = "Reboot required: HAXM installation succeeded, however the installer reported that a reboot is required in order for the changes to take effect";
                    installContext.print(rebootMessage, ConsoleViewContentType.NORMAL_OUTPUT);
                    AccelerationErrorSolution.promptAndRebootAsync(rebootMessage, ModalityState.NON_MODAL);
                    this.myHaxmInstallerSuccessfullyCompleted = true;
                    return;
                }
                if (this.myInstallationIntention == HaxmInstallationIntention.UNINSTALL) {
                    installContext.print("HAXM uninstallation failed", ConsoleViewContentType.ERROR_OUTPUT);
                } else {
                    installContext.print(String.format("HAXM installation failed. To install HAXM follow the instructions found at: %s", SystemInfo.isWindows ? "https://software.intel.com/android/articles/installation-instructions-for-intel-hardware-accelerated-execution-manager-windows" : "https://software.intel.com/android/articles/installation-instructions-for-intel-hardware-accelerated-execution-manager-mac-os-x"), ConsoleViewContentType.ERROR_OUTPUT);
                }
                Matcher m = Pattern.compile("installation log:\\s*\"(.*)\"").matcher(output.toString());
                if (m.find()) {
                    String file = m.group(1);
                    installContext.print(String.format("Installer log is located at %s", file), ConsoleViewContentType.ERROR_OUTPUT);
                    try {
                        installContext.print("Installer log contents:\n", ConsoleViewContentType.ERROR_OUTPUT);
                        installContext.print(FileUtil.loadFile((File)new File(file), (String)"UTF-16"), ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                    catch (IOException e) {
                        installContext.print("Failed to read installer output log.\n", ConsoleViewContentType.ERROR_OUTPUT);
                    }
                }
                if (progressIndicator != null) {
                    progressIndicator.setFraction(1.0);
                }
                this.myHaxmInstallerSuccessfullyCompleted = false;
                return;
            }
            if (progressIndicator != null) {
                progressIndicator.setFraction(1.0);
            }
            this.myHaxmInstallerSuccessfullyCompleted = true;
        }
        catch (ExecutionException e) {
            installContext.print("Unable to run Intel HAXM installer: " + e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    private GeneralCommandLine getInstallCommandLine(@NotNull File sdk) throws WizardException, IOException {
        if (sdk == null) {
            Haxm.$$$reportNull$$$0(20);
        }
        int memorySize = this.myStateStore.getNotNull(KEY_EMULATOR_MEMORY_MB, Haxm.getRecommendedMemoryAllocation());
        GeneralCommandLine generalCommandLine = Haxm.addInstallParameters(Haxm.getInstallerCommandLine(sdk), memorySize);
        if (generalCommandLine == null) {
            Haxm.$$$reportNull$$$0(21);
        }
        return generalCommandLine;
    }

    @NotNull
    private static GeneralCommandLine getInstallerCommandLine(@NotNull File sdk) throws WizardException, IOException {
        if (sdk == null) {
            Haxm.$$$reportNull$$$0(22);
        }
        if (SystemInfo.isMac) {
            GeneralCommandLine generalCommandLine = Haxm.getMacHaxmCommandLine(Haxm.getSourceLocation(sdk));
            if (generalCommandLine == null) {
                Haxm.$$$reportNull$$$0(23);
            }
            return generalCommandLine;
        }
        if (SystemInfo.isWindows) {
            GeneralCommandLine generalCommandLine = Haxm.getWindowsHaxmCommandLine(Haxm.getSourceLocation(sdk));
            if (generalCommandLine == null) {
                Haxm.$$$reportNull$$$0(24);
            }
            return generalCommandLine;
        }
        assert (!Haxm.canRun());
        throw new IllegalStateException("Unsupported OS");
    }

    @NotNull
    private static GeneralCommandLine getUninstallCommandLine(File sdk) throws WizardException, IOException {
        if (SystemInfo.isMac) {
            GeneralCommandLine generalCommandLine = Haxm.addUninstallParameters(Haxm.getMacHaxmCommandLine(Haxm.getSourceLocation(sdk)));
            if (generalCommandLine == null) {
                Haxm.$$$reportNull$$$0(25);
            }
            return generalCommandLine;
        }
        if (SystemInfo.isWindows) {
            GeneralCommandLine generalCommandLine = Haxm.addUninstallParameters(Haxm.getWindowsHaxmCommandLine(Haxm.getSourceLocation(sdk)));
            if (generalCommandLine == null) {
                Haxm.$$$reportNull$$$0(26);
            }
            return generalCommandLine;
        }
        assert (!Haxm.canRun());
        throw new IllegalStateException("Unsupported OS");
    }

    @NotNull
    private static File getSourceLocation(File sdk) {
        String path = FileUtil.join((String[])new String[]{"extras", ID_INTEL.getId(), COMPONENT_PATH});
        File file = new File(sdk, path);
        if (file == null) {
            Haxm.$$$reportNull$$$0(27);
        }
        return file;
    }

    @Override
    @NotNull
    public Collection<String> getRequiredSdkPackages() {
        ImmutableList immutableList = ImmutableList.of((Object)REPO_PACKAGE_PATH);
        if (immutableList == null) {
            Haxm.$$$reportNull$$$0(28);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installationIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "store";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isCustomInstall";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/welcome/install/Haxm";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressStep";
                break;
            }
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installContext";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHandler";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkRoot";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/welcome/install/Haxm";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addInstallParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addUninstallParameters";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureExistsAndIsExecutable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowsHaxmCommandLine";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createSteps";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallCommandLine";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallerCommandLine";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getUninstallCommandLine";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceLocation";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredSdkPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addInstallParameters";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addUninstallParameters";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "configureForUninstall";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isInstalled";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runInstaller";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getInstallCommandLine";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getInstallerCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum HaxmInstallationIntention {
        INSTALL_WITH_UPDATES,
        INSTALL_WITHOUT_UPDATES,
        UNINSTALL;

    }
}

