/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.StyleFilter;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleEnumSupport
extends EnumSupport {
    protected final StyleFilter myStyleFilter;

    public StyleEnumSupport(@NotNull NlProperty property2) {
        if (property2 == null) {
            StyleEnumSupport.$$$reportNull$$$0(0);
        }
        this(property2, new StyleFilter(property2.getModel().getProject(), property2.getResolver()));
    }

    StyleEnumSupport(@NotNull NlProperty property2, @NotNull StyleFilter styleFilter) {
        if (property2 == null) {
            StyleEnumSupport.$$$reportNull$$$0(1);
        }
        if (styleFilter == null) {
            StyleEnumSupport.$$$reportNull$$$0(2);
        }
        super(property2);
        this.myStyleFilter = styleFilter;
    }

    @Override
    @NotNull
    public List<ValueWithDisplayString> getAllValues() {
        String tagName = this.myProperty.getTagName();
        assert (tagName != null);
        List<ValueWithDisplayString> list = this.convertStylesToDisplayValues(this.myStyleFilter.getWidgetStyles(tagName));
        if (list == null) {
            StyleEnumSupport.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    protected ValueWithDisplayString createFromResolvedValue(@NotNull String resolvedValue, @Nullable String value, @Nullable String hint) {
        if (resolvedValue == null) {
            StyleEnumSupport.$$$reportNull$$$0(4);
        }
        if (!(value == null || value.startsWith("@style/") || value.startsWith("@android:style/") || value.startsWith("?attr/"))) {
            ResourceResolver resolver = this.myProperty.getResolver();
            StyleResourceValue resource = resolver.getStyle(value, true);
            String prefix = resource != null ? "@android:style/" : "@style/";
            value = prefix + value;
        }
        String display2 = resolvedValue;
        display2 = StringUtil.trimStart((String)display2, (String)"@android:style/");
        display2 = StringUtil.trimStart((String)display2, (String)"@style/");
        ValueWithDisplayString valueWithDisplayString = new ValueWithDisplayString(display2, value, this.generateHint(display2, value));
        if (valueWithDisplayString == null) {
            StyleEnumSupport.$$$reportNull$$$0(5);
        }
        return valueWithDisplayString;
    }

    @Nullable
    protected String generateHint(@NotNull String display2, @Nullable String value) {
        if (display2 == null) {
            StyleEnumSupport.$$$reportNull$$$0(6);
        }
        if (value == null) {
            return "default";
        }
        if (value.endsWith(display2)) {
            return null;
        }
        return value;
    }

    @NotNull
    protected List<ValueWithDisplayString> convertStylesToDisplayValues(@NotNull List<StyleResourceValue> styles) {
        if (styles == null) {
            StyleEnumSupport.$$$reportNull$$$0(7);
        }
        ArrayList<ValueWithDisplayString> values = new ArrayList<ValueWithDisplayString>();
        StyleResourceValue previousStyle = null;
        for (StyleResourceValue style : styles) {
            if (previousStyle != null && (previousStyle.isFramework() != style.isFramework() || previousStyle.isUserDefined() != style.isUserDefined())) {
                values.add(ValueWithDisplayString.SEPARATOR);
            }
            previousStyle = style;
            String prefix = style.isFramework() ? "@android:style/" : "@style/";
            values.add(this.createFromResolvedValue(style.getName(), prefix + style.getName(), null));
        }
        ArrayList<ValueWithDisplayString> arrayList = values;
        if (arrayList == null) {
            StyleEnumSupport.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleFilter";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/support/StyleEnumSupport";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "display";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/support/StyleEnumSupport";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromResolvedValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertStylesToDisplayValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFromResolvedValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateHint";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertStylesToDisplayValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

