/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableCellEditorProvider;
import com.android.tools.adtui.ptable.PTableCellRendererProvider;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.uibuilder.property.AddPropertyItem;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.NlResourceHeader;
import com.android.tools.idea.uibuilder.property.NlResourceItem;
import com.android.tools.idea.uibuilder.property.editors.NlXmlEditors;
import com.android.tools.idea.uibuilder.property.renderer.NlXmlRenderers;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeMultimap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlXmlPropertyBuilder {
    private static final Pattern INTELLIJ_LIBRARY_NAME_PATTERN = Pattern.compile("(.+)-\\d+\\.\\d+\\.\\d+(-.+)");
    private final PropertiesManager myPropertiesManager;
    private final PTable myTable;
    private final List<NlComponent> myComponents;
    private final Table<String, String, NlPropertyItem> myProperties;
    private final Multimap<String, NlResourceItem> mySliceMap;

    NlXmlPropertyBuilder(@NotNull PropertiesManager propertiesManager, @NotNull PTable table2, @NotNull List<NlComponent> components, Table<String, String, NlPropertyItem> properties) {
        if (propertiesManager == null) {
            NlXmlPropertyBuilder.$$$reportNull$$$0(0);
        }
        if (table2 == null) {
            NlXmlPropertyBuilder.$$$reportNull$$$0(1);
        }
        if (components == null) {
            NlXmlPropertyBuilder.$$$reportNull$$$0(2);
        }
        this.myPropertiesManager = propertiesManager;
        this.myTable = table2;
        this.myComponents = components;
        this.myProperties = properties;
        this.mySliceMap = TreeMultimap.create(String::compareTo, NlResourceItem::compareTo);
    }

    public boolean build() {
        this.myTable.setVisible(!this.myComponents.isEmpty());
        if (this.myComponents.isEmpty()) {
            return false;
        }
        NlComponent component2 = this.myComponents.get(0);
        ArrayList<PTableItem> items = new ArrayList<PTableItem>();
        items.add(new NlResourceHeader(NlXmlPropertyBuilder.generateFileHeader(component2.getModel().getVirtualFile().getPath())));
        for (AttributeSnapshot attribute : component2.getAttributes()) {
            NlPropertyItem item = (NlPropertyItem)this.myProperties.get((Object)attribute.namespace, (Object)attribute.name);
            if (item == null) continue;
            this.resolveValue(item);
            items.add(item);
        }
        items.add(new AddPropertyItem(this.myProperties));
        for (String header : this.mySliceMap.keySet()) {
            items.add(new NlResourceHeader(header));
            items.addAll(this.mySliceMap.get((Object)header));
        }
        int selectedRow = this.myTable.getSelectedRow();
        PTableItem selectedItem = this.myTable.getSelectedItem();
        int editingRow = this.myTable.getEditingRow();
        PTableItem editingItem = editingRow >= 0 ? this.myTable.getItemAt(editingRow) : null;
        this.myTable.setRendererProvider((PTableCellRendererProvider)NlXmlRenderers.getInstance());
        this.myTable.getModel().setItems(items);
        this.myTable.setEditorProvider((PTableCellEditorProvider)NlXmlEditors.getInstance(this.myPropertiesManager.getProject()));
        if (this.myTable.getRowCount() > 0 && !this.restoreEditing(editingRow, editingItem)) {
            this.myTable.restoreSelection(selectedRow, selectedItem);
        }
        return true;
    }

    private void resolveValue(@NotNull NlPropertyItem property2) {
        if (property2 == null) {
            NlXmlPropertyBuilder.$$$reportNull$$$0(3);
        }
        AndroidFacet facet = property2.getModel().getFacet();
        ProjectResourceRepository resourceRepository = ProjectResourceRepository.getOrCreateInstance(facet);
        ResourceResolver resolver = property2.getResolver();
        if (resolver == null) {
            return;
        }
        String value = property2.getValue();
        while (!StringUtil.isEmpty((String)value) && NlPropertyItem.isReference(value)) {
            ResourceValue resource = resolver.findResValue(value, false);
            if (resource == null) {
                resource = resolver.findResValue(value, true);
            }
            if (resource == null) {
                return;
            }
            ResourceItem item = NlXmlPropertyBuilder.findUserDefinedResourceItem(resourceRepository, resource);
            NlResourceItem row = new NlResourceItem(facet, resource, item, this.myPropertiesManager);
            value = row.getValue();
            if (StringUtil.isEmpty((String)row.getValue())) {
                return;
            }
            this.mySliceMap.put((Object)NlXmlPropertyBuilder.generateHeader(resource, item), (Object)row);
        }
    }

    private boolean restoreEditing(int editingRow, PTableItem editingItem) {
        if (editingRow < 0) {
            return false;
        }
        PTableItem currentItem = this.myTable.getItemAt(editingRow);
        if (currentItem == null || !editingItem.getClass().equals(currentItem.getClass())) {
            this.myTable.editingCanceled(null);
            return false;
        }
        this.myTable.restoreSelection(editingRow, editingItem);
        return true;
    }

    @Nullable
    private static ResourceItem findUserDefinedResourceItem(@NotNull ProjectResourceRepository resourceRepository, @NotNull ResourceValue resource) {
        if (resourceRepository == null) {
            NlXmlPropertyBuilder.$$$reportNull$$$0(4);
        }
        if (resource == null) {
            NlXmlPropertyBuilder.$$$reportNull$$$0(5);
        }
        if (resource.isFramework() || resource.getLibraryName() != null || resource.getResourceType() == null) {
            return null;
        }
        List items = resourceRepository.getResourceItem(resource.getResourceType(), resource.getName());
        if (items == null) {
            return null;
        }
        for (ResourceItem item : items) {
            if (item.getResourceValue(false) != resource) continue;
            return item;
        }
        return null;
    }

    @NotNull
    private static String generateHeader(@NotNull ResourceValue resource, @Nullable ResourceItem item) {
        ResourceType resourceType;
        String type;
        if (resource == null) {
            NlXmlPropertyBuilder.$$$reportNull$$$0(6);
        }
        String string = type = (resourceType = resource.getResourceType()) != null ? "<" + resource.getResourceType().getName() + ">" : "<style>";
        if (resource.isFramework()) {
            String string2 = "android " + type;
            if (string2 == null) {
                NlXmlPropertyBuilder.$$$reportNull$$$0(7);
            }
            return string2;
        }
        if (!StringUtil.isEmpty((String)resource.getLibraryName())) {
            String string3 = NlXmlPropertyBuilder.formatLibraryName(resource.getLibraryName()) + " " + type;
            if (string3 == null) {
                NlXmlPropertyBuilder.$$$reportNull$$$0(8);
            }
            return string3;
        }
        if (item != null && item.getSource() != null) {
            String string4 = NlXmlPropertyBuilder.generateFileHeader(((ResourceFile)item.getSource()).getFile().getPath());
            if (string4 == null) {
                NlXmlPropertyBuilder.$$$reportNull$$$0(9);
            }
            return string4;
        }
        String string5 = type;
        if (string5 == null) {
            NlXmlPropertyBuilder.$$$reportNull$$$0(10);
        }
        return string5;
    }

    private static String generateFileHeader(@NotNull String path) {
        if (path == null) {
            NlXmlPropertyBuilder.$$$reportNull$$$0(11);
        }
        String fileName = PathUtil.getFileName((String)path);
        String parentPath = PathUtil.getFileName((String)PathUtil.getParentPath((String)path));
        return parentPath + "/" + fileName;
    }

    @NotNull
    private static String formatLibraryName(@NotNull String libraryName) {
        GradleCoordinate coordinate;
        if (libraryName == null) {
            NlXmlPropertyBuilder.$$$reportNull$$$0(12);
        }
        if ((coordinate = GradleCoordinate.parseCoordinateString((String)libraryName)) != null) {
            String artifact = coordinate.getArtifactId();
            String string = !StringUtil.isEmpty((String)artifact) ? artifact : libraryName;
            if (string == null) {
                NlXmlPropertyBuilder.$$$reportNull$$$0(13);
            }
            return string;
        }
        Matcher matcher = INTELLIJ_LIBRARY_NAME_PATTERN.matcher(libraryName);
        if (matcher.find()) {
            String artifact = matcher.group(1);
            String string = !StringUtil.isEmpty((String)artifact) ? artifact : libraryName;
            if (string == null) {
                NlXmlPropertyBuilder.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = libraryName;
        if (string == null) {
            NlXmlPropertyBuilder.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceRepository";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/NlXmlPropertyBuilder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/NlXmlPropertyBuilder";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generateHeader";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "formatLibraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findUserDefinedResourceItem";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateHeader";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateFileHeader";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "formatLibraryName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

