/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette2;

import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceFolderType;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.ImagePool;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.palette2.DependencyManager;
import com.google.common.util.concurrent.Futures;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreviewProvider
implements Disposable {
    private static final int SHADOW_SIZE = 6;
    private static final String PREVIEW_PLACEHOLDER_FILE = "preview.xml";
    private static final String CONTAINER_ID = "TopLevelContainer";
    private static final String LINEAR_LAYOUT = "<LinearLayout\n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    xmlns:app=\"http://schemas.android.com/apk/res-auto\"\n    android:id=\"@+id/%1$s\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"wrap_content\"\n    android:orientation=\"vertical\">\n  %2$s\n</LinearLayout>\n";
    private final Supplier<DesignSurface> myDesignSurfaceSupplier;
    private final DependencyManager myDependencyManager;
    private RenderTask myRenderTask;
    public long myRenderTimeoutSeconds;

    public PreviewProvider(@NotNull Supplier<DesignSurface> supplier, @NotNull DependencyManager manager) {
        if (supplier == null) {
            PreviewProvider.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            PreviewProvider.$$$reportNull$$$0(1);
        }
        this.myRenderTimeoutSeconds = 1L;
        this.myDesignSurfaceSupplier = supplier;
        this.myDependencyManager = manager;
    }

    @NotNull
    public ImageAndDimension createPreview(@NotNull JComponent component2, @NotNull Palette.Item item) {
        Dimension size;
        BufferedImage image;
        if (component2 == null) {
            PreviewProvider.$$$reportNull$$$0(2);
        }
        if (item == null) {
            PreviewProvider.$$$reportNull$$$0(3);
        }
        BufferedImage bufferedImage = image = this.myDependencyManager.needsLibraryLoad(item) ? null : this.renderDragImage(item);
        if (image != null) {
            size = new Dimension(image.getWidth(), image.getHeight());
            image = ImageUtils.scale((BufferedImage)image, (double)this.getScale());
        } else {
            Icon icon = item.getIcon();
            image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            icon.paintIcon(component2, g2, 0, 0);
            g2.dispose();
            double scale = this.getScale();
            size = new Dimension((int)((double)image.getWidth() / scale), (int)((double)image.getHeight() / scale));
        }
        ImageAndDimension imageAndDimension = new ImageAndDimension(image, size);
        if (imageAndDimension == null) {
            PreviewProvider.$$$reportNull$$$0(4);
        }
        return imageAndDimension;
    }

    @Nullable
    BufferedImage renderDragImage(@NotNull Palette.Item item) {
        XmlTag tag;
        SceneView sceneView;
        if (item == null) {
            PreviewProvider.$$$reportNull$$$0(5);
        }
        if ((sceneView = this.getSceneView()) == null) {
            this.disposeRenderTaskNoWait();
            return null;
        }
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)sceneView.getModel().getProject());
        String xml = item.getDragPreviewXml();
        if (xml.equals("")) {
            return null;
        }
        try {
            tag = elementFactory.createTagFromText((CharSequence)xml);
        }
        catch (IncorrectOperationException exception) {
            return null;
        }
        NlModel model = sceneView.getModel();
        ViewEditor editor = ViewEditorImpl.getOrCreate(sceneView);
        NlComponent component2 = (NlComponent)ApplicationManager.getApplication().runWriteAction(() -> NlModelHelperKt.createComponent(model, editor, tag, null, null, InsertType.CREATE_PREVIEW));
        if (component2 == null) {
            return null;
        }
        xml = String.format(LINEAR_LAYOUT, CONTAINER_ID, component2.getTag().getText());
        RenderResult result = PreviewProvider.renderImage(this.myRenderTimeoutSeconds, this.getRenderTask(model.getConfiguration()), xml);
        if (result == null || !result.hasImage()) {
            return null;
        }
        ImagePool.Image image = result.getRenderedImage();
        List infos = result.getRootViews();
        if (infos.isEmpty()) {
            return null;
        }
        if ((infos = infos.get(0).getChildren()) == null || infos.isEmpty()) {
            return null;
        }
        ViewInfo view = (ViewInfo)infos.get(0);
        if (image.getHeight() < view.getBottom() || image.getWidth() < view.getRight() || view.getBottom() <= view.getTop() || view.getRight() <= view.getLeft()) {
            return null;
        }
        int shadowIncrement = 1 + Coordinates.getSwingDimension(sceneView, 6);
        BufferedImage imageCopy = image.getCopy();
        if (imageCopy == null) {
            return null;
        }
        try {
            return imageCopy.getSubimage(view.getLeft(), view.getTop(), Math.min(view.getRight() + shadowIncrement, image.getWidth()), Math.min(view.getBottom() + shadowIncrement, image.getHeight()));
        }
        catch (RasterFormatException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static RenderResult renderImage(long renderTimeoutSeconds, @Nullable RenderTask renderTask, @NotNull String string) {
        void xml;
        if (string == null) {
            PreviewProvider.$$$reportNull$$$0(6);
        }
        if (renderTask == null) {
            return null;
        }
        PsiFile file = PsiFileFactory.getInstance((Project)renderTask.getModule().getProject()).createFileFromText(PREVIEW_PLACEHOLDER_FILE, (FileType)XmlFileType.INSTANCE, (CharSequence)xml);
        renderTask.setPsiFile(file);
        renderTask.setOverrideBgColor(UIUtil.TRANSPARENT_COLOR.getRGB());
        renderTask.setDecorations(false);
        renderTask.setRenderingMode(SessionParams.RenderingMode.V_SCROLL);
        renderTask.setFolderType(ResourceFolderType.LAYOUT);
        renderTask.inflate();
        try {
            return (RenderResult)renderTask.render().get(renderTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Logger.getInstance(PreviewProvider.class).debug((Throwable)e);
            return null;
        }
    }

    private double getScale() {
        DesignSurface surface = this.myDesignSurfaceSupplier.get();
        return surface != null ? surface.getScale() : 1.0;
    }

    @Nullable
    private SceneView getSceneView() {
        DesignSurface surface = this.myDesignSurfaceSupplier.get();
        return surface != null ? surface.getCurrentSceneView() : null;
    }

    @Nullable
    private RenderTask getRenderTask(@NotNull Configuration configuration) {
        if (configuration == null) {
            PreviewProvider.$$$reportNull$$$0(7);
        }
        Module module = configuration.getModule();
        if (this.myRenderTask == null || this.myRenderTask.getModule() != module) {
            this.disposeRenderTaskNoWait();
            if (module == null) {
                return null;
            }
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) {
                return null;
            }
            RenderService renderService = RenderService.getInstance(facet);
            RenderLogger logger = renderService.createLogger();
            this.myRenderTask = renderService.createTask(null, configuration, logger, null);
        }
        return this.myRenderTask;
    }

    public void dispose() {
        if (this.myRenderTask != null) {
            Futures.getUnchecked(this.myRenderTask.dispose());
            this.myRenderTask = null;
        }
    }

    private void disposeRenderTaskNoWait() {
        if (this.myRenderTask != null) {
            this.myRenderTask.dispose();
            this.myRenderTask = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/palette2/PreviewProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette2/PreviewProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPreview";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renderDragImage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renderImage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRenderTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ImageAndDimension {
        public BufferedImage image;
        public Dimension dimension;

        private ImageAndDimension(@NotNull BufferedImage image, @NotNull Dimension dimension2) {
            if (image == null) {
                ImageAndDimension.$$$reportNull$$$0(0);
            }
            if (dimension2 == null) {
                ImageAndDimension.$$$reportNull$$$0(1);
            }
            this.image = image;
            this.dimension = dimension2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "image";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dimension";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/palette2/PreviewProvider$ImageAndDimension";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

