/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators.forms;

import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.ValueResourceNameValidator;
import com.android.resources.ResourceType;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ExtractedColor;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.forms.AutoCompleteForm;
import com.android.tools.idea.uibuilder.mockup.editor.creators.forms.ToolRootPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewAndColorForm {
    private static final int MAX_COLOR = 5;
    private static final String DEFAULT_TITLE = "Import color";
    private static final String WAIT_TEXT = "Finding colors in selection...";
    private static final String NO_COLOR_SELECTED = "No color selected";
    private static final Logger LOGGER = Logger.getInstance(ViewAndColorForm.class);
    private JPanel myComponent;
    private JTextField myColorName;
    private JButton myAddButton;
    private JPanel myColor;
    private JButton myDismissButton;
    private JLabel myTitle;
    private JPanel myColorListPanel;
    private JProgressBar myProgressBar;
    private JPanel myBottomPanel;
    private JBLabel myViewTypeLabel;
    private AutoCompleteForm myAutoCompleteForm;
    private JLabel myErrorLabel;
    private final List<Color> myColorList;
    private final WidgetCreator.ColorResourceHolder mySelectedColor;
    @Nullable
    private AndroidFacet myFacet;
    @Nullable
    private ActionListener myAddListener;

    public ViewAndColorForm(@Nullable String title, @NotNull ColorSelectedListener colorListener) {
        if (colorListener == null) {
            ViewAndColorForm.$$$reportNull$$$0(0);
        }
        this(title, colorListener, null);
    }

    public ViewAndColorForm(@Nullable String title, @NotNull ColorSelectedListener colorListener, @Nullable AndroidFacet facet) {
        if (colorListener == null) {
            ViewAndColorForm.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.myColorList = new ArrayList<Color>();
        this.mySelectedColor = new WidgetCreator.ColorResourceHolder(null, null);
        this.myFacet = facet;
        this.myErrorLabel = new JBLabel("", UIUtil.ComponentStyle.REGULAR);
        this.myErrorLabel.setForeground((Color)JBColor.RED);
        this.myErrorLabel.setMaximumSize(new Dimension(150, -1));
        this.myColorListPanel.add(new JLabel(WAIT_TEXT));
        this.myTitle.setText(title == null ? DEFAULT_TITLE : title);
        this.myAddButton.addActionListener(e -> {
            if (colorListener == null) {
                ViewAndColorForm.$$$reportNull$$$0(9);
            }
            this.mySelectedColor.name = this.myColorName.isEnabled() ? this.myColorName.getText() : "";
            colorListener.colorSelected(this.mySelectedColor);
        });
        this.myDismissButton.addActionListener(e -> {
            if (colorListener == null) {
                ViewAndColorForm.$$$reportNull$$$0(8);
            }
            colorListener.colorSelected(null);
        });
        this.myProgressBar.setIndeterminate(true);
        this.myColorName.getDocument().addDocumentListener(this.createColorNameDocumentListener());
        this.myColor.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        if (this.myFacet == null) {
            this.myAutoCompleteForm.getComponent().setVisible(false);
            this.myViewTypeLabel.setVisible(false);
        } else {
            this.myAutoCompleteForm.setFacet(this.myFacet);
        }
    }

    private void createUIComponents() {
        this.myComponent = new ToolRootPanel();
        this.myAutoCompleteForm = new AutoCompleteForm(this.myFacet);
    }

    public void setAddListener(@NotNull ActionListener addListener) {
        if (addListener == null) {
            ViewAndColorForm.$$$reportNull$$$0(2);
        }
        if (this.myAddListener != null) {
            this.myAddButton.removeActionListener(this.myAddListener);
        }
        this.myAddListener = addListener;
        this.myAddButton.addActionListener(addListener);
    }

    @NotNull
    private DocumentListener createColorNameDocumentListener() {
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ViewAndColorForm.this.myAddButton.setEnabled(ViewAndColorForm.this.validateColorName(e.getDocument()));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ViewAndColorForm.this.myAddButton.setEnabled(ViewAndColorForm.this.validateColorName(e.getDocument()));
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        if (documentListener == null) {
            ViewAndColorForm.$$$reportNull$$$0(3);
        }
        return documentListener;
    }

    private boolean validateColorName(@NotNull Document document) {
        if (document == null) {
            ViewAndColorForm.$$$reportNull$$$0(4);
        }
        if (this.mySelectedColor == null || this.mySelectedColor.value == null || document.getLength() < 1) {
            this.myErrorLabel.setText("");
            return true;
        }
        try {
            String text = document.getText(0, document.getLength());
            try {
                ValueResourceNameValidator.validate((String)text, (ResourceType)ResourceType.COLOR, null);
                this.myErrorLabel.setText("");
                this.myAddButton.setEnabled(true);
                return true;
            }
            catch (MergingException ex) {
                this.myErrorLabel.setText(String.format("<html> %s </html>", ValueResourceNameValidator.getErrorText((String)text, (ResourceType)ResourceType.COLOR)));
                this.myAddButton.setEnabled(false);
                return false;
            }
        }
        catch (BadLocationException ex) {
            LOGGER.warn((Throwable)ex);
            return false;
        }
    }

    private void setSelectedColor(@Nullable WidgetCreator.ColorResourceHolder color) {
        this.mySelectedColor.value = color != null ? color.value : null;
        String string = this.mySelectedColor.name = color != null ? color.name : null;
        if (color == null) {
            this.myColor.setBackground(JBColor.background());
            this.myColorName.setEnabled(false);
            this.myColorName.setText(NO_COLOR_SELECTED);
        } else {
            this.myColor.setBackground(this.mySelectedColor.value);
            this.myColorName.setEnabled(true);
            this.myColorName.setText("");
        }
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            ViewAndColorForm.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    public void addColors(@NotNull Collection<ExtractedColor> colors) {
        if (colors == null) {
            ViewAndColorForm.$$$reportNull$$$0(6);
        }
        this.myBottomPanel.removeAll();
        this.myErrorLabel.setPreferredSize(this.myBottomPanel.getSize());
        this.myErrorLabel.setMaximumSize(this.myErrorLabel.getPreferredSize());
        this.myBottomPanel.add(this.myErrorLabel);
        colors.forEach(color -> this.myColorList.add(new Color(color.getColor())));
        if (!this.myColorList.isEmpty()) {
            this.mySelectedColor.value = this.myColorList.get(0);
            this.myColor.setBackground(this.myColorList.get(0));
            this.myColor.setEnabled(true);
            this.myColor.setOpaque(true);
            ColorPanel colorPanel = new ColorPanel(this.myColorList, colorResourceHolder -> this.setSelectedColor(colorResourceHolder));
            this.myColorListPanel.removeAll();
            this.myColorListPanel.add((Component)colorPanel, "Center");
            this.myColorListPanel.doLayout();
            this.myComponent.getParent().validate();
            colorPanel.fadeIn();
        }
    }

    public void setProgress(int progress) {
        this.myProgressBar.setIndeterminate(false);
        this.myProgressBar.setValue(progress);
    }

    @NotNull
    public String getTagName() {
        String string = this.myAutoCompleteForm == null ? "" : this.myAutoCompleteForm.getTagName();
        if (string == null) {
            ViewAndColorForm.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorListener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addListener";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/mockup/editor/creators/forms/ViewAndColorForm";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/creators/forms/ViewAndColorForm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createColorNameDocumentListener";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setAddListener";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateColorName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addColors";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JProgressBar jProgressBar;
        JPanel jPanel;
        JBLabel jBLabel;
        JTextField jTextField;
        JPanel jPanel2;
        JLabel jLabel;
        JPanel jPanel3;
        this.createUIComponents();
        JPanel jPanel4 = this.myComponent;
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(5, 10, 5, 5), -1, -1, false, false));
        this.myColorListPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.setOpaque(false);
        jPanel4.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myTitle = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(15, 15), null));
        JSeparator jSeparator = new JSeparator();
        jPanel4.add((Component)jSeparator, new GridConstraints(1, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setOpaque(false);
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myColor = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, new Dimension(20, 20), null));
        this.myColorName = jTextField = new JTextField();
        jTextField.setToolTipText("Color name");
        jPanel5.add((Component)jTextField, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setHorizontalAlignment(4);
        jBLabel2.setHorizontalTextPosition(4);
        jBLabel2.setText("Color name:");
        jPanel5.add((Component)jBLabel2, new GridConstraints(1, 1, 1, 1, 4, 0, 0, 0, null, new Dimension(78, 15), null));
        this.myViewTypeLabel = jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(4);
        jBLabel.setHorizontalTextPosition(4);
        jBLabel.setText("View Type:");
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 2, 4, 0, 0, 0, null, new Dimension(78, 15), null));
        AutoCompleteForm autoCompleteForm = this.myAutoCompleteForm;
        JComponent jComponent = autoCompleteForm.$$$getRootComponent$$$();
        jPanel5.add((Component)jComponent, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 3, null, null, null));
        JSeparator jSeparator2 = new JSeparator();
        jPanel4.add((Component)jSeparator2, new GridConstraints(4, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        this.myBottomPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setOpaque(false);
        jPanel4.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 0, 3, null, null, null));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jProgressBar.setOpaque(false);
        jPanel.add((Component)jProgressBar, "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.setOpaque(false);
        jPanel4.add((Component)jPanel6, new GridConstraints(5, 1, 1, 1, 4, 2, 0, 3, null, null, null));
        this.myDismissButton = jButton2 = new JButton();
        jButton2.setOpaque(false);
        jButton2.setText("Dismiss");
        jPanel6.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myAddButton = jButton = new JButton();
        jButton.setOpaque(false);
        jButton.setText("Add");
        jButton.setToolTipText("Add color to resource");
        jPanel6.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }

    public static interface ColorSelectedListener {
        public void colorSelected(@Nullable WidgetCreator.ColorResourceHolder var1);
    }

    static class ColorPanel
    extends JPanel {
        private static final int COLOR_ICON_SIZE = 20;
        private static final int MARGINS = 2;
        private static final int USED_SPACE = 22;
        private static final Dimension DIMENSION = new Dimension(-1, -1);
        private final List<Color> myColorList;
        private final ColorSelectedListener myListener;
        private final MouseAdapter myMouseAdapter;
        private int myHoveredColor;
        private float myAlpha;

        ColorPanel(@NotNull List<Color> colorList, @NotNull ColorSelectedListener listener) {
            if (colorList == null) {
                ColorPanel.$$$reportNull$$$0(0);
            }
            if (listener == null) {
                ColorPanel.$$$reportNull$$$0(1);
            }
            this.myAlpha = 0.0f;
            this.setOpaque(true);
            this.setMinimumSize(new Dimension(22, 22));
            this.myColorList = colorList;
            this.myListener = listener;
            this.myMouseAdapter = this.createMouseAdapter();
            this.addMouseListener(this.myMouseAdapter);
            this.addMouseMotionListener(this.myMouseAdapter);
        }

        @NotNull
        private MouseAdapter createMouseAdapter() {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int colorIndex = this.getColorIndexAtPosition(e.getX(), e.getY());
                    if (colorIndex >= 0 && colorIndex < Math.min(myColorList.size(), 5)) {
                        myListener.colorSelected(new WidgetCreator.ColorResourceHolder((Color)myColorList.get(colorIndex), null));
                    } else if (colorIndex == Math.min(myColorList.size(), 5)) {
                        myListener.colorSelected(null);
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    int hovered = this.getColorIndexAtPosition(e.getX(), e.getY());
                    if (hovered != myHoveredColor) {
                        myHoveredColor = hovered;
                        this.repaint();
                    }
                }
            };
            if (mouseAdapter == null) {
                ColorPanel.$$$reportNull$$$0(2);
            }
            return mouseAdapter;
        }

        private int getColorIndexAtPosition(int x, int y) {
            return x / 22 + (this.myColorList.size() + 1) * 22 % this.getWidth() * (y / 22);
        }

        private void fadeIn() {
            long startTime = System.currentTimeMillis();
            long endTime = startTime + 300L;
            Timer timer = new Timer(20, e -> {
                long time2 = System.currentTimeMillis();
                if (time2 >= endTime) {
                    ((Timer)e.getSource()).stop();
                    this.myAlpha = 1.0f;
                } else {
                    this.myAlpha = (float)(time2 - startTime) / (float)(endTime - startTime);
                }
                this.repaint();
            });
            timer.setRepeats(true);
            timer.setCoalesce(true);
            timer.start();
        }

        @Override
        protected void paintComponent(Graphics g) {
            DIMENSION.setSize(DIMENSION);
            this.setPreferredSize(DIMENSION);
            super.paintComponent(g);
            Color oldColor = g.getColor();
            this.drawColorRectangles(g);
            this.drawNoColorButton(g);
            g.setColor(oldColor);
        }

        private void drawColorRectangles(@NotNull Graphics g) {
            if (g == null) {
                ColorPanel.$$$reportNull$$$0(3);
            }
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, this.myAlpha));
            for (int i = 0; i < this.myColorList.size() && i <= 5; ++i) {
                g.setColor(this.myColorList.get(i));
                int width = this.getWidth();
                int x = i * 22 % width;
                int y = i * 22 / width;
                g.fillRect(x, y, 20, 20);
                g.setColor(JBColor.border());
                g.drawRect(x, y, 20, 20);
                if (i != this.myHoveredColor) continue;
                g.setColor(JBColor.border().darker());
                g.drawRect(x, y, 20, 20);
            }
        }

        private void drawNoColorButton(@NotNull Graphics g) {
            if (g == null) {
                ColorPanel.$$$reportNull$$$0(4);
            }
            int i = Math.min(5, this.myColorList.size());
            int width = this.getWidth();
            int x = i * 22 % width;
            int y = i * 22 / width;
            g.setColor(JBColor.foreground());
            g.fillRect(x, y, 20, 20);
            g.setColor(JBColor.background());
            g.drawLine(x, y, x + 20, y + 20);
            g.drawLine(x, y + 20, x + 20, y);
            if (i == this.myHoveredColor) {
                g.setColor(JBColor.border());
                g.drawRect(i * 22 % width, i * 22 / width, 20, 20);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorList";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/mockup/editor/creators/forms/ViewAndColorForm$ColorPanel";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/creators/forms/ViewAndColorForm$ColorPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMouseAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "drawColorRectangles";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "drawNoColorButton";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

