/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public final class ResourcesUtil {
    private static final Logger LOGGER = Logger.getInstance(ResourcesUtil.class);

    public static boolean checkDrawableExist(@NotNull String drawableName, @NotNull String drawableType, @NotNull AndroidFacet facet) {
        if (drawableName == null) {
            ResourcesUtil.$$$reportNull$$$0(0);
        }
        if (drawableType == null) {
            ResourcesUtil.$$$reportNull$$$0(1);
        }
        if (facet == null) {
            ResourcesUtil.$$$reportNull$$$0(2);
        }
        List<VirtualFile> drawableSubDirs = AndroidResourceUtil.getResourceSubdirs(ResourceFolderType.DRAWABLE, ModuleResourceRepository.getOrCreateInstance(facet).getResourceDirs());
        for (VirtualFile dir : drawableSubDirs) {
            if (dir.findChild(String.format("%s.%s", drawableName, drawableType)) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean createDrawable(@NotNull String drawableName, @NotNull String drawableType, @NotNull WidgetCreator.DoneCallback doneCallback, @NotNull NlModel model, @NotNull BufferedImage image, @NotNull Object requestor) {
        if (drawableName == null) {
            ResourcesUtil.$$$reportNull$$$0(3);
        }
        if (drawableType == null) {
            ResourcesUtil.$$$reportNull$$$0(4);
        }
        if (doneCallback == null) {
            ResourcesUtil.$$$reportNull$$$0(5);
        }
        if (model == null) {
            ResourcesUtil.$$$reportNull$$$0(6);
        }
        if (image == null) {
            ResourcesUtil.$$$reportNull$$$0(7);
        }
        if (requestor == null) {
            ResourcesUtil.$$$reportNull$$$0(8);
        }
        AndroidFacet facet = model.getFacet();
        List<VirtualFile> drawableSubDirs = AndroidResourceUtil.getResourceSubdirs(ResourceFolderType.DRAWABLE, ModuleResourceRepository.getOrCreateInstance(facet).getResourceDirs());
        try {
            byte[] imageInByte = ResourcesUtil.imageToByteArray(image, drawableType);
            Project project = model.getProject();
            if (!drawableSubDirs.isEmpty()) {
                ResourcesUtil.createDrawableFile(drawableName + "." + drawableType, imageInByte, project, drawableSubDirs.get(0), doneCallback, requestor);
            } else {
                ResourcesUtil.createDrawableAndFolder(drawableName, drawableType, facet, imageInByte, project, doneCallback, requestor);
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Error while converting image to bytes");
            return false;
        }
    }

    public static boolean createDrawable(@NotNull String drawableName, @NotNull String drawableType, @NotNull WidgetCreator.DoneCallback doneCallback, @NotNull Mockup mockup, @NotNull NlModel model, @NotNull Rectangle selectionBounds, @NotNull Object requestor) {
        BufferedImage image;
        if (drawableName == null) {
            ResourcesUtil.$$$reportNull$$$0(9);
        }
        if (drawableType == null) {
            ResourcesUtil.$$$reportNull$$$0(10);
        }
        if (doneCallback == null) {
            ResourcesUtil.$$$reportNull$$$0(11);
        }
        if (mockup == null) {
            ResourcesUtil.$$$reportNull$$$0(12);
        }
        if (model == null) {
            ResourcesUtil.$$$reportNull$$$0(13);
        }
        if (selectionBounds == null) {
            ResourcesUtil.$$$reportNull$$$0(14);
        }
        if (requestor == null) {
            ResourcesUtil.$$$reportNull$$$0(15);
        }
        if ((image = mockup.getImage()) == null) {
            return false;
        }
        Rectangle realCropping = mockup.getComputedCropping();
        BufferedImage subImage = image.getSubimage(selectionBounds.x + realCropping.x, selectionBounds.y + realCropping.y, selectionBounds.width, selectionBounds.height);
        return ResourcesUtil.createDrawable(drawableName, drawableType, doneCallback, model, subImage, requestor);
    }

    public static byte[] imageToByteArray(BufferedImage subImage, String imageType) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)subImage, imageType, baos);
        baos.flush();
        byte[] imageInByte = baos.toByteArray();
        baos.close();
        return imageInByte;
    }

    private static void createDrawableAndFolder(@NotNull String drawableName, @NotNull String drawableType, @NotNull AndroidFacet facet, @NotNull byte[] imageInByte, @NotNull Project project, @NotNull WidgetCreator.DoneCallback doneCallback, @NotNull Object requestor) {
        Collection<VirtualFile> resDirectories;
        Iterator<VirtualFile> iterator;
        if (drawableName == null) {
            ResourcesUtil.$$$reportNull$$$0(16);
        }
        if (drawableType == null) {
            ResourcesUtil.$$$reportNull$$$0(17);
        }
        if (facet == null) {
            ResourcesUtil.$$$reportNull$$$0(18);
        }
        if (imageInByte == null) {
            ResourcesUtil.$$$reportNull$$$0(19);
        }
        if (project == null) {
            ResourcesUtil.$$$reportNull$$$0(20);
        }
        if (doneCallback == null) {
            ResourcesUtil.$$$reportNull$$$0(21);
        }
        if (requestor == null) {
            ResourcesUtil.$$$reportNull$$$0(22);
        }
        if ((iterator = (resDirectories = facet.getMainIdeaSourceProvider().getResDirectories()).iterator()).hasNext()) {
            CommandProcessor.getInstance().executeCommand(project, () -> {
                if (project == null) {
                    ResourcesUtil.$$$reportNull$$$0(39);
                }
                if (drawableName == null) {
                    ResourcesUtil.$$$reportNull$$$0(40);
                }
                if (drawableType == null) {
                    ResourcesUtil.$$$reportNull$$$0(41);
                }
                if (imageInByte == null) {
                    ResourcesUtil.$$$reportNull$$$0(42);
                }
                if (doneCallback == null) {
                    ResourcesUtil.$$$reportNull$$$0(43);
                }
                if (requestor == null) {
                    ResourcesUtil.$$$reportNull$$$0(44);
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project == null) {
                        ResourcesUtil.$$$reportNull$$$0(45);
                    }
                    if (drawableName == null) {
                        ResourcesUtil.$$$reportNull$$$0(46);
                    }
                    if (drawableType == null) {
                        ResourcesUtil.$$$reportNull$$$0(47);
                    }
                    if (imageInByte == null) {
                        ResourcesUtil.$$$reportNull$$$0(48);
                    }
                    if (doneCallback == null) {
                        ResourcesUtil.$$$reportNull$$$0(49);
                    }
                    if (requestor == null) {
                        ResourcesUtil.$$$reportNull$$$0(50);
                    }
                    try {
                        VirtualFile drawableDir = AndroidUtils.createChildDirectoryIfNotExist(project, (VirtualFile)iterator.next(), "drawable");
                        ResourcesUtil.createDrawableFile(drawableName + "." + drawableType, imageInByte, project, drawableDir, doneCallback, requestor);
                    }
                    catch (IOException e) {
                        LOGGER.error((Throwable)e);
                    }
                });
            }, "Export selection to drawable", null);
        }
    }

    private static void createDrawableFile(@NotNull String fileName, @NotNull byte[] imageInByte, @NotNull Project project, @NotNull VirtualFile drawableDir, @NotNull WidgetCreator.DoneCallback doneCallback, @NotNull Object requestor) {
        if (fileName == null) {
            ResourcesUtil.$$$reportNull$$$0(23);
        }
        if (imageInByte == null) {
            ResourcesUtil.$$$reportNull$$$0(24);
        }
        if (project == null) {
            ResourcesUtil.$$$reportNull$$$0(25);
        }
        if (drawableDir == null) {
            ResourcesUtil.$$$reportNull$$$0(26);
        }
        if (doneCallback == null) {
            ResourcesUtil.$$$reportNull$$$0(27);
        }
        if (requestor == null) {
            ResourcesUtil.$$$reportNull$$$0(28);
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (drawableDir == null) {
                ResourcesUtil.$$$reportNull$$$0(29);
            }
            if (requestor == null) {
                ResourcesUtil.$$$reportNull$$$0(30);
            }
            if (fileName == null) {
                ResourcesUtil.$$$reportNull$$$0(31);
            }
            if (imageInByte == null) {
                ResourcesUtil.$$$reportNull$$$0(32);
            }
            if (doneCallback == null) {
                ResourcesUtil.$$$reportNull$$$0(33);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (drawableDir == null) {
                    ResourcesUtil.$$$reportNull$$$0(34);
                }
                if (requestor == null) {
                    ResourcesUtil.$$$reportNull$$$0(35);
                }
                if (fileName == null) {
                    ResourcesUtil.$$$reportNull$$$0(36);
                }
                if (imageInByte == null) {
                    ResourcesUtil.$$$reportNull$$$0(37);
                }
                if (doneCallback == null) {
                    ResourcesUtil.$$$reportNull$$$0(38);
                }
                try {
                    VirtualFile folder = drawableDir.createChildData(requestor, fileName);
                    folder.setBinaryContent(imageInByte);
                    doneCallback.done(1);
                }
                catch (IOException e) {
                    LOGGER.error((Throwable)e);
                    doneCallback.done(0);
                }
            });
        }, "Export selection to drawable", null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawableName";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 17: 
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawableType";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: 
            case 11: 
            case 21: 
            case 27: 
            case 33: 
            case 38: 
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doneCallback";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 8: 
            case 15: 
            case 22: 
            case 28: 
            case 30: 
            case 35: 
            case 44: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockup";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionBounds";
                break;
            }
            case 19: 
            case 24: 
            case 32: 
            case 37: 
            case 42: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageInByte";
                break;
            }
            case 20: 
            case 25: 
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 26: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawableDir";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/creators/ResourcesUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDrawableExist";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createDrawable";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "createDrawableAndFolder";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "createDrawableFile";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createDrawableFile$3";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$2";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createDrawableAndFolder$1";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

