/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor;

import com.android.tools.idea.uibuilder.mockup.editor.MockupViewLayer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.JBColor;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class SelectionLayer
extends MouseAdapter
implements MockupViewLayer {
    private static final int KNOB_SIZE = 15;
    private static final int KNOB_COUNT = 9;
    private static final JBColor HOVERED_KNOB_COLOR = new JBColor(new Color(1427723688, true), new Color(1431143373, true));
    private static final JBColor KNOB_COLOR = JBColor.BLACK;
    private static final Color KNOB_OUTLINE = JBColor.WHITE;
    private static final BasicStroke DASH = new BasicStroke(0.0f, 0, 0, 10.0f, new float[]{5.0f}, 0.0f);
    private static final Color SELECTION_OVERLAY_COLOR = JBColor.GRAY;
    private static final int N = 0;
    private static final int E = 2;
    private static final int S = 4;
    private static final int W = 6;
    private static final int NW = 1;
    private static final int NE = 3;
    private static final int SE = 5;
    private static final int SW = 7;
    private static final int MOVE = 8;
    private static final Cursor[] CURSORS = new Cursor[9];
    public static final float OVERLAY_ALPHA = 0.5f;
    private static final short[][] myKnobsMoves;
    private static final int X_MOVE = 0;
    private static final int Y_MOVE = 1;
    private static final int W_MOVE = 2;
    private static final int H_MOVE = 3;
    private final Rectangle mySelection = new Rectangle();
    private final Rectangle myBounds = new Rectangle();
    private final Rectangle[] myKnobs = new Rectangle[9];
    private final Rectangle myOriginalSelection = new Rectangle();
    private final Point myClickOrigin = new Point();
    private final JPanel myParent;
    private final AffineTransform myAffineTransform;
    private final Point myConvertedMousePoint;
    private int mySelectedKnob = -1;
    private int myHoveredKnob = -1;
    private boolean myFixedRatio;
    private double myRatioWidth;
    private double myRatioHeight;
    private Rectangle myHolderRectangle = new Rectangle();

    public SelectionLayer(JPanel parent, AffineTransform affineTransform) {
        this.myParent = parent;
        for (int i = 0; i < this.myKnobs.length; ++i) {
            this.myKnobs[i] = new Rectangle();
        }
        this.myAffineTransform = affineTransform;
        this.myConvertedMousePoint = new Point();
    }

    @Override
    public void paint(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (!this.mySelection.isEmpty() && this.mySelection.x >= 0 && this.mySelection.y >= 0) {
            this.drawSelection(g);
            this.drawSelectionOverlay(g);
            this.drawHoveredKnob(g);
        }
    }

    private void drawSelection(@NotNull Graphics2D g) {
        if (g == null) {
            SelectionLayer.$$$reportNull$$$0(0);
        }
        Rectangle scaledSelection = SelectionLayer.transformRect(this.myAffineTransform, this.mySelection, this.myHolderRectangle);
        g.setColor((Color)KNOB_COLOR);
        g.draw(scaledSelection);
        g.setColor(KNOB_OUTLINE);
        g.setStroke(DASH);
        g.draw(scaledSelection);
    }

    private void drawHoveredKnob(@NotNull Graphics2D g) {
        if (g == null) {
            SelectionLayer.$$$reportNull$$$0(1);
        }
        Composite composite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.5f));
        if (this.myHoveredKnob >= 0 && this.myHoveredKnob != 8) {
            g.setColor((Color)HOVERED_KNOB_COLOR);
            g.fill(SelectionLayer.transformRect(this.myAffineTransform, this.myKnobs[this.myHoveredKnob], this.myHolderRectangle));
            g.setColor(KNOB_OUTLINE);
            g.draw(SelectionLayer.transformRect(this.myAffineTransform, this.myKnobs[this.myHoveredKnob], this.myHolderRectangle));
        }
        g.setComposite(composite);
    }

    private void drawSelectionOverlay(@NotNull Graphics2D g) {
        if (g == null) {
            SelectionLayer.$$$reportNull$$$0(2);
        }
        Composite composite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g.setColor(SELECTION_OVERLAY_COLOR);
        this.myHolderRectangle.setBounds(this.myBounds.x, this.myBounds.y, this.myBounds.width, this.mySelection.y);
        g.fill(SelectionLayer.transformRect(this.myAffineTransform, this.myHolderRectangle, this.myHolderRectangle));
        this.myHolderRectangle.setBounds(this.myBounds.x, this.mySelection.y, this.mySelection.x, this.mySelection.height);
        SelectionLayer.transformRect(this.myAffineTransform, this.myHolderRectangle, this.myHolderRectangle);
        this.myHolderRectangle.translate(0, 1);
        g.fill(this.myHolderRectangle);
        int x = this.mySelection.x + this.mySelection.width;
        this.myHolderRectangle.setBounds(x, this.mySelection.y, this.myBounds.width - x, this.mySelection.height);
        SelectionLayer.transformRect(this.myAffineTransform, this.myHolderRectangle, this.myHolderRectangle);
        this.myHolderRectangle.translate(1, 1);
        this.myHolderRectangle.grow(-1, 0);
        g.fill(this.myHolderRectangle);
        int y = this.mySelection.y + this.mySelection.height;
        this.myHolderRectangle.setBounds(0, y, this.myBounds.width, this.myBounds.height - y - 1);
        SelectionLayer.transformRect(this.myAffineTransform, this.myHolderRectangle, this.myHolderRectangle);
        this.myHolderRectangle.translate(0, 2);
        g.fill(this.myHolderRectangle);
        g.setComposite(composite);
    }

    private static Rectangle transformRect(@NotNull AffineTransform transform2, @NotNull Rectangle src, @NotNull Rectangle dst) {
        if (transform2 == null) {
            SelectionLayer.$$$reportNull$$$0(3);
        }
        if (src == null) {
            SelectionLayer.$$$reportNull$$$0(4);
        }
        if (dst == null) {
            SelectionLayer.$$$reportNull$$$0(5);
        }
        double[] location = new double[]{src.x, src.y, src.x + src.width, src.y + src.height};
        transform2.transform(location, 0, location, 0, 2);
        double x1 = location[0];
        double y1 = location[1];
        double x2 = location[2];
        double y2 = location[3];
        dst.setRect(x1, y1, x2 - x1, y2 - y1);
        return dst;
    }

    public void contentResized() {
        this.updateKnobPosition();
    }

    private void updateKnobPosition() {
        int vSize;
        int hSize;
        int y2;
        int x2;
        int y1;
        int x1;
        int convertedKnobSize = (int)Math.round(15.0 / this.myAffineTransform.getScaleX());
        if (this.mySelection.height < convertedKnobSize * 3 || this.mySelection.width < convertedKnobSize * 3) {
            x1 = this.mySelection.x - convertedKnobSize;
            y1 = this.mySelection.y - convertedKnobSize;
            x2 = this.mySelection.x + this.mySelection.width;
            y2 = this.mySelection.y + this.mySelection.height;
            hSize = this.mySelection.width;
            vSize = this.mySelection.height;
            this.myKnobs[8].setBounds(this.mySelection);
        } else {
            x1 = this.mySelection.x;
            y1 = this.mySelection.y;
            x2 = x1 + this.mySelection.width - convertedKnobSize;
            y2 = y1 + this.mySelection.height - convertedKnobSize;
            hSize = this.mySelection.width - convertedKnobSize * 2;
            vSize = this.mySelection.height - convertedKnobSize * 2;
            this.myKnobs[8].setBounds(x1 + convertedKnobSize, y1 + convertedKnobSize, hSize, vSize);
        }
        this.myKnobs[1].setBounds(x1, y1, convertedKnobSize, convertedKnobSize);
        this.myKnobs[3].setBounds(x2, y1, convertedKnobSize, convertedKnobSize);
        this.myKnobs[5].setBounds(x2, y2, convertedKnobSize, convertedKnobSize);
        this.myKnobs[7].setBounds(x1, y2, convertedKnobSize, convertedKnobSize);
        this.myKnobs[0].setBounds(x1 + convertedKnobSize, y1, hSize, convertedKnobSize);
        this.myKnobs[2].setBounds(x2, y1 + convertedKnobSize, convertedKnobSize, vSize);
        this.myKnobs[4].setBounds(x1 + convertedKnobSize, y2, hSize, convertedKnobSize);
        this.myKnobs[6].setBounds(x1, y1 + convertedKnobSize, convertedKnobSize, vSize);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            this.myAffineTransform.inverseTransform(e.getPoint(), this.myClickOrigin);
            this.myClickOrigin.x = Math.max(this.myBounds.x, Math.min(this.myBounds.x + this.myBounds.width, this.myClickOrigin.x));
            this.myClickOrigin.y = Math.max(this.myBounds.y, Math.min(this.myBounds.y + this.myBounds.height, this.myClickOrigin.y));
            this.myOriginalSelection.setBounds(this.mySelection);
            if (!this.mySelection.isEmpty()) {
                for (int i = 0; i < this.myKnobs.length; ++i) {
                    if (!this.myKnobs[i].contains(this.myClickOrigin)) continue;
                    this.mySelectedKnob = i;
                    return;
                }
            } else {
                this.myOriginalSelection.setLocation(this.myClickOrigin);
            }
            if (!this.mySelection.contains(this.myClickOrigin)) {
                this.mySelection.setSize(0, 0);
                this.mySelection.setLocation(this.myClickOrigin);
                Rectangle2D.intersect(this.myBounds, this.mySelection, this.mySelection);
                this.myOriginalSelection.setBounds(this.mySelection);
                this.mySelectedKnob = 5;
                this.updateKnobPosition();
            }
        }
        catch (NoninvertibleTransformException e1) {
            Logger.getInstance(SelectionLayer.class).warn((Throwable)e1);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.resetSelectionLocation();
    }

    private void resetSelectionLocation() {
        if (this.mySelection.isEmpty()) {
            this.mySelection.setLocation(this.myBounds.x, this.myBounds.y);
            this.updateKnobPosition();
        }
        this.mySelectedKnob = -1;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mySelectedKnob < 0) {
            if (this.myHoveredKnob < 0) {
                return;
            }
            this.mySelectedKnob = this.myHoveredKnob;
        }
        try {
            this.myAffineTransform.inverseTransform(e.getPoint(), this.myConvertedMousePoint);
            int dx = this.myConvertedMousePoint.x - this.myClickOrigin.x;
            int dy = this.myConvertedMousePoint.y - this.myClickOrigin.y;
            int nx = this.myOriginalSelection.x + dx * myKnobsMoves[this.mySelectedKnob][0];
            int ny = this.myOriginalSelection.y + dy * myKnobsMoves[this.mySelectedKnob][1];
            int nw = this.myOriginalSelection.width + dx * myKnobsMoves[this.mySelectedKnob][2];
            int nh = this.myOriginalSelection.height + dy * myKnobsMoves[this.mySelectedKnob][3];
            if (this.myFixedRatio) {
                nh = (int)Math.round((double)nw * (this.myRatioHeight / this.myRatioWidth));
            }
            if (nw < 0) {
                nx += nw;
                nw = -nw;
            }
            if (nh < 0) {
                ny += nh;
                nh = -nh;
            }
            if (this.mySelectedKnob == 8) {
                this.mySelection.setLocation(Math.min(Math.max(this.myBounds.x, nx), this.myBounds.x + this.myBounds.width - nw), Math.min(Math.max(this.myBounds.y, ny), this.myBounds.y + this.myBounds.height - nh));
            } else {
                if (!this.myFixedRatio || this.myBounds.contains(nx, ny, nw, nh)) {
                    this.mySelection.setBounds(nx, ny, nw, nh);
                }
                if (!this.myFixedRatio) {
                    Rectangle2D.intersect(this.myBounds, this.mySelection, this.mySelection);
                }
            }
            this.updateKnobPosition();
            this.myParent.repaint();
        }
        catch (NoninvertibleTransformException e1) {
            Logger.getInstance(SelectionLayer.class).warn((Throwable)e1);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        try {
            this.myAffineTransform.inverseTransform(e.getPoint(), this.myConvertedMousePoint);
            int hovered = -1;
            if (!this.mySelection.isEmpty()) {
                for (int i = 0; i < this.myKnobs.length; ++i) {
                    if (!this.myKnobs[i].contains(this.myConvertedMousePoint)) continue;
                    hovered = i;
                }
            }
            if (hovered != this.myHoveredKnob) {
                this.myHoveredKnob = hovered;
                if (hovered >= 0) {
                    this.myParent.setCursor(CURSORS[hovered]);
                } else {
                    this.myParent.setCursor(Cursor.getDefaultCursor());
                }
                this.myParent.repaint();
            }
        }
        catch (NoninvertibleTransformException e1) {
            Logger.getInstance(SelectionLayer.class).warn((Throwable)e1);
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        this.myBounds.setBounds(x, y, w, h);
    }

    public Rectangle getBounds() {
        return this.myBounds;
    }

    public void setSelection(int x, int y, int width, int height) {
        x = Math.min(this.myBounds.width, Math.max(0, x));
        y = Math.min(this.myBounds.height, Math.max(0, y));
        width = Math.min(this.myBounds.width - x, Math.max(0, width));
        height = Math.min(this.myBounds.height - y, Math.max(0, height));
        this.mySelection.setBounds(x, y, width, height);
        this.updateKnobPosition();
        this.myParent.repaint();
    }

    public void setSelection(Rectangle selection) {
        this.setSelection(selection.x, selection.y, selection.width, selection.height);
    }

    public Rectangle getSelection() {
        return this.mySelection;
    }

    public void clearSelection() {
        this.setSelection(0, 0, 0, 0);
    }

    public boolean isFixedRatio() {
        return this.myFixedRatio;
    }

    public void setFixedRatio(boolean fixedRatio) {
        this.myFixedRatio = fixedRatio;
        this.myRatioHeight = this.mySelection.height;
        this.myRatioWidth = this.mySelection.width;
    }

    public void setAspectRatio(double width, double height) {
        this.myRatioWidth = width;
        this.myRatioHeight = height;
        if (this.mySelection.getWidth() / this.mySelection.getHeight() == width / height) {
            return;
        }
        Point2D.Double point = SelectionLayer.getClosestPointFromLine(this.myRatioHeight, -this.myRatioWidth, this.mySelection.width, this.mySelection.height);
        this.mySelection.width = (int)Math.round(point.x);
        this.mySelection.height = (int)Math.round(point.y);
        this.mySelection.x -= Math.max(0, this.mySelection.x + this.mySelection.width - this.myBounds.x - this.myBounds.width);
        this.mySelection.y -= Math.max(0, this.mySelection.y + this.mySelection.height - this.myBounds.y - this.myBounds.height);
        if (this.mySelection.x < this.myBounds.x) {
            this.mySelection.x = this.myBounds.x;
            this.mySelection.width = this.myBounds.width;
            this.mySelection.height = (int)Math.round((double)this.mySelection.width * height / width);
        }
        if (this.mySelection.y < this.myBounds.y) {
            this.mySelection.y = this.myBounds.y;
            this.mySelection.height = this.myBounds.height;
            this.mySelection.width = (int)Math.round((double)this.mySelection.height * width / height);
        }
        this.updateKnobPosition();
        this.myParent.repaint();
        this.resetSelectionLocation();
    }

    @Contract(value="_, _, _, _ -> !null")
    private static Point2D.Double getClosestPointFromLine(double a, double b, double x0, double y0) {
        double x = b * (b * x0 - a * y0) / (a * a + b * b);
        double y = a * (-b * x0 + a * y0) / (a * a + b * b);
        return new Point2D.Double(x, y);
    }

    static {
        SelectionLayer.CURSORS[0] = Cursor.getPredefinedCursor(8);
        SelectionLayer.CURSORS[2] = Cursor.getPredefinedCursor(11);
        SelectionLayer.CURSORS[4] = Cursor.getPredefinedCursor(9);
        SelectionLayer.CURSORS[6] = Cursor.getPredefinedCursor(10);
        SelectionLayer.CURSORS[1] = Cursor.getPredefinedCursor(6);
        SelectionLayer.CURSORS[3] = Cursor.getPredefinedCursor(7);
        SelectionLayer.CURSORS[5] = Cursor.getPredefinedCursor(5);
        SelectionLayer.CURSORS[7] = Cursor.getPredefinedCursor(4);
        SelectionLayer.CURSORS[8] = Cursor.getPredefinedCursor(13);
        myKnobsMoves = new short[9][];
        SelectionLayer.myKnobsMoves[1] = new short[]{1, 1, -1, -1};
        SelectionLayer.myKnobsMoves[0] = new short[]{0, 1, 0, -1};
        SelectionLayer.myKnobsMoves[3] = new short[]{0, 1, 1, -1};
        SelectionLayer.myKnobsMoves[2] = new short[]{0, 0, 1, 0};
        SelectionLayer.myKnobsMoves[5] = new short[]{0, 0, 1, 1};
        SelectionLayer.myKnobsMoves[4] = new short[]{0, 0, 0, 1};
        SelectionLayer.myKnobsMoves[7] = new short[]{1, 0, -1, 1};
        SelectionLayer.myKnobsMoves[6] = new short[]{1, 0, -1, 0};
        SelectionLayer.myKnobsMoves[8] = new short[]{1, 1, 0, 0};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/SelectionLayer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "drawSelection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "drawHoveredKnob";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "drawSelectionOverlay";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "transformRect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

