/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.layout3d;

import com.android.tools.idea.uibuilder.layout3d.VectorUtil;
import java.text.DecimalFormat;
import java.util.Arrays;

public class Matrix {
    public double[] m;

    public void makeRotation() {
        double[] v = new double[]{this.m[0], this.m[4], this.m[8]};
        VectorUtil.normalize(v);
        this.m[0] = v[0];
        this.m[4] = v[1];
        this.m[8] = v[2];
        v = new double[]{this.m[1], this.m[5], this.m[9]};
        VectorUtil.normalize(v);
        this.m[1] = v[0];
        this.m[5] = v[1];
        this.m[9] = v[2];
        v = new double[]{this.m[2], this.m[6], this.m[10]};
        VectorUtil.normalize(v);
        this.m[2] = v[0];
        this.m[6] = v[1];
        this.m[10] = v[2];
    }

    private static String trim(String s) {
        return s.substring(s.length() - 7);
    }

    public void print() {
        DecimalFormat df = new DecimalFormat("      ##0.000");
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                System.out.print((j == 0 ? "[ " : " , ") + Matrix.trim(df.format(this.m[i * 4 + j])));
            }
            System.out.println("]");
        }
    }

    public Matrix() {
        this.m = new double[16];
        this.setToUnit();
    }

    public Matrix(Matrix matrix) {
        this(Arrays.copyOf(matrix.m, matrix.m.length));
    }

    protected Matrix(double[] m) {
        this.m = m;
    }

    public void setToUnit() {
        for (int i = 1; i < this.m.length; ++i) {
            this.m[i] = 0.0;
        }
        this.m[0] = 1.0;
        this.m[5] = 1.0;
        this.m[10] = 1.0;
        this.m[15] = 1.0;
    }

    public void mult4(float[] src, float[] dest) {
        for (int i = 0; i < 4; ++i) {
            int col = i * 4;
            double sum = 0.0;
            for (int j = 0; j < 4; ++j) {
                sum += this.m[col + j] * (double)src[j];
            }
            dest[i] = (float)sum;
        }
    }

    public void mult3(float[] src, float[] dest) {
        for (int i = 0; i < 3; ++i) {
            int col = i * 4;
            double sum = this.m[col + 3];
            for (int j = 0; j < 3; ++j) {
                sum += this.m[col + j] * (double)src[j];
            }
            dest[i] = (float)sum;
        }
    }

    public void mult3v(float[] src, float[] dest) {
        for (int i = 0; i < 3; ++i) {
            int col = i * 4;
            double sum = 0.0;
            for (int j = 0; j < 3; ++j) {
                sum += this.m[col + j] * (double)src[j];
            }
            dest[i] = (float)sum;
        }
    }

    public void mult4(double[] src, double[] dest) {
        for (int i = 0; i < 4; ++i) {
            int col = i * 4;
            double sum = 0.0;
            for (int j = 0; j < 4; ++j) {
                sum += this.m[col + j] * src[j];
            }
            dest[i] = (float)sum;
        }
    }

    public void mult3(double[] src, double[] dest) {
        for (int i = 0; i < 3; ++i) {
            int col = i * 4;
            double sum = this.m[col + 3];
            for (int j = 0; j < 3; ++j) {
                sum += this.m[col + j] * src[j];
            }
            dest[i] = (float)sum;
        }
    }

    public void mult3v(double[] src, double[] dest) {
        for (int i = 0; i < 3; ++i) {
            int col = i * 4;
            double sum = 0.0;
            for (int j = 0; j < 3; ++j) {
                sum += this.m[col + j] * src[j];
            }
            dest[i] = (float)sum;
        }
    }

    public double[] vecmult(double[] src) {
        double[] ret = new double[3];
        this.mult3v(src, ret);
        return ret;
    }

    public void mult3(float[] src, int off1, float[] dest, int off2) {
        int col = 0;
        double sum = this.m[col + 3];
        for (int j = 0; j < 3; ++j) {
            sum += this.m[col + j] * (double)src[j + off1];
        }
        float v0 = (float)sum;
        col = 4;
        sum = this.m[col + 3];
        for (int j = 0; j < 3; ++j) {
            sum += this.m[col + j] * (double)src[j + off1];
        }
        float v1 = (float)sum;
        col = 8;
        sum = this.m[col + 3];
        for (int j = 0; j < 3; ++j) {
            sum += this.m[col + j] * (double)src[j + off1];
        }
        float v2 = (float)sum;
        dest[off2] = v0;
        dest[1 + off2] = v1;
        dest[2 + off2] = v2;
    }

    public Matrix invers() {
        double[] inv = new double[16];
        inv[0] = this.m[5] * this.m[10] * this.m[15] - this.m[5] * this.m[11] * this.m[14] - this.m[9] * this.m[6] * this.m[15] + this.m[9] * this.m[7] * this.m[14] + this.m[13] * this.m[6] * this.m[11] - this.m[13] * this.m[7] * this.m[10];
        inv[4] = -this.m[4] * this.m[10] * this.m[15] + this.m[4] * this.m[11] * this.m[14] + this.m[8] * this.m[6] * this.m[15] - this.m[8] * this.m[7] * this.m[14] - this.m[12] * this.m[6] * this.m[11] + this.m[12] * this.m[7] * this.m[10];
        inv[8] = this.m[4] * this.m[9] * this.m[15] - this.m[4] * this.m[11] * this.m[13] - this.m[8] * this.m[5] * this.m[15] + this.m[8] * this.m[7] * this.m[13] + this.m[12] * this.m[5] * this.m[11] - this.m[12] * this.m[7] * this.m[9];
        inv[12] = -this.m[4] * this.m[9] * this.m[14] + this.m[4] * this.m[10] * this.m[13] + this.m[8] * this.m[5] * this.m[14] - this.m[8] * this.m[6] * this.m[13] - this.m[12] * this.m[5] * this.m[10] + this.m[12] * this.m[6] * this.m[9];
        inv[1] = -this.m[1] * this.m[10] * this.m[15] + this.m[1] * this.m[11] * this.m[14] + this.m[9] * this.m[2] * this.m[15] - this.m[9] * this.m[3] * this.m[14] - this.m[13] * this.m[2] * this.m[11] + this.m[13] * this.m[3] * this.m[10];
        inv[5] = this.m[0] * this.m[10] * this.m[15] - this.m[0] * this.m[11] * this.m[14] - this.m[8] * this.m[2] * this.m[15] + this.m[8] * this.m[3] * this.m[14] + this.m[12] * this.m[2] * this.m[11] - this.m[12] * this.m[3] * this.m[10];
        inv[9] = -this.m[0] * this.m[9] * this.m[15] + this.m[0] * this.m[11] * this.m[13] + this.m[8] * this.m[1] * this.m[15] - this.m[8] * this.m[3] * this.m[13] - this.m[12] * this.m[1] * this.m[11] + this.m[12] * this.m[3] * this.m[9];
        inv[13] = this.m[0] * this.m[9] * this.m[14] - this.m[0] * this.m[10] * this.m[13] - this.m[8] * this.m[1] * this.m[14] + this.m[8] * this.m[2] * this.m[13] + this.m[12] * this.m[1] * this.m[10] - this.m[12] * this.m[2] * this.m[9];
        inv[2] = this.m[1] * this.m[6] * this.m[15] - this.m[1] * this.m[7] * this.m[14] - this.m[5] * this.m[2] * this.m[15] + this.m[5] * this.m[3] * this.m[14] + this.m[13] * this.m[2] * this.m[7] - this.m[13] * this.m[3] * this.m[6];
        inv[6] = -this.m[0] * this.m[6] * this.m[15] + this.m[0] * this.m[7] * this.m[14] + this.m[4] * this.m[2] * this.m[15] - this.m[4] * this.m[3] * this.m[14] - this.m[12] * this.m[2] * this.m[7] + this.m[12] * this.m[3] * this.m[6];
        inv[10] = this.m[0] * this.m[5] * this.m[15] - this.m[0] * this.m[7] * this.m[13] - this.m[4] * this.m[1] * this.m[15] + this.m[4] * this.m[3] * this.m[13] + this.m[12] * this.m[1] * this.m[7] - this.m[12] * this.m[3] * this.m[5];
        inv[14] = -this.m[0] * this.m[5] * this.m[14] + this.m[0] * this.m[6] * this.m[13] + this.m[4] * this.m[1] * this.m[14] - this.m[4] * this.m[2] * this.m[13] - this.m[12] * this.m[1] * this.m[6] + this.m[12] * this.m[2] * this.m[5];
        inv[3] = -this.m[1] * this.m[6] * this.m[11] + this.m[1] * this.m[7] * this.m[10] + this.m[5] * this.m[2] * this.m[11] - this.m[5] * this.m[3] * this.m[10] - this.m[9] * this.m[2] * this.m[7] + this.m[9] * this.m[3] * this.m[6];
        inv[7] = this.m[0] * this.m[6] * this.m[11] - this.m[0] * this.m[7] * this.m[10] - this.m[4] * this.m[2] * this.m[11] + this.m[4] * this.m[3] * this.m[10] + this.m[8] * this.m[2] * this.m[7] - this.m[8] * this.m[3] * this.m[6];
        inv[11] = -this.m[0] * this.m[5] * this.m[11] + this.m[0] * this.m[7] * this.m[9] + this.m[4] * this.m[1] * this.m[11] - this.m[4] * this.m[3] * this.m[9] - this.m[8] * this.m[1] * this.m[7] + this.m[8] * this.m[3] * this.m[5];
        inv[15] = this.m[0] * this.m[5] * this.m[10] - this.m[0] * this.m[6] * this.m[9] - this.m[4] * this.m[1] * this.m[10] + this.m[4] * this.m[2] * this.m[9] + this.m[8] * this.m[1] * this.m[6] - this.m[8] * this.m[2] * this.m[5];
        double det = this.m[0] * inv[0] + this.m[1] * inv[4] + this.m[2] * inv[8] + this.m[3] * inv[12];
        if (det == 0.0) {
            return null;
        }
        det = 1.0 / det;
        double[] out = new double[16];
        for (int i = 0; i < 16; ++i) {
            out[i] = inv[i] * det;
        }
        Matrix ret = new Matrix(out);
        return ret;
    }

    Matrix mult(Matrix b) {
        return new Matrix(Matrix.multiply(this.m, b.m));
    }

    Matrix premult(Matrix b) {
        return new Matrix(Matrix.multiply(b.m, this.m));
    }

    private static double[] multiply(double[] a, double[] b) {
        double[] resultant = new double[16];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    int n = i + 4 * j;
                    resultant[n] = resultant[n] + a[i + 4 * k] * b[k + 4 * j];
                }
            }
        }
        return resultant;
    }
}

