/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative.targets;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.handlers.relative.targets.AlignAttributeRules;
import com.android.tools.idea.uibuilder.handlers.relative.targets.RelativeResizeTargetKt;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.android.tools.idea.uibuilder.scene.target.ResizeWithSnapBaseTarget;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0014J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/relative/targets/RelativeResizeTarget;", "Lcom/android/tools/idea/uibuilder/scene/target/ResizeWithSnapBaseTarget;", "type", "Lcom/android/tools/idea/uibuilder/scene/target/ResizeBaseTarget$Type;", "(Lcom/android/tools/idea/uibuilder/scene/target/ResizeBaseTarget$Type;)V", "updatAlignAttribute", "", "attributes", "Lcom/android/tools/idea/common/model/AttributesTransaction;", "value", "", "rules", "Lcom/android/tools/idea/uibuilder/handlers/relative/targets/AlignAttributeRules;", "updateAttributes", "x", "y", "updateBottomHeight", "parent", "Lcom/android/tools/idea/common/scene/SceneComponent;", "updateLeftWidth", "updateRightWidth", "updateTopHeight", "intellij.android.designer"})
public final class RelativeResizeTarget
extends ResizeWithSnapBaseTarget {
    private final void updateTopHeight(AttributesTransaction attributes, int y, SceneComponent parent) {
        int n = RelativeResizeTargetKt.access$getDrawTop$p(parent);
        int n2 = this.myStartY2;
        n2 = Math.min(y, n2);
        int stripY = Math.max(n, n2);
        attributes.setAndroidAttribute("layout_height", this.getNewHeight(stripY));
        this.updatAlignAttribute(attributes, stripY, RelativeResizeTargetKt.access$getTopAttributeHandler$p());
    }

    private final void updateBottomHeight(AttributesTransaction attributes, int y, SceneComponent parent) {
        int n = this.myStartY1;
        int n2 = RelativeResizeTargetKt.access$getDrawBottom$p(parent);
        n2 = Math.min(y, n2);
        int stripY = Math.max(n, n2);
        attributes.setAndroidAttribute("layout_height", this.getNewHeight(stripY));
        this.updatAlignAttribute(attributes, stripY, RelativeResizeTargetKt.access$getBottomAttributeHandler$p());
    }

    private final void updateLeftWidth(AttributesTransaction attributes, int x, SceneComponent parent) {
        int n = RelativeResizeTargetKt.access$getDrawLeft$p(parent);
        int n2 = this.myStartX2;
        n2 = Math.min(x, n2);
        int stripX = Math.max(n, n2);
        attributes.setAndroidAttribute("layout_width", this.getNewWidth(stripX));
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        Scene scene = sceneComponent.getScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)scene, (String)"myComponent.scene");
        if (scene.getRenderedApiLevel() >= 17) {
            this.updatAlignAttribute(attributes, stripX, RelativeResizeTargetKt.access$getStartAttributeHandler$p());
        }
        this.updatAlignAttribute(attributes, stripX, RelativeResizeTargetKt.access$getLeftAttributeHandler$p());
    }

    private final void updateRightWidth(AttributesTransaction attributes, int x, SceneComponent parent) {
        int n = this.myStartX1;
        int n2 = RelativeResizeTargetKt.access$getDrawRight$p(parent);
        n2 = Math.min(x, n2);
        int stripX = Math.max(n, n2);
        attributes.setAndroidAttribute("layout_width", this.getNewWidth(stripX));
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        Scene scene = sceneComponent.getScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)scene, (String)"myComponent.scene");
        if (scene.getRenderedApiLevel() >= 17) {
            this.updatAlignAttribute(attributes, stripX, RelativeResizeTargetKt.access$getEndAttributeHandler$p());
        }
        this.updatAlignAttribute(attributes, stripX, RelativeResizeTargetKt.access$getRightAttributeHandler$p());
    }

    private final void updatAlignAttribute(AttributesTransaction attributes, int value, AlignAttributeRules rules) {
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        SceneComponent sceneComponent2 = sceneComponent.getParent();
        if (sceneComponent2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent2, (String)"myComponent.parent!!");
        SceneComponent parent = sceneComponent2;
        if (Intrinsics.areEqual((Object)attributes.getAndroidAttribute(rules.getAlignParentAttribute()), (Object)"true")) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%ddp";
            Object[] objectArray = new Object[]{rules.getAlignParentRule().invoke((Object)parent, (Object)value)};
            String string2 = rules.getMarginAttribute();
            AttributesTransaction attributesTransaction = attributes;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String string4 = string3;
            attributesTransaction.setAndroidAttribute(string2, string4);
            return;
        }
        for (Pair<String, Function2<SceneComponent, Integer, Integer>> pair : rules.getAlignWidgetRules()) {
            String id = (String)pair.component1();
            Function2 rule = (Function2)pair.component2();
            String alignWidget = NlComponent.extractId(attributes.getAndroidAttribute(id));
            if (alignWidget == null) continue;
            SceneComponent sceneComponent3 = parent.getSceneComponent(alignWidget);
            if (sceneComponent3 == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent3, (String)"parent.getSceneComponent(alignWidget) ?: return");
            SceneComponent alignedComponent = sceneComponent3;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%ddp";
            Object[] objectArray = new Object[]{rule.invoke((Object)alignedComponent, (Object)value)};
            String string5 = rules.getMarginAttribute();
            AttributesTransaction attributesTransaction = attributes;
            String string6 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(format, *args)");
            String string7 = string6;
            attributesTransaction.setAndroidAttribute(string5, string7);
            return;
        }
    }

    @Override
    protected void updateAttributes(@NotNull AttributesTransaction attributes, int x, int y) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        SceneComponent sceneComponent2 = sceneComponent.getParent();
        if (sceneComponent2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent2, (String)"myComponent.parent ?: return");
        SceneComponent parent = sceneComponent2;
        String margins = attributes.getAndroidAttribute("layout_margin");
        if (margins != null) {
            attributes.setAndroidAttribute("layout_margin", null);
            attributes.setAndroidAttribute("layout_marginLeft", margins);
            attributes.setAndroidAttribute("layout_marginRight", margins);
            SceneComponent sceneComponent3 = this.myComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent3, (String)"myComponent");
            Scene scene = sceneComponent3.getScene();
            Intrinsics.checkExpressionValueIsNotNull((Object)scene, (String)"myComponent.scene");
            if (scene.getRenderedApiLevel() >= 17) {
                attributes.setAndroidAttribute("layout_marginStart", margins);
                attributes.setAndroidAttribute("layout_marginEnd", margins);
            }
            attributes.setAndroidAttribute("layout_marginTop", margins);
            attributes.setAndroidAttribute("layout_marginBottom", margins);
        }
        if (ResizeBaseTarget.Type.TOP == this.getType() || ResizeBaseTarget.Type.LEFT_TOP == this.getType() || ResizeBaseTarget.Type.RIGHT_TOP == this.getType()) {
            this.updateTopHeight(attributes, y, parent);
        }
        if (ResizeBaseTarget.Type.BOTTOM == this.getType() || ResizeBaseTarget.Type.LEFT_BOTTOM == this.getType() || ResizeBaseTarget.Type.RIGHT_BOTTOM == this.getType()) {
            this.updateBottomHeight(attributes, y, parent);
        }
        if (ResizeBaseTarget.Type.LEFT == this.getType() || ResizeBaseTarget.Type.LEFT_BOTTOM == this.getType() || ResizeBaseTarget.Type.LEFT_TOP == this.getType()) {
            this.updateLeftWidth(attributes, x, parent);
        }
        if (ResizeBaseTarget.Type.RIGHT == this.getType() || ResizeBaseTarget.Type.RIGHT_BOTTOM == this.getType() || ResizeBaseTarget.Type.RIGHT_TOP == this.getType()) {
            this.updateRightWidth(attributes, x, parent);
        }
    }

    public RelativeResizeTarget(@NotNull ResizeBaseTarget.Type type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        super(type);
    }
}

