/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.drawing.decorator;

import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ViewTransform;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.decorator.TextWidget;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidget;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class SwitchWidget
extends TextWidget {
    private static final int sSwitchWidth = 40;
    private static final int sSwitchHeight = 28;

    public SwitchWidget(ConstraintWidget widget, String text) {
        super(widget, text);
        this.mAlignmentY = 4;
        this.mWidget.setMinWidth(28);
        this.mWidget.setMinHeight(28);
    }

    @Override
    protected void wrapContent() {
        if (this.mWidget == null) {
            return;
        }
        if (!TextWidget.DO_WRAP) {
            return;
        }
        super.wrapContent();
        int extra = 40 + 2 * this.mHorizontalPadding;
        this.mWidget.setMinWidth(this.mWidget.getMinWidth() + extra);
        this.mWidget.setMinHeight(Math.max(this.mWidget.getMinHeight(), 28));
        this.mWidget.setDimension(0, 0);
    }

    @Override
    public void onPaintBackground(ViewTransform transform2, Graphics2D g) {
        super.onPaintBackground(transform2, g);
        if (this.mColorSet.drawBackground()) {
            int originalSize = this.mFont.getSize();
            int scaleSize = transform2.getSwingDimension(originalSize);
            g.setFont(this.mFont.deriveFont((float)scaleSize));
            FontMetrics fontMetrics = g.getFontMetrics();
            int x = transform2.getSwingX(this.mWidget.getDrawX());
            int y = transform2.getSwingY(this.mWidget.getDrawY());
            int h = transform2.getSwingDimension(this.mWidget.getDrawHeight());
            int w = transform2.getSwingDimension(40);
            g.setColor(Color.WHITE);
            int barHeight = transform2.getSwingDimension(this.mWidget.getDrawHeight() / 3);
            g.drawRoundRect((x += this.mHorizontalMargin + this.mHorizontalPadding + fontMetrics.stringWidth(this.getText())) + 2, y + h / 2 - barHeight / 2, w - 4, barHeight, h / 4, h / 4);
            g.fillArc(x + this.mHorizontalPadding, y + h / 6, 2 * h / 3, 2 * h / 3, 0, 360);
        }
    }
}

