/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import com.intellij.ui.JBColor;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import org.jetbrains.annotations.NotNull;

public class MarginWidget
extends JPanel {
    private String[] str;
    private boolean mInternal;
    private JComboBox<String> combo;
    private static final String COMBO = "combo";
    private static final String TEXT = "text";
    private ColorSet mColorSet;
    private ArrayList<ActionListener> mCallbacks;
    private JLabel label;
    private CardLayout layout;
    private BasicComboBoxUI ui;

    @Override
    public void setToolTipText(String text) {
        this.combo.setToolTipText(text);
    }

    public void showUI(Show show) {
        if (this.combo.getEditor().getEditorComponent().hasFocus()) {
            return;
        }
        switch (show) {
            case IN_WIDGET: {
                this.layout.show(this, COMBO);
                this.label.setText((String)this.combo.getSelectedItem());
                break;
            }
            case OUT_WIDGET: {
                if (this.combo.isPopupVisible()) break;
                this.layout.show(this, TEXT);
                break;
            }
            case OUT_PANEL: {
                this.layout.show(this, TEXT);
            }
        }
        this.label.setText((String)this.combo.getSelectedItem());
    }

    public MarginWidget(@NotNull ColorSet colorSet, int alignment, @NotNull String name) {
        if (colorSet == null) {
            MarginWidget.$$$reportNull$$$0(0);
        }
        if (name == null) {
            MarginWidget.$$$reportNull$$$0(1);
        }
        super(new CardLayout());
        this.str = new String[]{"0", "8", "16", "24", "32"};
        this.combo = new JComboBox<String>(this.str);
        this.mCallbacks = new ArrayList();
        this.label = new JLabel("0");
        this.ui = new BasicComboBoxUI(){

            @Override
            protected JButton createArrowButton() {
                Color background = MarginWidget.this.mColorSet.getInspectorBackgroundColor();
                Color shadow = MarginWidget.this.mColorSet.getInspectorStrokeColor();
                Color darkShadow = MarginWidget.this.mColorSet.getInspectorStrokeColor();
                Color highlight = MarginWidget.this.mColorSet.getSubduedFrames();
                BasicArrowButton button = new BasicArrowButton(5, background, shadow, darkShadow, highlight);
                button.setForeground((Color)JBColor.RED);
                button.setBorder(new MatteBorder(0, 1, 0, 0, MarginWidget.this.mColorSet.getInspectorStrokeColor()));
                return button;
            }
        };
        this.mColorSet = colorSet;
        this.layout = (CardLayout)this.getLayout();
        this.initLabel(alignment);
        this.initComboBox(name);
        this.setBackground(null);
        this.setName(name);
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(42, 23));
        this.add((Component)this.label, TEXT);
        this.add(this.combo, COMBO);
    }

    private void initLabel(int alignment) {
        this.label.setBackground(null);
        this.label.setForeground(this.mColorSet.getInspectorStrokeColor());
        this.label.setHorizontalAlignment(alignment);
        this.label.setOpaque(false);
    }

    private void initComboBox(@NotNull String name) {
        if (name == null) {
            MarginWidget.$$$reportNull$$$0(2);
        }
        this.combo.setAlignmentX(0.0f);
        this.combo.setBorder(new LineBorder(this.mColorSet.getInspectorStrokeColor()));
        this.combo.setEditable(true);
        this.combo.setEditor(new BasicComboBoxEditor(){

            @Override
            @NotNull
            public Component getEditorComponent() {
                Component component2 = super.getEditorComponent();
                if (component2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return component2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/constraint/MarginWidget$1", "getEditorComponent"));
            }
        });
        this.combo.setName(name + "ComboBox");
        this.combo.setRenderer(new DefaultListCellRenderer(){

            @Override
            @NotNull
            public Component getListCellRendererComponent(@NotNull JList list, @NotNull Object value, int index, boolean selected, boolean focused) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    2.$$$reportNull$$$0(1);
                }
                Component component2 = super.getListCellRendererComponent((JList<?>)list, value, index, selected, focused);
                ((JComponent)component2).setBorder(new LineBorder(MarginWidget.this.mColorSet.getSubduedFrames(), 1));
                Component component3 = component2;
                if (component3 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return component3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "list";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/constraint/MarginWidget$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/MarginWidget$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getListCellRendererComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getListCellRendererComponent";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.combo.setUI(this.ui);
        this.combo.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(@NotNull FocusEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                MarginWidget.this.showUI(Show.OUT_PANEL);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/handlers/constraint/MarginWidget$3", "focusLost"));
            }
        });
        this.combo.addActionListener(event -> {
            if (this.mInternal) {
                return;
            }
            this.label.setText((String)this.combo.getSelectedItem());
            this.mCallbacks.forEach(listener -> listener.actionPerformed(event));
        });
        this.combo.addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int newMargin = MarginWidget.this.getMargin() - e.getWheelRotation();
                if (newMargin >= 0) {
                    MarginWidget.this.setMargin(newMargin);
                    MarginWidget.this.mCallbacks.forEach(listener -> listener.actionPerformed(null));
                }
            }
        });
    }

    public void setMargin(int margin) {
        this.mInternal = true;
        String marginText = String.valueOf(margin);
        this.combo.setSelectedItem(marginText);
        this.label.setText(marginText);
        this.mInternal = false;
    }

    public int getMargin() {
        try {
            return Integer.parseInt(this.label.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.mCallbacks.add(actionListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorSet";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/MarginWidget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initComboBox";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Show {
        IN_WIDGET,
        OUT_WIDGET,
        OUT_PANEL;

    }
}

