/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.npw.assetstudio.wizard.WrappedFlowLayout;
import com.android.tools.idea.uibuilder.editor.AnimationToolbarSliderUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationToolbar
extends Box
implements Disposable {
    private static final int TICKER_STEP = 33;
    private static final Font BUTTON_FONT = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.MINI);
    @NotNull
    private final AnimationListener myListener;
    private final JButton myPlayButton;
    private final JButton myPauseButton;
    private final JButton myStopButton;
    private final JButton myFrameFwdButton;
    private final JButton myFrameBckButton;
    private final long myTickStepMs;
    private final long myMinTimeMs;
    private final JSlider myFrameControl;
    @Nullable
    private final DefaultBoundedRangeModel myTimeSliderModel;
    private final ChangeListener myTimeSliderChangeModel;
    private long myMaxTimeMs;
    private boolean myLoopEnabled;
    private ScheduledFuture<?> myTicker;
    private long myFramePositionMs;
    private long myLastTickMs;

    /*
     * WARNING - void declaration
     */
    private AnimationToolbar(@NotNull Disposable parentDisposable, @NotNull AnimationListener listener, long tickStepMs, long minTimeMs, long l) {
        void initialMaxTimeMs;
        if (parentDisposable == null) {
            AnimationToolbar.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            AnimationToolbar.$$$reportNull$$$0(1);
        }
        super(3);
        this.myLoopEnabled = true;
        this.myLastTickMs = 0L;
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        this.add(Box.createVerticalGlue());
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myListener = listener;
        this.myTickStepMs = tickStepMs;
        this.myMinTimeMs = minTimeMs;
        this.myMaxTimeMs = initialMaxTimeMs;
        Box buttonsPanel = Box.createHorizontalBox();
        this.myPlayButton = AnimationToolbar.newControlButton(">", "Play", this::onPlay);
        this.myPauseButton = AnimationToolbar.newControlButton("||", "Pause", this::onPause);
        this.myStopButton = AnimationToolbar.newControlButton("\u25a0", "Stop", this::onStop);
        this.myFrameFwdButton = AnimationToolbar.newControlButton(">|", "Step forward", this::onFrameFwd);
        this.myFrameBckButton = AnimationToolbar.newControlButton("|<", "Step backwards", this::onFrameBck);
        JPanel controlBar = new JPanel(new WrappedFlowLayout());
        buttonsPanel.add(this.myPlayButton);
        buttonsPanel.add(this.myPauseButton);
        buttonsPanel.add(this.myStopButton);
        buttonsPanel.add(this.myFrameBckButton);
        buttonsPanel.add(this.myFrameFwdButton);
        controlBar.add(buttonsPanel);
        if (this.isUnlimitedAnimationToolbar()) {
            this.myTimeSliderModel = null;
            this.myTimeSliderChangeModel = null;
        } else {
            JCheckBox loopControl = new JCheckBox("Loop", this.myLoopEnabled);
            loopControl.setFont(BUTTON_FONT);
            loopControl.addChangeListener(e -> {
                this.myLoopEnabled = loopControl.isSelected();
            });
            controlBar.add(loopControl);
            this.myTimeSliderModel = new DefaultBoundedRangeModel(0, 0, 0, 100);
            this.myTimeSliderChangeModel = e -> {
                long newPositionMs = (long)((float)(this.myMaxTimeMs - this.myMinTimeMs) * ((float)this.myTimeSliderModel.getValue() / 100.0f));
                this.seek(newPositionMs);
            };
            JSlider timeSlider = new JSlider(0, 100, 0){

                @Override
                public void updateUI() {
                    this.setUI(new AnimationToolbarSliderUI(this));
                    this.updateLabelUIs();
                }
            };
            timeSlider.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
            timeSlider.setMajorTickSpacing(10);
            timeSlider.setPaintTicks(true);
            this.myTimeSliderModel.addChangeListener(this.myTimeSliderChangeModel);
            timeSlider.setModel(this.myTimeSliderModel);
            this.add(timeSlider);
            this.add(Box.createVerticalStrut(JBUI.scale((int)10)));
        }
        this.myFrameControl = new JSlider(-5, 5, 0);
        this.myFrameControl.setSnapToTicks(true);
        controlBar.add(Box.createHorizontalStrut(JBUI.scale((int)50)));
        controlBar.add(this.myFrameControl);
        this.add(controlBar);
        this.add(Box.createHorizontalGlue());
        this.myFrameControl.addChangeListener(e -> {
            this.stopFrameTicker();
            int value = this.myFrameControl.getValue();
            if (value == 0) {
                this.stopFrameTicker();
                return;
            }
            long frameChange = this.myTickStepMs * (long)value;
            this.myTicker = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(() -> this.onTick(frameChange), 0L, 33L, TimeUnit.MILLISECONDS);
        });
        this.myFrameControl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!AnimationToolbar.this.myFrameControl.isEnabled()) {
                    return;
                }
                AnimationToolbar.this.stopFrameTicker();
                AnimationToolbar.this.myFrameControl.setValue(0);
            }
        });
        this.onStop();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static AnimationToolbar createUnlimitedAnimationToolbar(@NotNull Disposable parentDisposable, @NotNull AnimationListener listener, long tickStepMs, long l) {
        void minTimeMs;
        if (parentDisposable == null) {
            AnimationToolbar.$$$reportNull$$$0(2);
        }
        if (listener == null) {
            AnimationToolbar.$$$reportNull$$$0(3);
        }
        AnimationToolbar animationToolbar = new AnimationToolbar(parentDisposable, listener, tickStepMs, (long)minTimeMs, -1L);
        if (animationToolbar == null) {
            AnimationToolbar.$$$reportNull$$$0(4);
        }
        return animationToolbar;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static AnimationToolbar createAnimationToolbar(@NotNull Disposable parentDisposable, @NotNull AnimationListener listener, long tickStepMs, long minTimeMs, long l) {
        void initialMaxTimeMs;
        if (parentDisposable == null) {
            AnimationToolbar.$$$reportNull$$$0(5);
        }
        if (listener == null) {
            AnimationToolbar.$$$reportNull$$$0(6);
        }
        AnimationToolbar animationToolbar = new AnimationToolbar(parentDisposable, listener, tickStepMs, minTimeMs, (long)initialMaxTimeMs);
        if (animationToolbar == null) {
            AnimationToolbar.$$$reportNull$$$0(7);
        }
        return animationToolbar;
    }

    @NotNull
    private static JButton newControlButton(@NotNull String label, @NotNull Runnable callback) {
        if (label == null) {
            AnimationToolbar.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            AnimationToolbar.$$$reportNull$$$0(9);
        }
        JButton button = new JButton(label);
        button.addActionListener(e -> {
            if (callback == null) {
                AnimationToolbar.$$$reportNull$$$0(16);
            }
            callback.run();
        });
        button.setBorder((Border)JBUI.Borders.empty((int)15, (int)10));
        button.setBorderPainted(false);
        button.setFont(BUTTON_FONT);
        button.setEnabled(false);
        JButton jButton = button;
        if (jButton == null) {
            AnimationToolbar.$$$reportNull$$$0(10);
        }
        return jButton;
    }

    @NotNull
    private static JButton newControlButton(@NotNull String iconText, @NotNull String label, @NotNull Runnable callback) {
        if (iconText == null) {
            AnimationToolbar.$$$reportNull$$$0(11);
        }
        if (label == null) {
            AnimationToolbar.$$$reportNull$$$0(12);
        }
        if (callback == null) {
            AnimationToolbar.$$$reportNull$$$0(13);
        }
        JButton button = new JButton();
        button.setName(label);
        button.setText(iconText);
        button.addActionListener(e -> {
            if (callback == null) {
                AnimationToolbar.$$$reportNull$$$0(15);
            }
            callback.run();
        });
        button.setBorder((Border)JBUI.Borders.empty((int)15, (int)10));
        button.setBorderPainted(false);
        button.setFont(BUTTON_FONT);
        button.setEnabled(false);
        JButton jButton = button;
        if (jButton == null) {
            AnimationToolbar.$$$reportNull$$$0(14);
        }
        return jButton;
    }

    private void setEnabledState(boolean play, boolean pause, boolean stop, boolean frame) {
        this.myPlayButton.setEnabled(play);
        this.myPauseButton.setEnabled(pause);
        this.myStopButton.setEnabled(stop);
        this.myFrameFwdButton.setEnabled(frame);
        this.myFrameBckButton.setEnabled(frame);
        this.myFrameControl.setEnabled(frame);
    }

    private void onPlay() {
        this.stopFrameTicker();
        this.setEnabledState(false, true, true, false);
        this.myLastTickMs = System.currentTimeMillis();
        this.myTicker = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(() -> {
            long now = System.currentTimeMillis();
            long elapsed = now - this.myLastTickMs;
            this.myLastTickMs = now;
            this.onTick(elapsed);
        }, 0L, 33L, TimeUnit.MILLISECONDS);
    }

    private void onPause() {
        this.setEnabledState(true, false, true, true);
        this.stopFrameTicker();
    }

    private void stopFrameTicker() {
        if (this.myTicker != null) {
            this.myTicker.cancel(false);
            this.myTicker = null;
        }
    }

    private void onStop() {
        this.stopFrameTicker();
        this.setEnabledState(true, false, false, true);
        this.setFramePosition(this.myMinTimeMs, false);
    }

    private void doFrame() {
        this.myListener.animateTo(this.myFramePositionMs);
    }

    private void onFrameFwd() {
        this.onTick(this.myTickStepMs);
    }

    private void onFrameBck() {
        this.onTick(-this.myTickStepMs);
    }

    private void onNewFramePosition(boolean setByUser) {
        if (this.isUnlimitedAnimationToolbar()) {
            return;
        }
        if (this.myFramePositionMs >= this.myMaxTimeMs && !setByUser && !this.myLoopEnabled) {
            this.onPause();
        }
        this.myStopButton.setEnabled(this.myFramePositionMs - this.myTickStepMs >= this.myMinTimeMs);
        this.myFrameFwdButton.setEnabled(this.myFramePositionMs + this.myTickStepMs <= this.myMaxTimeMs);
        this.myFrameBckButton.setEnabled(this.myFramePositionMs - this.myTickStepMs >= this.myMinTimeMs);
        if (this.myTimeSliderModel != null) {
            this.myTimeSliderModel.removeChangeListener(this.myTimeSliderChangeModel);
            this.myTimeSliderModel.setValue((int)((float)(this.myFramePositionMs - this.myMinTimeMs) / (float)(this.myMaxTimeMs - this.myMinTimeMs) * 100.0f));
            this.myTimeSliderModel.addChangeListener(this.myTimeSliderChangeModel);
        }
    }

    private void setFramePosition(long newPositionMs, boolean setByUser) {
        this.myFramePositionMs = newPositionMs;
        if (this.myFramePositionMs < this.myMinTimeMs) {
            this.myFramePositionMs = this.myLoopEnabled ? this.myMaxTimeMs : this.myMinTimeMs;
        } else if (!this.isUnlimitedAnimationToolbar() && this.myFramePositionMs > this.myMaxTimeMs) {
            this.myFramePositionMs = this.myLoopEnabled ? this.myMinTimeMs : this.myMaxTimeMs;
        }
        this.onNewFramePosition(setByUser);
        this.doFrame();
    }

    private void seek(long newPositionMs) {
        this.setFramePosition(this.myMinTimeMs + newPositionMs, true);
    }

    private void onTick(long elapsed) {
        this.setFramePosition(this.myFramePositionMs + elapsed, false);
    }

    public void setMaxtimeMs(long maxTimeMs) {
        assert (this.isUnlimitedAnimationToolbar()) : "Max time can not be set for unlimited animations";
        this.myMaxTimeMs = maxTimeMs;
    }

    public void stop() {
        this.onStop();
    }

    private boolean isUnlimitedAnimationToolbar() {
        return this.myMaxTimeMs == -1L;
    }

    public void dispose() {
        this.stopFrameTicker();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/editor/AnimationToolbar";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/editor/AnimationToolbar";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnlimitedAnimationToolbar";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnimationToolbar";
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "newControlButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUnlimitedAnimationToolbar";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAnimationToolbar";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "newControlButton";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$newControlButton$5";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$newControlButton$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AnimationListener {
        public void animateTo(long var1);
    }
}

