/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItemResolver;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.ui.resourcechooser.AsyncIcon;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.android.tools.idea.ui.resourcechooser.ResourceChooserItem;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ResourceDrawablePanel
extends JBScrollPane
implements ActionListener {
    private final ChooseResourceDialog myDialog;
    private JBLabel myNameLabel;
    private JBLabel myImageLabel;
    private JComboBox myQualifierCombo;
    private JBLabel myTypeLabel;
    private JPanel myPanel;
    private JPanel myResolvedPanel;
    private JBScrollPane myResolvedScrollPane;
    private boolean myIgnoreSelection;
    private ResourceChooserItem myItem;

    public ResourceDrawablePanel(@NotNull ChooseResourceDialog dialog) {
        if (dialog == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(0);
        }
        this.myDialog = dialog;
        this.$$$setupUI$$$();
        this.setBorder(null);
        this.setViewportView(this.myPanel);
        this.myQualifierCombo.addActionListener(this);
        this.myResolvedPanel.setLayout((LayoutManager)new VerticalFlowLayout());
        this.myResolvedScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myResolvedScrollPane.setViewportBorder(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(@NotNull ResourceChooserItem item) {
        int index;
        String folderName;
        FolderConfiguration folderConfig;
        File folder;
        File rendered;
        String value;
        ResourceValue resourceValue;
        if (item == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(1);
        }
        this.myItem = item;
        List<String> qualifiers = item.getQualifiers();
        this.myQualifierCombo.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(qualifiers)));
        String currentQualifier = "Default";
        ResourceResolver resourceResolver = this.myDialog.getConfiguration().getResourceResolver();
        if (resourceResolver != null && (resourceValue = resourceResolver.resolveResValue(item.getResourceValue())) != null && (value = resourceValue.getValue()) != null && (rendered = new File(value)).exists() && (folder = rendered.getParentFile()) != null && (folderConfig = FolderConfiguration.getConfigForFolder((String)(folderName = folder.getName()))) != null && (index = folderName.indexOf(45)) != -1) {
            currentQualifier = folderName.substring(index + 1);
        }
        try {
            this.myIgnoreSelection = true;
            this.myQualifierCombo.setSelectedItem(currentQualifier);
        }
        finally {
            this.myIgnoreSelection = false;
        }
        this.show(item);
    }

    private void show(@NotNull ResourceChooserItem item) {
        if (item == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(2);
        }
        this.updateName(item);
        this.updateIcon(item);
        this.updateTypeLabel(item);
        this.updateResolutionChain(item);
        this.validate();
    }

    private void updateName(@NotNull ResourceChooserItem item) {
        if (item == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(3);
        }
        String name = item.getName();
        this.myNameLabel.setText(name);
    }

    private void updateIcon(@NotNull ResourceChooserItem item) {
        String path;
        String selectedItem;
        if (item == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(4);
        }
        String string = selectedItem = this.myQualifierCombo.getSelectedItem() != null ? this.myQualifierCombo.getSelectedItem().toString() : "Default";
        if ("Default".equals(selectedItem)) {
            path = item.getPath();
        } else {
            path = item.getFileForQualifiers(selectedItem);
            if (path == null) {
                path = item.getPath();
            }
        }
        int height = this.myImageLabel.getHeight();
        if (height == 0) {
            height = 300;
        }
        ListenableFuture<Icon> futureIcon = this.myDialog.createIcon(height, JBUI.scale((int)8), false, path, item.getResourceValue(), item.getType());
        this.myImageLabel.setIcon((Icon)new AsyncIcon(futureIcon, (Icon)EmptyIcon.create((int)height), () -> this.myImageLabel.repaint()));
    }

    private void updateTypeLabel(@NotNull ResourceChooserItem item) {
        String fileName;
        String extension;
        if (item == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(5);
        }
        String type = "";
        if (item.getType() == ResourceType.MIPMAP) {
            type = ResourceType.MIPMAP.getDisplayName().toUpperCase(Locale.US);
        } else if (item.getType() != ResourceType.COLOR && !(extension = (fileName = item.getFile().getName()).substring(fileName.lastIndexOf(46) + 1)).isEmpty()) {
            type = extension.toUpperCase(Locale.US);
        }
        this.myTypeLabel.setText(type);
    }

    private void updateResolutionChain(@NotNull ResourceChooserItem item) {
        if (item == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(6);
        }
        this.myResolvedPanel.removeAll();
        ResourceValue resourceValue = item.getResourceValue();
        Configuration configuration = this.myDialog.getConfiguration();
        ResourceRepository frameworkResources = configuration.getFrameworkResources();
        if (frameworkResources != null) {
            AppResourceRepository appResources = AppResourceRepository.getOrCreateInstance(this.myDialog.getFacet());
            ResourceItemResolver resolver = new ResourceItemResolver(configuration.getFullConfig(), frameworkResources, (AbstractResourceRepository)appResources, null);
            ArrayList lookupChain = Lists.newArrayList();
            lookupChain.add(resourceValue);
            resolver.setLookupChainList((List)lookupChain);
            resolver.resolveResValue(resourceValue);
            String prev = null;
            int indent = 0;
            if (lookupChain.size() >= 2) {
                for (ResourceValue element : lookupChain) {
                    String text;
                    String value;
                    if (element == null || (value = element.getValue()) == null || (text = value).equals(prev)) continue;
                    if (!text.startsWith("?") && !text.startsWith("@")) {
                        if (indent == 0) break;
                        int end = Math.max(text.lastIndexOf(47), text.lastIndexOf(92));
                        if (end != -1) {
                            text = text.substring(end + 1);
                        }
                    }
                    if (indent > 0) {
                        text = "\u21d2 " + text;
                    }
                    JBLabel label = new JBLabel(text);
                    label.setBorder((Border)JBUI.Borders.empty((int)0, (int)JBUI.scale((int)(indent * 12)), (int)0, (int)0));
                    this.myResolvedPanel.add((Component)label);
                    ++indent;
                    prev = value;
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myQualifierCombo && !this.myIgnoreSelection) {
            this.show(this.myItem);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ResourceDrawablePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateTypeLabel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateResolutionChain";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBScrollPane jBScrollPane;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JComboBox jComboBox;
        JBLabel jBLabel3;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 5, new Insets(12, 12, 11, 11), -1, -1, false, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Name:");
        jPanel2.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myNameLabel = jBLabel3 = new JBLabel();
        jBLabel3.setName("drawablePreviewName");
        jBLabel3.setText("");
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myQualifierCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 3, 1, 2, 4, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(1, 0, 1, 5, 1, 1, 7, 1, null, null, null));
        this.myImageLabel = jBLabel2 = new JBLabel();
        jBLabel2.setAlignmentY(0.0f);
        jBLabel2.setHorizontalAlignment(2);
        jBLabel2.setIconTextGap(0);
        jBLabel2.setName("drawablePreviewLabel");
        jPanel2.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 4, 8, 2, 0, 0, null, new Dimension(300, 300), null));
        this.myTypeLabel = jBLabel = new JBLabel();
        jBLabel.setName("drawablePreviewType");
        jBLabel.setText("PNG");
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 4, 1, 1, 5, 0, 0, 0, null, null, null));
        this.myResolvedScrollPane = jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(3, 0, 1, 5, 0, 3, 7, 7, null, null, null));
        this.myResolvedPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setName("resolutionChain");
        jBScrollPane.setViewportView(jPanel);
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(4, 2, 1, 1, 0, 2, 1, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

