/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.junit;

import com.android.tools.idea.IdeInfo;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.RunManagerSettings;
import java.util.Collection;
import java.util.HashSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class AndroidJUnitConfigurationConverter
extends ProjectConverter {
    static final String CONFIGURATION_TYPE_ATTRIBUTE = "type";
    static final String FACTORY_NAME_ATTRIBUTE = "factoryName";
    static final String TEMPLATE_FLAG_ATTRIBUTE = "default";
    static final String JUNIT_CONFIGURATION_TYPE = "JUnit";
    static final String JUNIT_CONFIGURATION_FACTORY_NAME = "JUnit";
    static final String ANDROID_JUNIT_CONFIGURATION_TYPE = "AndroidJUnit";
    static final String ANDROID_JUNIT_CONFIGURATION_FACTORY_NAME = "Android JUnit";

    @NotNull
    public ConversionProcessor<RunManagerSettings> createRunConfigurationsConverter() {
        ConversionProcessor<RunManagerSettings> conversionProcessor = new ConversionProcessor<RunManagerSettings>(){

            public boolean isConversionNeeded(RunManagerSettings settings) {
                return IdeInfo.getInstance().isAndroidStudio() && !this.getConfigurationsToConvert(settings).isEmpty();
            }

            public void process(RunManagerSettings settings) throws CannotConvertException {
                for (Element element : this.getConfigurationsToConvert(settings)) {
                    element.setAttribute(AndroidJUnitConfigurationConverter.CONFIGURATION_TYPE_ATTRIBUTE, AndroidJUnitConfigurationConverter.ANDROID_JUNIT_CONFIGURATION_TYPE);
                    element.setAttribute(AndroidJUnitConfigurationConverter.FACTORY_NAME_ATTRIBUTE, AndroidJUnitConfigurationConverter.ANDROID_JUNIT_CONFIGURATION_FACTORY_NAME);
                }
            }

            @NotNull
            private Collection<Element> getConfigurationsToConvert(RunManagerSettings settings) {
                Collection configurationElements = settings.getRunConfigurations();
                HashSet<Element> toConvert = new HashSet<Element>();
                for (Element element : configurationElements) {
                    String typeName = element.getAttributeValue(AndroidJUnitConfigurationConverter.CONFIGURATION_TYPE_ATTRIBUTE);
                    String factoryName = element.getAttributeValue(AndroidJUnitConfigurationConverter.FACTORY_NAME_ATTRIBUTE);
                    Boolean isTemplate = (boolean)Boolean.valueOf(element.getAttributeValue(AndroidJUnitConfigurationConverter.TEMPLATE_FLAG_ATTRIBUTE));
                    if (isTemplate.booleanValue() || !typeName.equals("JUnit") || !factoryName.equals("JUnit")) continue;
                    toConvert.add(element);
                }
                HashSet<Element> hashSet = toConvert;
                if (hashSet == null) {
                    1.$$$reportNull$$$0(0);
                }
                return hashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfigurationConverter$1", "getConfigurationsToConvert"));
            }
        };
        if (conversionProcessor == null) {
            AndroidJUnitConfigurationConverter.$$$reportNull$$$0(0);
        }
        return conversionProcessor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfigurationConverter", "createRunConfigurationsConverter"));
    }
}

