/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.tools.idea.templates.CircularParameterDependencyException;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.StringEvaluator;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParameterValueResolver {
    @NotNull
    private static final Deduplicator DO_NOTHING_DEDUPLICATOR = (parameter, value) -> value;
    @NotNull
    private final Set<Parameter> myComputedParameters;
    @NotNull
    private final Set<Parameter> myStaticParameters;
    @NotNull
    private final Deduplicator myDeduplicator;
    @NotNull
    private final StringEvaluator myStringEvaluator;
    @NotNull
    private final Map<Parameter, Object> myUserValues;
    @NotNull
    private final Map<String, Object> myAdditionalValues;

    @NotNull
    public static Map<Parameter, Object> resolve(@NotNull Iterable<Parameter> parameters, @NotNull Map<Parameter, Object> userValues, @NotNull Map<String, Object> additionalValues) throws CircularParameterDependencyException {
        if (parameters == null) {
            ParameterValueResolver.$$$reportNull$$$0(0);
        }
        if (userValues == null) {
            ParameterValueResolver.$$$reportNull$$$0(1);
        }
        if (additionalValues == null) {
            ParameterValueResolver.$$$reportNull$$$0(2);
        }
        Map<Parameter, Object> map = ParameterValueResolver.resolve(parameters, userValues, additionalValues, DO_NOTHING_DEDUPLICATOR);
        if (map == null) {
            ParameterValueResolver.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public static Map<Parameter, Object> resolve(@NotNull Iterable<Parameter> parameters, @NotNull Map<Parameter, Object> userValues, @NotNull Map<String, Object> additionalValues, @NotNull Deduplicator deduplicator) throws CircularParameterDependencyException {
        if (parameters == null) {
            ParameterValueResolver.$$$reportNull$$$0(4);
        }
        if (userValues == null) {
            ParameterValueResolver.$$$reportNull$$$0(5);
        }
        if (additionalValues == null) {
            ParameterValueResolver.$$$reportNull$$$0(6);
        }
        if (deduplicator == null) {
            ParameterValueResolver.$$$reportNull$$$0(7);
        }
        ParameterValueResolver resolver = new ParameterValueResolver(parameters, userValues, additionalValues, deduplicator);
        Map<Parameter, Object> map = resolver.resolve();
        if (map == null) {
            ParameterValueResolver.$$$reportNull$$$0(8);
        }
        return map;
    }

    private ParameterValueResolver(@NotNull Iterable<Parameter> parameters, @NotNull Map<Parameter, Object> userValues, @NotNull Map<String, Object> additionalValues, @NotNull Deduplicator deduplicator) {
        if (parameters == null) {
            ParameterValueResolver.$$$reportNull$$$0(9);
        }
        if (userValues == null) {
            ParameterValueResolver.$$$reportNull$$$0(10);
        }
        if (additionalValues == null) {
            ParameterValueResolver.$$$reportNull$$$0(11);
        }
        if (deduplicator == null) {
            ParameterValueResolver.$$$reportNull$$$0(12);
        }
        this.myComputedParameters = Sets.newHashSet();
        this.myStaticParameters = Sets.newHashSet();
        this.myStringEvaluator = new StringEvaluator();
        this.myUserValues = userValues;
        this.myAdditionalValues = additionalValues;
        for (Parameter parameter : parameters) {
            if (parameter == null || StringUtil.isEmptyOrSpaces((String)parameter.id)) continue;
            if (!StringUtil.isEmptyOrSpaces((String)ParameterValueResolver.getSuggestOrInitial(parameter)) && !userValues.containsKey(parameter)) {
                this.myComputedParameters.add(parameter);
                continue;
            }
            this.myStaticParameters.add(parameter);
        }
        this.myDeduplicator = deduplicator;
    }

    @NotNull
    private static String getSuggestOrInitial(Parameter parameter) {
        String string = StringUtil.isEmptyOrSpaces((String)parameter.suggest) && parameter.constraints.contains((Object)Parameter.Constraint.UNIQUE) ? parameter.initial : parameter.suggest;
        if (string == null) {
            ParameterValueResolver.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    private static Object decodeInitialValue(@NotNull Parameter input, @Nullable String initial) {
        if (input == null) {
            ParameterValueResolver.$$$reportNull$$$0(14);
        }
        if (initial != null && input.type == Parameter.Type.BOOLEAN) {
            return Boolean.valueOf(initial);
        }
        return initial;
    }

    @NotNull
    public Map<Parameter, Object> resolve() throws CircularParameterDependencyException {
        Map<String, Object> staticValues = this.getStaticParameterValues(this.myUserValues, this.myAdditionalValues);
        Map<String, Object> computedValues = this.computeParameterValues(staticValues);
        HashMap allValues = Maps.newHashMapWithExpectedSize((int)(computedValues.size() + staticValues.size()));
        for (Parameter parameter : Iterables.concat(this.myStaticParameters, this.myComputedParameters)) {
            allValues.put(parameter, computedValues.get(parameter.id));
        }
        HashMap hashMap = allValues;
        if (hashMap == null) {
            ParameterValueResolver.$$$reportNull$$$0(15);
        }
        return hashMap;
    }

    @Nullable
    private Object computeParameterValue(@NotNull Parameter computedParameter, @NotNull Map<String, Object> currentValues) {
        if (computedParameter == null) {
            ParameterValueResolver.$$$reportNull$$$0(16);
        }
        if (currentValues == null) {
            ParameterValueResolver.$$$reportNull$$$0(17);
        }
        String suggest = ParameterValueResolver.getSuggestOrInitial(computedParameter);
        assert (!StringUtil.isEmptyOrSpaces((String)suggest));
        String value = this.myStringEvaluator.evaluate(suggest, currentValues);
        value = this.myDeduplicator.deduplicate(computedParameter, value);
        return ParameterValueResolver.decodeInitialValue(computedParameter, value);
    }

    @NotNull
    private Map<String, Object> getStaticParameterValues(@NotNull Map<Parameter, Object> userValues, @NotNull Map<String, Object> additionalValues) {
        if (userValues == null) {
            ParameterValueResolver.$$$reportNull$$$0(18);
        }
        if (additionalValues == null) {
            ParameterValueResolver.$$$reportNull$$$0(19);
        }
        HashMap knownValues = Maps.newHashMapWithExpectedSize((int)(this.myStaticParameters.size() + additionalValues.size()));
        knownValues.putAll(additionalValues);
        for (Parameter parameter : this.myStaticParameters) {
            Object value;
            if (userValues.containsKey(parameter)) {
                value = userValues.get(parameter);
            } else if (additionalValues.containsKey(parameter.id)) {
                value = additionalValues.get(parameter.id);
            } else {
                String initial = parameter.initial;
                value = ParameterValueResolver.decodeInitialValue(parameter, initial);
            }
            knownValues.put(parameter.id, value);
        }
        HashMap hashMap = knownValues;
        if (hashMap == null) {
            ParameterValueResolver.$$$reportNull$$$0(20);
        }
        return hashMap;
    }

    @NotNull
    private Map<String, Object> computeParameterValues(@NotNull Map<String, Object> staticValues) throws CircularParameterDependencyException {
        if (staticValues == null) {
            ParameterValueResolver.$$$reportNull$$$0(21);
        }
        HashMap computedValues = Maps.newHashMapWithExpectedSize((int)(this.myComputedParameters.size() + staticValues.size()));
        computedValues.putAll(staticValues);
        for (Parameter parameter : this.myComputedParameters) {
            computedValues.put(parameter.id, "");
        }
        int maxIterations = 2 * this.myComputedParameters.size();
        Object updatedValues = ImmutableMap.of();
        for (int i = 0; i <= maxIterations; ++i) {
            updatedValues = this.computeUpdatedValues(computedValues);
            if (updatedValues.isEmpty()) {
                HashMap hashMap = computedValues;
                if (hashMap == null) {
                    ParameterValueResolver.$$$reportNull$$$0(22);
                }
                return hashMap;
            }
            computedValues.putAll(updatedValues);
        }
        throw new CircularParameterDependencyException(updatedValues.keySet());
    }

    @NotNull
    private Map<String, Object> computeUpdatedValues(@NotNull Map<String, Object> values) {
        if (values == null) {
            ParameterValueResolver.$$$reportNull$$$0(23);
        }
        HashMap updatedValues = Maps.newHashMapWithExpectedSize((int)this.myComputedParameters.size());
        for (Parameter computedParameter : this.myComputedParameters) {
            Object value = this.computeParameterValue(computedParameter, values);
            String id = computedParameter.id;
            if (Objects.equal((Object)values.get(id), (Object)value)) continue;
            updatedValues.put(id, value);
        }
        HashMap hashMap = updatedValues;
        if (hashMap == null) {
            ParameterValueResolver.$$$reportNull$$$0(24);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 15: 
            case 20: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 15: 
            case 20: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userValues";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalValues";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 15: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/templates/ParameterValueResolver";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deduplicator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computedParameter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValues";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticValues";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/templates/ParameterValueResolver";
                break;
            }
            case 3: 
            case 8: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestOrInitial";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticParameterValues";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "computeParameterValues";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "computeUpdatedValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 15: 
            case 20: 
            case 22: 
            case 24: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "decodeInitialValue";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeParameterValue";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStaticParameterValues";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeParameterValues";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "computeUpdatedValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 15: 
            case 20: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Deduplicator {
        @Nullable
        public String deduplicate(@NotNull Parameter var1, @Nullable String var2);
    }
}

