/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.tools.idea.templates.FmUtil;
import com.android.tools.idea.templates.TemplateUtils;
import freemarker.template.utility.StringUtil;
import java.security.InvalidParameterException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssetNameConverter {
    private static final String ACTIVITY_NAME_SUFFIX = "Activity";
    private static final String DEFAULT_LAYOUT_NAME_PREFIX = "activity";
    private static final Pattern ACTIVITY_NAME_PATTERN = Pattern.compile("^(.*)Activity(\\d*)$");
    static final String[] STRIP_CLASS_SUFFIXES = new String[]{"Activity", "Fragment", "Service", "Provider"};
    @NotNull
    private final Type myType;
    @NotNull
    private final String myName;
    @Nullable
    private String myLayoutPrefixOverride;

    public AssetNameConverter(@NotNull Type type, @NotNull String name) {
        if (type == null) {
            AssetNameConverter.$$$reportNull$$$0(0);
        }
        if (name == null) {
            AssetNameConverter.$$$reportNull$$$0(1);
        }
        this.myType = type;
        this.myName = name;
    }

    @NotNull
    private String toClassName() {
        String className;
        switch (this.myType) {
            case ACTIVITY: {
                className = AssetNameConverter.stripActivitySuffix(this.myName);
                break;
            }
            case LAYOUT: {
                String layoutPrefix = this.getLayoutPrefixWithTrailingUnderscore();
                String layoutName = this.myName;
                if (layoutName.startsWith(layoutPrefix)) {
                    layoutName = layoutName.substring(layoutPrefix.length());
                }
                className = TemplateUtils.underlinesToCamelCase(layoutName);
                break;
            }
            case RESOURCE: {
                className = TemplateUtils.underlinesToCamelCase(this.myName);
                break;
            }
            case CLASS_NAME: {
                className = this.myName;
                for (String suffix : STRIP_CLASS_SUFFIXES) {
                    className = FmUtil.stripSuffix(className, suffix, true);
                }
                if (this.myLayoutPrefixOverride == null) break;
                String prefixAsSuffix = TemplateUtils.underlinesToCamelCase(this.myLayoutPrefixOverride);
                className = FmUtil.stripSuffix(className, prefixAsSuffix, false);
                break;
            }
            default: {
                throw new InvalidParameterException("Unhandled type: " + (Object)((Object)this.myType));
            }
        }
        String string = className;
        if (string == null) {
            AssetNameConverter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public AssetNameConverter overrideLayoutPrefix(@Nullable String layoutPrefixOverride) {
        this.myLayoutPrefixOverride = layoutPrefixOverride;
        AssetNameConverter assetNameConverter = this;
        if (assetNameConverter == null) {
            AssetNameConverter.$$$reportNull$$$0(3);
        }
        return assetNameConverter;
    }

    @NotNull
    public String getValue(@NotNull Type type) {
        if (type == null) {
            AssetNameConverter.$$$reportNull$$$0(4);
        }
        String className = this.toClassName();
        switch (type) {
            case ACTIVITY: {
                String activityName = TemplateUtils.extractClassName(className);
                if (activityName == null) {
                    activityName = "Main";
                }
                String string = activityName + ACTIVITY_NAME_SUFFIX;
                if (string == null) {
                    AssetNameConverter.$$$reportNull$$$0(5);
                }
                return string;
            }
            case LAYOUT: {
                String layoutPrefix = this.getLayoutPrefixWithTrailingUnderscore();
                String layoutName = TemplateUtils.camelCaseToUnderlines(className);
                layoutName = StringUtil.replace((String)layoutName, (String)layoutPrefix, (String)"", (boolean)false, (boolean)true);
                String string = layoutPrefix + layoutName;
                if (string == null) {
                    AssetNameConverter.$$$reportNull$$$0(6);
                }
                return string;
            }
            case RESOURCE: {
                String string = TemplateUtils.camelCaseToUnderlines(className);
                if (string == null) {
                    AssetNameConverter.$$$reportNull$$$0(7);
                }
                return string;
            }
            case CLASS_NAME: {
                String string = className;
                if (string == null) {
                    AssetNameConverter.$$$reportNull$$$0(8);
                }
                return string;
            }
        }
        throw new InvalidParameterException("Unhandled type: " + (Object)((Object)type));
    }

    private static String stripActivitySuffix(@NotNull String activityName) {
        Matcher m;
        String finalName;
        if (activityName == null) {
            AssetNameConverter.$$$reportNull$$$0(9);
        }
        if ((finalName = FmUtil.stripSuffix(activityName, ACTIVITY_NAME_SUFFIX, false)).equals(activityName) && (m = ACTIVITY_NAME_PATTERN.matcher(activityName)).matches()) {
            String baseName = m.group(1);
            String digits = m.group(2);
            finalName = baseName + digits;
        }
        return finalName;
    }

    @NotNull
    private String getLayoutPrefixWithTrailingUnderscore() {
        String string = (this.myLayoutPrefixOverride == null ? DEFAULT_LAYOUT_NAME_PREFIX : this.myLayoutPrefixOverride) + "_";
        if (string == null) {
            AssetNameConverter.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/templates/AssetNameConverter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/templates/AssetNameConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toClassName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "overrideLayoutPrefix";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutPrefixWithTrailingUnderscore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "stripActivitySuffix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Type {
        ACTIVITY,
        LAYOUT,
        CLASS_NAME,
        RESOURCE;

    }
}

