/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import org.jetbrains.android.formatter.AndroidXmlCodeStyleSettings;
import org.jetbrains.android.formatter.AndroidXmlPredefinedCodeStyle;

public class AndroidCodeStyleSettingsModifier {
    public static void modify(CodeStyleSettings settings) {
        AndroidXmlCodeStyleSettings.getInstance((CodeStyleSettings)settings).USE_CUSTOM_SETTINGS = true;
        AndroidXmlPredefinedCodeStyle xmlStyle = new AndroidXmlPredefinedCodeStyle();
        xmlStyle.apply(settings);
        JavaCodeStyleSettings javaSettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
        javaSettings.IMPORT_LAYOUT_TABLE.copyFrom(AndroidCodeStyleSettingsModifier.getAndroidImportOrder());
        javaSettings.PACKAGES_TO_USE_IMPORT_ON_DEMAND.copyFrom(new PackageEntryTable());
        javaSettings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = 99;
        javaSettings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = 99;
        settings.setDefaultRightMargin(100);
    }

    private static PackageEntryTable getAndroidImportOrder() {
        PackageEntryTable table2 = new PackageEntryTable();
        table2.addEntry(new PackageEntry(false, "android", true));
        table2.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        table2.addEntry(new PackageEntry(false, "com", true));
        table2.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        table2.addEntry(new PackageEntry(false, "junit", true));
        table2.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        table2.addEntry(new PackageEntry(false, "net", true));
        table2.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        table2.addEntry(new PackageEntry(false, "org", true));
        table2.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        table2.addEntry(new PackageEntry(false, "java", true));
        table2.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        table2.addEntry(new PackageEntry(false, "javax", true));
        table2.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        table2.addEntry(PackageEntry.ALL_OTHER_IMPORTS_ENTRY);
        table2.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        table2.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
        table2.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        return table2;
    }
}

