/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.legacy.LicenseAgreementStep;
import com.android.tools.idea.welcome.install.ComponentInstaller;
import com.android.tools.idea.welcome.install.Haxm;
import com.android.tools.idea.welcome.install.InstallComponentsOperation;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.deprecated.ProgressStep;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HaxmWizard
extends DynamicWizard {
    private static final String SDK_PACKAGE_CLEANUP_FAILED = "HAXM installer cleanup failed. The status of the package in the SDK manager may be reflected incorrectly. Reinstalling the package may solve the issue" + (SystemInfo.isWindows ? " (is the SDK folder opened in another program?)" : ".");
    HaxmPath myHaxmPath;
    boolean myInvokedToUninstall;

    public HaxmWizard(boolean invokedToUninstall) {
        super(null, null, "HAXM");
        this.myInvokedToUninstall = invokedToUninstall;
        this.myHaxmPath = new HaxmPath();
        this.addPath(this.myHaxmPath);
    }

    @Override
    public void performFinishingActions() {
    }

    @Override
    public void doCancelAction() {
        if (this.myHaxmPath.canPerformFinishingActions()) {
            this.doFinishAction();
            return;
        }
        if (!this.myInvokedToUninstall) {
            try {
                AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
                ComponentInstaller componentInstaller = new ComponentInstaller(sdkHandler);
                StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
                sdkHandler.getSdkManager((ProgressIndicator)progress).reloadLocalIfNeeded((ProgressIndicator)progress);
                componentInstaller.ensureSdkPackagesUninstalled(this.myHaxmPath.myHaxm.getRequiredSdkPackages(), (ProgressIndicator)progress);
            }
            catch (Exception e) {
                Messages.showErrorDialog((String)SDK_PACKAGE_CLEANUP_FAILED, (String)"Cleanup Error");
                LOG.warn("Failed to make sure HAXM SDK package is uninstalled after HAXM wizard was cancelled", (Throwable)e);
            }
        }
        super.doCancelAction();
    }

    @Override
    public void doFinishAction() {
        if (!this.myHaxmPath.canPerformFinishingActions()) {
            this.doCancelAction();
            return;
        }
        super.doFinishAction();
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        if ("Finishing install..." == null) {
            HaxmWizard.$$$reportNull$$$0(0);
        }
        return "Finishing install...";
    }

    @Override
    protected String getWizardActionDescription() {
        return "HAXM Installation";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/HaxmWizard", "getProgressTitle"));
    }

    private class HaxmPath
    extends DynamicWizardPath {
        SetupProgressStep mySetupProgressStep;
        Haxm myHaxm;

        private HaxmPath() {
        }

        @Override
        protected void init() {
            ScopedStateStore.Key<Boolean> canShow = ScopedStateStore.createKey("ShowHaxmSteps", ScopedStateStore.Scope.PATH, Boolean.class);
            this.myState.put(canShow, true);
            Haxm.HaxmInstallationIntention haxmInstallationIntention = HaxmWizard.this.myInvokedToUninstall ? Haxm.HaxmInstallationIntention.UNINSTALL : Haxm.HaxmInstallationIntention.INSTALL_WITH_UPDATES;
            this.myHaxm = new Haxm(haxmInstallationIntention, this.getState(), canShow);
            for (DynamicWizardStep step : this.myHaxm.createSteps()) {
                this.addStep(step);
            }
            if (!HaxmWizard.this.myInvokedToUninstall) {
                this.addStep(new LicenseAgreementStep(this.getWizard().getDisposable()));
            }
            this.mySetupProgressStep = new SetupProgressStep(this.getWizard().getDisposable(), this.myHaxm, HaxmWizard.this.myHost);
            this.addStep(this.mySetupProgressStep);
            this.myHaxm.init(this.mySetupProgressStep);
        }

        @Override
        @NotNull
        public String getPathName() {
            if ("Haxm Path" == null) {
                HaxmPath.$$$reportNull$$$0(0);
            }
            return "Haxm Path";
        }

        @Override
        public boolean canPerformFinishingActions() {
            return this.mySetupProgressStep.isSuccessfullyCompleted();
        }

        @Override
        public boolean performFinishingActions() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/HaxmWizard$HaxmPath", "getPathName"));
        }
    }

    private static class SetupProgressStep
    extends ProgressStep {
        private Haxm myHaxm;
        private final AtomicBoolean myIsSuccessfullyCompleted = new AtomicBoolean(false);
        private DynamicWizardHost myHost;
        private StudioLoggerProgressIndicator myProgressIndicator;

        SetupProgressStep(Disposable parentDisposable, Haxm haxm, DynamicWizardHost host) {
            super(parentDisposable, "Invoking installer");
            this.myHaxm = haxm;
            this.myHost = host;
            this.myProgressIndicator = new StudioLoggerProgressIndicator(this.getClass());
        }

        @Override
        public boolean canGoNext() {
            return false;
        }

        public boolean isSuccessfullyCompleted() {
            return this.myIsSuccessfullyCompleted.get();
        }

        @Override
        protected void execute() {
            this.myHost.runSensitiveOperation(this.getProgressIndicator(), true, new Runnable(){

                @Override
                public void run() {
                    try {
                        this.setupHaxm();
                        myIsSuccessfullyCompleted.set(myHaxm.isConfiguredSuccessfully());
                    }
                    catch (Exception e) {
                        DynamicWizard.LOG.warn("Exception caught while trying to configure HAXM", (Throwable)e);
                        this.showConsole();
                        this.print(e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                    }
                }
            });
        }

        @Override
        public boolean canGoPrevious() {
            return false;
        }

        private void setupHaxm() throws IOException {
            InstallOperation<File, File> opChain;
            final InstallContext installContext = new InstallContext(FileUtil.createTempDirectory((String)"AndroidStudio", (String)"Haxm", (boolean)true), this);
            final AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
            this.myHaxm.updateState(sdkHandler);
            ComponentInstaller componentInstaller = new ComponentInstaller(sdkHandler);
            ArrayList selectedComponents = Lists.newArrayList((Object[])new Haxm[]{this.myHaxm});
            double configureHaxmProgressRatio = 1.0;
            if (this.myHaxm.getInstallationIntention() == Haxm.HaxmInstallationIntention.INSTALL_WITH_UPDATES) {
                configureHaxmProgressRatio = 0.5;
            }
            InstallOperation<File, File> configureHaxmOperation = InstallOperation.wrap(installContext, new Function<File, File>(){

                public File apply(@Nullable File input) {
                    myHaxm.configure(installContext, sdkHandler);
                    return input;
                }
            }, configureHaxmProgressRatio);
            if (this.myHaxm.getInstallationIntention() == Haxm.HaxmInstallationIntention.INSTALL_WITH_UPDATES) {
                InstallComponentsOperation install = new InstallComponentsOperation(installContext, selectedComponents, componentInstaller, 0.5);
                opChain = install.then(configureHaxmOperation);
            } else {
                opChain = configureHaxmOperation;
            }
            try {
                opChain.execute(sdkHandler.getLocation());
            }
            catch (InstallationCancelledException e) {
                installContext.print("Android Studio setup was canceled", ConsoleViewContentType.ERROR_OUTPUT);
            }
            catch (WizardException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (!this.myHaxm.isConfiguredSuccessfully() && this.myHaxm.getInstallationIntention() != Haxm.HaxmInstallationIntention.UNINSTALL) {
                    try {
                        sdkHandler.getSdkManager((ProgressIndicator)this.myProgressIndicator).reloadLocalIfNeeded((ProgressIndicator)this.myProgressIndicator);
                        componentInstaller.ensureSdkPackagesUninstalled(this.myHaxm.getRequiredSdkPackages(), (ProgressIndicator)this.myProgressIndicator);
                    }
                    catch (WizardException e) {
                        DynamicWizard.LOG.warn("HAXM SDK package cleanup failed due to an exception", (Throwable)e);
                        installContext.print(SDK_PACKAGE_CLEANUP_FAILED, ConsoleViewContentType.ERROR_OUTPUT);
                    }
                }
            }
            installContext.print("Done", ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }
}

