/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.util;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.sdklib.AndroidVersion;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiUserUtils {
    public static final int PRIMARY_USERID = 0;

    /*
     * WARNING - void declaration
     */
    public static boolean isCurrentUserThePrimaryUser(@NotNull IDevice device, long timeout, TimeUnit units, boolean bl) {
        void defaultValue;
        if (device == null) {
            MultiUserUtils.$$$reportNull$$$0(0);
        }
        if (device.getVersion().getApiLevel() < AndroidVersion.SUPPORTS_MULTI_USER.getApiLevel()) {
            return false;
        }
        CountDownLatch latch = new CountDownLatch(1);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
        try {
            device.executeShellCommand("am get-current-user", (IShellOutputReceiver)receiver);
        }
        catch (Exception e) {
            return (boolean)defaultValue;
        }
        try {
            latch.await(timeout, units);
        }
        catch (InterruptedException e) {
            Logger.getInstance(MultiUserUtils.class).warn("Timed out waiting for output from `am get-current-user`, returning " + (boolean)defaultValue);
            return (boolean)defaultValue;
        }
        String output = receiver.getOutput();
        try {
            return Integer.parseInt(output.trim()) == 0;
        }
        catch (NumberFormatException e) {
            if (output.length() > 40) {
                output = output.substring(0, 40) + "...";
            }
            Logger.getInstance(MultiUserUtils.class).warn("Error parsing output of `am get-current-user`: " + output);
            return (boolean)defaultValue;
        }
    }

    public static boolean hasMultipleUsers(@Nullable IDevice device, long timeout, TimeUnit units, boolean defaultValue) {
        if (device == null) {
            return defaultValue;
        }
        if (device.getVersion().getApiLevel() < AndroidVersion.SUPPORTS_MULTI_USER.getApiLevel()) {
            return false;
        }
        CountDownLatch latch = new CountDownLatch(1);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
        try {
            device.executeShellCommand("pm list users", (IShellOutputReceiver)receiver);
        }
        catch (Exception e) {
            return defaultValue;
        }
        try {
            latch.await(timeout, units);
        }
        catch (InterruptedException e) {
            Logger.getInstance(MultiUserUtils.class).warn("Timed out waiting for output from `pm list users`, returning " + defaultValue);
            return defaultValue;
        }
        String[] lines = receiver.getOutput().trim().split("\n");
        int numUsers = 0;
        for (String line : lines) {
            if (!line.contains("UserInfo{")) continue;
            ++numUsers;
        }
        return numUsers > 1;
    }

    public static int getUserIdFromAmParameters(@NotNull String amFlags) {
        String userFlag;
        int i;
        if (amFlags == null) {
            MultiUserUtils.$$$reportNull$$$0(1);
        }
        if ((i = amFlags.indexOf(userFlag = "--user")) < 0) {
            return 0;
        }
        if ((i += userFlag.length() + 1) > amFlags.length()) {
            return 0;
        }
        amFlags = amFlags.substring(i).trim();
        try {
            return Integer.parseInt(amFlags);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "amFlags";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/util/MultiUserUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCurrentUserThePrimaryUser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getUserIdFromAmParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

