/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorNotificationPanel;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdOptionsModel;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidDeviceRenderer;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DevicePickerEntry;
import com.android.tools.idea.run.DevicePickerListModel;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.editor.HelpHandler;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.wireless.android.sdk.stats.AdbAssistantStats;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class DevicePicker
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener,
Disposable,
ActionListener,
ListSelectionListener {
    private static final int UPDATE_DELAY_MILLIS = 250;
    private static final String DEVICE_PICKER_LAST_SELECTION = "device.picker.selection";
    private static final TIntObjectHashMap<Set<String>> ourSelectionsPerConfig = new TIntObjectHashMap();
    private JPanel myPanel;
    private JButton myCreateEmulatorButton;
    private HyperlinkLabel myHelpHyperlink;
    private JScrollPane myScrollPane;
    private JPanel myNotificationPanel;
    private JBList<DevicePickerEntry> myDevicesList;
    private final AndroidDeviceRenderer myDeviceRenderer;
    private int myErrorGen;
    @NotNull
    private HelpHandler myHelpHandler;
    @NotNull
    private final AndroidFacet myFacet;
    private final int myRunContextId;
    private DevicePickerListModel myModel;
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    private final LaunchCompatibilityChecker myCompatibilityChecker;
    private List<AvdInfo> myAvdInfos;

    public DevicePicker(@NotNull Disposable parent, int runContextId, @NotNull AndroidFacet facet, @NotNull DeviceCount deviceCount, @NotNull LaunchCompatibilityChecker compatibilityChecker, @NotNull HelpHandler helpHandler) {
        if (parent == null) {
            DevicePicker.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            DevicePicker.$$$reportNull$$$0(1);
        }
        if (deviceCount == null) {
            DevicePicker.$$$reportNull$$$0(2);
        }
        if (compatibilityChecker == null) {
            DevicePicker.$$$reportNull$$$0(3);
        }
        if (helpHandler == null) {
            DevicePicker.$$$reportNull$$$0(4);
        }
        this.$$$setupUI$$$();
        this.myAvdInfos = new ArrayList<AvdInfo>();
        this.myRunContextId = runContextId;
        this.myFacet = facet;
        this.myHelpHyperlink.addHyperlinkListener(e -> {
            if (helpHandler == null) {
                DevicePicker.$$$reportNull$$$0(23);
            }
            helpHandler.launchDiagnostics(AdbAssistantStats.Trigger.DONT_SEE_DEVICE);
        });
        this.myCompatibilityChecker = compatibilityChecker;
        this.myHelpHandler = helpHandler;
        DeviceListSpeedSearch speedSearch = new DeviceListSpeedSearch(this.myDevicesList);
        this.myDeviceRenderer = new AndroidDeviceRenderer(this.myCompatibilityChecker, (SpeedSearchBase)speedSearch);
        this.setModel(new DevicePickerListModel());
        this.myDevicesList.setCellRenderer((ListCellRenderer)((Object)this.myDeviceRenderer));
        this.myDevicesList.setSelectionMode(DevicePicker.getListSelectionMode(deviceCount));
        this.myDevicesList.addKeyListener((KeyListener)new MyListKeyListener(speedSearch));
        this.myDevicesList.addListSelectionListener((ListSelectionListener)this);
        this.myNotificationPanel.setLayout(new BoxLayout(this.myNotificationPanel, 1));
        this.myCreateEmulatorButton.addActionListener(this);
        this.myUpdateQueue = new MergingUpdateQueue("android.device.chooser", 250, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.postUpdate();
        this.refreshAvds(null);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void dispose() {
        this.myDevicesList = null;
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDevicesList;
    }

    private void createUIComponents() {
        this.myDevicesList = new JBList();
        this.myScrollPane = ScrollPaneFactory.createScrollPane(this.myDevicesList);
        this.myHelpHyperlink = new HyperlinkLabel("Don't see your device?");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myCreateEmulatorButton) {
            AvdOptionsModel avdOptionsModel = new AvdOptionsModel(null);
            ModelWizardDialog dialog = AvdWizardUtils.createAvdWizard((Component)this.myPanel, this.myFacet.getModule().getProject(), avdOptionsModel);
            if (dialog.showAndGet()) {
                AvdInfo createdAvd = avdOptionsModel.getCreatedAvd();
                this.refreshAvds(createdAvd);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.myDevicesList) {
            Set<String> selectedSerials = DevicePicker.getSelectedSerials(this.myDevicesList.getSelectedValuesList());
            ourSelectionsPerConfig.put(this.myRunContextId, selectedSerials);
            DevicePicker.saveSelectionForProject(this.myFacet.getModule().getProject(), selectedSerials);
        }
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        this.postUpdate();
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device == null) {
            DevicePicker.$$$reportNull$$$0(5);
        }
        this.postUpdate();
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == null) {
            DevicePicker.$$$reportNull$$$0(6);
        }
        this.postUpdate();
    }

    public void deviceChanged(IDevice device, int changeMask) {
        this.postUpdate();
    }

    public void refreshAvds(AvdInfo avdToSelect) {
        this.myDevicesList.setPaintBusy(true);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ImmutableList avdInfos = ImmutableList.copyOf(AvdManagerConnection.getDefaultAvdManagerConnection().getAvds(true));
            DevicePicker.invokeLater(() -> this.lambda$null$1((List)avdInfos, avdToSelect));
        });
    }

    private void updateErrorCheck() {
        ++this.myErrorGen;
        this.myNotificationPanel.removeAll();
        if (this.myModel.getNumberOfConnectedDevices() == 0) {
            EditorNotificationPanel panel = new EditorNotificationPanel();
            panel.setText("No USB devices or running emulators detected");
            panel.createActionLabel("Troubleshoot", () -> this.myHelpHandler.launchDiagnostics(AdbAssistantStats.Trigger.NO_RUNNING_DEVICE));
            this.myNotificationPanel.add((Component)panel);
        }
        if (!this.myAvdInfos.isEmpty()) {
            int currentErrorGen = this.myErrorGen;
            DevicePicker.executeOnPooledThread(() -> {
                AccelerationErrorCode error = AvdManagerConnection.getDefaultAvdManagerConnection().checkAcceleration();
                if (error != AccelerationErrorCode.ALREADY_INSTALLED) {
                    DevicePicker.invokeLater(() -> {
                        if (this.myErrorGen != currentErrorGen) {
                            return;
                        }
                        this.myNotificationPanel.add((Component)((Object)new AccelerationErrorNotificationPanel(error, this.myFacet.getModule().getProject(), this::updateErrorCheck)));
                    });
                }
            });
        }
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    private static void executeOnPooledThread(Runnable runnable) {
        ApplicationManager.getApplication().executeOnPooledThread(runnable);
    }

    private static void invokeLater(Runnable runnable) {
        EdtInvocationManager.getInstance().invokeLater(runnable);
    }

    private void postUpdate() {
        this.myUpdateQueue.queue(new Update("updateDevicePickerModel"){

            public void run() {
                DevicePicker.this.updateModel();
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    private void selectAvd(@NotNull AvdInfo avdToSelect) {
        if (avdToSelect == null) {
            DevicePicker.$$$reportNull$$$0(7);
        }
        String serial = new LaunchableAndroidDevice(avdToSelect).getSerial();
        List<DevicePickerEntry> items = this.myModel.getItems();
        for (int i = 0; i < items.size(); ++i) {
            DevicePickerEntry entry = items.get(i);
            if (entry.isMarker()) continue;
            AndroidDevice device = entry.getAndroidDevice();
            assert (device != null) : "Non marker entry cannot be null";
            if (!serial.equals(device.getSerial())) continue;
            this.myDevicesList.setSelectedIndex(i);
            return;
        }
    }

    private void updateModel() {
        this.updateModelAndSelectAvd(null);
    }

    private void updateModelAndSelectAvd(AvdInfo avdToSelect) {
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge == null || !bridge.isConnected()) {
            return;
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            DevicePicker.invokeLater(() -> this.updateModelAndSelectAvd(avdToSelect));
            return;
        }
        if (this.myDevicesList == null) {
            return;
        }
        Set<String> selectedSerials = DevicePicker.getSelectedSerials(this.myDevicesList.getSelectedValuesList());
        List<AvdInfo> avdInfos = this.myAvdInfos;
        this.myDevicesList.setPaintBusy(true);
        DevicePicker.executeOnPooledThread(() -> {
            List<IDevice> connectedDevices = Arrays.asList(bridge.getDevices());
            DevicePickerListModel model = new DevicePickerListModel(connectedDevices, avdInfos);
            DevicePicker.invokeLater(() -> {
                if (this.myDevicesList == null) {
                    return;
                }
                this.setModel(model);
                if (avdToSelect != null) {
                    this.selectAvd(avdToSelect);
                } else {
                    int[] selectedIndices = DevicePicker.getIndices(this.myModel.getItems(), selectedSerials.isEmpty() ? this.getDefaultSelection() : selectedSerials);
                    this.myDevicesList.setSelectedIndices(selectedIndices);
                }
                this.myHelpHyperlink.setVisible(this.myModel.getNumberOfConnectedDevices() == 0);
                this.updateErrorCheck();
                this.myDevicesList.setPaintBusy(false);
            });
        });
    }

    private void setModel(@NotNull DevicePickerListModel model) {
        if (model == null) {
            DevicePicker.$$$reportNull$$$0(8);
        }
        this.myDeviceRenderer.clearCache();
        this.myModel = model;
        this.myDevicesList.setModel((ListModel)this.myModel);
    }

    @NotNull
    private static int[] getIndices(@NotNull List<DevicePickerEntry> items, @NotNull Set<String> selectedSerials) {
        if (items == null) {
            DevicePicker.$$$reportNull$$$0(9);
        }
        if (selectedSerials == null) {
            DevicePicker.$$$reportNull$$$0(10);
        }
        TIntArrayList list = new TIntArrayList(selectedSerials.size());
        for (int i = 0; i < items.size(); ++i) {
            DevicePickerEntry entry = items.get(i);
            if (entry.isMarker()) continue;
            AndroidDevice androidDevice = entry.getAndroidDevice();
            assert (androidDevice != null) : "An entry in the device picker must be either a marker or an AndroidDevice, got null";
            if (!selectedSerials.contains(androidDevice.getSerial())) continue;
            list.add(i);
        }
        int[] nArray = list.toNativeArray();
        if (nArray == null) {
            DevicePicker.$$$reportNull$$$0(11);
        }
        return nArray;
    }

    @NotNull
    private static Set<String> getSelectedSerials(@NotNull List<?> selectedValues) {
        if (selectedValues == null) {
            DevicePicker.$$$reportNull$$$0(12);
        }
        HashSet<String> selection = new HashSet<String>();
        for (Object o : selectedValues) {
            AndroidDevice device;
            if (!(o instanceof DevicePickerEntry) || (device = ((DevicePickerEntry)o).getAndroidDevice()) == null) continue;
            selection.add(device.getSerial());
        }
        HashSet<String> hashSet = selection;
        if (hashSet == null) {
            DevicePicker.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @NotNull
    private Set<String> getDefaultSelection() {
        int[] indices;
        Set<String> lastSelection = (Set<String>)ourSelectionsPerConfig.get(this.myRunContextId);
        if (lastSelection == null || lastSelection.isEmpty()) {
            lastSelection = DevicePicker.getLastSelectionForProject(this.myFacet.getModule().getProject());
        }
        if (!lastSelection.isEmpty() && (indices = DevicePicker.getIndices(this.myModel.getItems(), lastSelection)).length > 0) {
            Set<String> set = lastSelection;
            if (set == null) {
                DevicePicker.$$$reportNull$$$0(14);
            }
            return set;
        }
        for (DevicePickerEntry entry : this.myModel.getItems()) {
            if (entry.isMarker()) continue;
            AndroidDevice androidDevice = entry.getAndroidDevice();
            assert (androidDevice != null) : "Non marker entry in the device picker doesn't contain an android device";
            if (this.myCompatibilityChecker.validate(androidDevice).isCompatible() == ThreeState.NO) continue;
            ImmutableSet immutableSet = ImmutableSet.of((Object)androidDevice.getSerial());
            if (immutableSet == null) {
                DevicePicker.$$$reportNull$$$0(15);
            }
            return immutableSet;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            DevicePicker.$$$reportNull$$$0(16);
        }
        return set;
    }

    private static int getListSelectionMode(@NotNull DeviceCount deviceCount) {
        if (deviceCount == null) {
            DevicePicker.$$$reportNull$$$0(17);
        }
        return deviceCount.isMultiple() ? 2 : 0;
    }

    public ValidationInfo validate() {
        List<AndroidDevice> devices = this.getSelectedDevices();
        if (devices.isEmpty()) {
            return new ValidationInfo("No device selected", this.myDevicesList);
        }
        for (AndroidDevice device : devices) {
            LaunchCompatibility compatibility = this.myCompatibilityChecker.validate(device);
            if (compatibility.isCompatible() != ThreeState.NO) continue;
            String reason = StringUtil.notNullize((String)compatibility.getReason(), (String)"Incompatible");
            if (devices.size() > 1) {
                reason = device.getName() + ": " + reason;
            }
            return new ValidationInfo(reason, this.myDevicesList);
        }
        return null;
    }

    @NotNull
    public List<AndroidDevice> getSelectedDevices() {
        SmartList devices = new SmartList();
        for (DevicePickerEntry value : this.myDevicesList.getSelectedValuesList()) {
            AndroidDevice device = value.getAndroidDevice();
            if (device == null) continue;
            devices.add((Object)device);
        }
        SmartList smartList = devices;
        if (smartList == null) {
            DevicePicker.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    public void installDoubleClickListener(@NotNull DoubleClickListener listener) {
        if (listener == null) {
            DevicePicker.$$$reportNull$$$0(19);
        }
        new MyDoubleClickListener(listener, this).installOn((Component)this.myDevicesList);
    }

    private static Set<String> getLastSelectionForProject(@NotNull Project project) {
        String s;
        if (project == null) {
            DevicePicker.$$$reportNull$$$0(20);
        }
        return (s = PropertiesComponent.getInstance((Project)project).getValue(DEVICE_PICKER_LAST_SELECTION)) == null ? Collections.emptySet() : ImmutableSet.copyOf((Object[])s.split(" "));
    }

    private static void saveSelectionForProject(@NotNull Project project, @NotNull Set<String> selectedSerials) {
        if (project == null) {
            DevicePicker.$$$reportNull$$$0(21);
        }
        if (selectedSerials == null) {
            DevicePicker.$$$reportNull$$$0(22);
        }
        PropertiesComponent.getInstance((Project)project).setValue(DEVICE_PICKER_LAST_SELECTION, Joiner.on((char)' ').join(selectedSerials));
    }

    private /* synthetic */ void lambda$null$1(List avdInfos, AvdInfo avdToSelect) {
        if (this.myDevicesList == null) {
            return;
        }
        this.myAvdInfos = avdInfos;
        this.updateModelAndSelectAvd(avdToSelect);
        this.myDevicesList.setPaintBusy(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceCount";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compatibilityChecker";
                break;
            }
            case 4: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpHandler";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avdToSelect";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedSerials";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/editor/DevicePicker";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedValues";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/editor/DevicePicker";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndices";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedSerials";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSelection";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDevices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deviceConnected";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deviceDisconnected";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectAvd";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIndices";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedSerials";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getListSelectionMode";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "installDoubleClickListener";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLastSelectionForProject";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "saveSelectionForProject";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JButton jButton;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setPreferredSize(new Dimension(600, 400));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, "South");
        this.myCreateEmulatorButton = jButton = new JButton();
        jButton.setText("Create New Virtual Device");
        jButton.setMnemonic('C');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        HyperlinkLabel hyperlinkLabel = this.myHelpHyperlink;
        jPanel3.add((Component)hyperlinkLabel, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 3, null, null, null));
        JScrollPane jScrollPane = this.myScrollPane;
        jPanel2.add((Component)jScrollPane, "Center");
        this.myNotificationPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "North");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class MyDoubleClickListener
    extends DoubleClickListener
    implements Disposable {
        private DoubleClickListener myDelegate;

        MyDoubleClickListener(DoubleClickListener delegate, Disposable parent) {
            this.myDelegate = delegate;
            Disposer.register((Disposable)parent, (Disposable)this);
        }

        protected boolean onDoubleClick(MouseEvent event) {
            return this.myDelegate != null && this.myDelegate.onClick(event, 2);
        }

        public void dispose() {
            this.myDelegate = null;
        }
    }

    private static class DeviceListSpeedSearch
    extends ListSpeedSearch {
        DeviceListSpeedSearch(JBList list) {
            super((JList)list);
        }

        protected String getElementText(Object element) {
            DevicePickerEntry entry;
            if (element instanceof DevicePickerEntry && !(entry = (DevicePickerEntry)element).isMarker()) {
                AndroidDevice device = entry.getAndroidDevice();
                assert (device != null) : "entry not a marker, yet device is null";
                return device.getName();
            }
            return "";
        }
    }

    private static class MyListKeyListener
    extends KeyAdapter {
        private final ListSpeedSearch mySpeedSearch;

        private MyListKeyListener(@NotNull ListSpeedSearch speedSearch) {
            if (speedSearch == null) {
                MyListKeyListener.$$$reportNull$$$0(0);
            }
            this.mySpeedSearch = speedSearch;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.mySpeedSearch.isPopupActive()) {
                return;
            }
            JList list = (JList)e.getSource();
            if (MyListKeyListener.allListElementsMatch(list, x -> x.isMarker())) {
                return;
            }
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 40: {
                    ScrollingUtil.moveDown((JList)list, (int)e.getModifiersEx());
                    break;
                }
                case 34: {
                    ScrollingUtil.movePageDown((JList)list);
                    break;
                }
                case 38: {
                    ScrollingUtil.moveUp((JList)list, (int)e.getModifiersEx());
                    break;
                }
                case 33: {
                    ScrollingUtil.movePageUp((JList)list);
                    break;
                }
                default: {
                    return;
                }
            }
            DevicePickerEntry entry = (DevicePickerEntry)list.getSelectedValue();
            while (entry.isMarker()) {
                if (keyCode == 38 || keyCode == 33) {
                    ScrollingUtil.moveUp((JList)list, (int)e.getModifiersEx());
                } else {
                    ScrollingUtil.moveDown((JList)list, (int)e.getModifiersEx());
                }
                entry = (DevicePickerEntry)list.getSelectedValue();
            }
            e.consume();
        }

        private static <E> boolean allListElementsMatch(@NotNull JList<E> list, @NotNull Predicate<E> predicate) {
            if (list == null) {
                MyListKeyListener.$$$reportNull$$$0(1);
            }
            if (predicate == null) {
                MyListKeyListener.$$$reportNull$$$0(2);
            }
            for (int i = 0; i < list.getModel().getSize(); ++i) {
                if (predicate.test(list.getModel().getElementAt(i))) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "speedSearch";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/run/editor/DevicePicker$MyListKeyListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "allListElementsMatch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

