/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidDeviceComparator;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.android.tools.idea.run.DevicePickerEntry;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import org.jetbrains.annotations.NotNull;

public class DevicePickerListModel
extends AbstractListModel<DevicePickerEntry> {
    private final ImmutableList<DevicePickerEntry> myEntries;
    private final boolean myShowSerialNumbers;
    private final int myNumConnectedDevices;

    public DevicePickerListModel() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    public DevicePickerListModel(@NotNull List<IDevice> connectedDevices, @NotNull List<AvdInfo> avds) {
        if (connectedDevices == null) {
            DevicePickerListModel.$$$reportNull$$$0(0);
        }
        if (avds == null) {
            DevicePickerListModel.$$$reportNull$$$0(1);
        }
        List<AndroidDevice> connected = DevicePickerListModel.wrapConnectedDevices(connectedDevices, avds);
        this.myEntries = DevicePickerListModel.createEntries(connected, DevicePickerListModel.getLaunchableDevices(avds, DevicePickerListModel.getRunningAvds(connectedDevices)));
        this.myNumConnectedDevices = connected.size();
        this.myShowSerialNumbers = DevicePickerListModel.shouldShowSerials(connected);
    }

    public void entryContentChanged(@NotNull DevicePickerEntry entry) {
        int index;
        if (entry == null) {
            DevicePickerListModel.$$$reportNull$$$0(2);
        }
        if ((index = this.findEntry(entry)) >= 0) {
            this.fireContentsChanged(entry, index, index);
        }
    }

    private int findEntry(DevicePickerEntry entry) {
        for (int i = 0; i < this.myEntries.size(); ++i) {
            if (!((DevicePickerEntry)this.myEntries.get(i)).equals(entry)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    private static List<AndroidDevice> wrapConnectedDevices(@NotNull List<IDevice> connectedDevices, @NotNull List<AvdInfo> avdInfos) {
        if (connectedDevices == null) {
            DevicePickerListModel.$$$reportNull$$$0(3);
        }
        if (avdInfos == null) {
            DevicePickerListModel.$$$reportNull$$$0(4);
        }
        ArrayList<AndroidDevice> devices = new ArrayList<AndroidDevice>(connectedDevices.size());
        for (IDevice device : connectedDevices) {
            devices.add(new ConnectedAndroidDevice(device, avdInfos));
        }
        ArrayList<AndroidDevice> arrayList = devices;
        if (arrayList == null) {
            DevicePickerListModel.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static List<AndroidDevice> getLaunchableDevices(@NotNull List<AvdInfo> avds, @NotNull Set<String> runningAvds) {
        if (avds == null) {
            DevicePickerListModel.$$$reportNull$$$0(6);
        }
        if (runningAvds == null) {
            DevicePickerListModel.$$$reportNull$$$0(7);
        }
        ArrayList<AndroidDevice> launchable = new ArrayList<AndroidDevice>();
        for (AvdInfo avdInfo : avds) {
            if (runningAvds.contains(avdInfo.getName())) continue;
            launchable.add(new LaunchableAndroidDevice(avdInfo));
        }
        ArrayList<AndroidDevice> arrayList = launchable;
        if (arrayList == null) {
            DevicePickerListModel.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static Set<String> getRunningAvds(@NotNull List<IDevice> connectedDevices) {
        if (connectedDevices == null) {
            DevicePickerListModel.$$$reportNull$$$0(9);
        }
        HashSet<String> runningAvdNames = new HashSet<String>();
        for (IDevice device : connectedDevices) {
            String avdName;
            if (!device.isEmulator() || (avdName = device.getAvdName()) == null) continue;
            runningAvdNames.add(avdName);
        }
        return runningAvdNames;
    }

    @NotNull
    private static ImmutableList<DevicePickerEntry> createEntries(@NotNull List<AndroidDevice> connected, @NotNull List<AndroidDevice> launchable) {
        if (connected == null) {
            DevicePickerListModel.$$$reportNull$$$0(10);
        }
        if (launchable == null) {
            DevicePickerListModel.$$$reportNull$$$0(11);
        }
        ImmutableList.Builder entries = ImmutableList.builder();
        AndroidDeviceComparator comparator = new AndroidDeviceComparator();
        Collections.sort(connected, comparator);
        Collections.sort(launchable, comparator);
        entries.add((Object)DevicePickerEntry.CONNECTED_DEVICES_MARKER);
        if (!connected.isEmpty()) {
            for (AndroidDevice device : connected) {
                entries.add((Object)DevicePickerEntry.create(device));
            }
        } else {
            entries.add((Object)DevicePickerEntry.NONE);
        }
        if (!launchable.isEmpty()) {
            entries.add((Object)DevicePickerEntry.LAUNCHABLE_DEVICES_MARKER);
            for (AndroidDevice device : launchable) {
                entries.add((Object)DevicePickerEntry.create(device));
            }
        }
        ImmutableList immutableList = entries.build();
        if (immutableList == null) {
            DevicePickerListModel.$$$reportNull$$$0(12);
        }
        return immutableList;
    }

    public int getNumberOfConnectedDevices() {
        return this.myNumConnectedDevices;
    }

    private static boolean shouldShowSerials(@NotNull List<AndroidDevice> connectedDevices) {
        if (connectedDevices == null) {
            DevicePickerListModel.$$$reportNull$$$0(13);
        }
        int numberOfPhysicalDevices = 0;
        for (AndroidDevice device : connectedDevices) {
            if (device.isVirtual()) continue;
            ++numberOfPhysicalDevices;
        }
        if (numberOfPhysicalDevices > 1) {
            HashSet<String> deviceNames = new HashSet<String>();
            for (AndroidDevice device : connectedDevices) {
                String name;
                if (device.isVirtual() || deviceNames.add(name = device.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getSize() {
        return this.myEntries.size();
    }

    @Override
    public DevicePickerEntry getElementAt(int index) {
        return (DevicePickerEntry)this.myEntries.get(index);
    }

    @NotNull
    public List<DevicePickerEntry> getItems() {
        ImmutableList<DevicePickerEntry> immutableList = this.myEntries;
        if (immutableList == null) {
            DevicePickerListModel.$$$reportNull$$$0(14);
        }
        return immutableList;
    }

    public boolean shouldShowSerialNumbers() {
        return this.myShowSerialNumbers;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectedDevices";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avds";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avdInfos";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/DevicePickerListModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runningAvds";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connected";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/DevicePickerListModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapConnectedDevices";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchableDevices";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntries";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "entryContentChanged";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wrapConnectedDevices";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 14: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLaunchableDevices";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRunningAvds";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createEntries";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowSerials";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

