/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.AndroidLogcatUtils;
import com.google.common.base.Strings;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplicationLogListener
implements AndroidLogcatService.LogcatListener {
    @Nullable
    private LogCatHeader myActiveHeader;
    @NotNull
    private final String myPackageName;
    private final int myPid;

    public ApplicationLogListener(@NotNull String packageName, int pid) {
        if (packageName == null) {
            ApplicationLogListener.$$$reportNull$$$0(0);
        }
        this.myPackageName = packageName;
        this.myPid = pid;
    }

    @Override
    public void onLogLineReceived(@NotNull LogCatMessage line) {
        String message;
        if (line == null) {
            ApplicationLogListener.$$$reportNull$$$0(1);
        }
        if (!this.myPackageName.equals(line.getHeader().getAppName()) || this.myPid != line.getHeader().getPid()) {
            this.myActiveHeader = null;
            return;
        }
        if (!line.getHeader().equals((Object)this.myActiveHeader)) {
            this.myActiveHeader = line.getHeader();
            message = this.formatLogLine(line);
        } else {
            message = Strings.repeat((String)" ", (int)this.formatLogLine(line).indexOf(line.getMessage())) + line.getMessage();
        }
        Key key = AndroidLogcatUtils.getProcessOutputType(this.myActiveHeader.getLogLevel());
        this.notifyTextAvailable(message + "\n", key);
    }

    protected abstract String formatLogLine(@NotNull LogCatMessage var1);

    protected abstract void notifyTextAvailable(@NotNull String var1, @NotNull Key var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/ApplicationLogListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onLogLineReceived";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

