/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer;

import com.android.tools.idea.editors.AndroidFakeFileSystem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.testFramework.LightVirtualFile;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceExplorerFile
extends LightVirtualFile {
    public static final String FILENAME = "Resource Editor";
    private static final Key<ResourceExplorerFile> KEY = Key.create((String)ResourceExplorerFile.class.getName());
    private static final Key<Boolean> CACHE_LOOKUP_KEY = Key.create((String)"cache_lookup_key");
    private final AndroidFacet myFacet;
    private VirtualFile myParent;
    private final String myPath;

    private ResourceExplorerFile(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ResourceExplorerFile.$$$reportNull$$$0(0);
        }
        super(FILENAME);
        this.myPath = AndroidFakeFileSystem.constructPathForFile(FILENAME, facet.getModule());
        this.myFacet = facet;
    }

    @NotNull
    public static ResourceExplorerFile getResourceEditorFile(@NotNull Project project, AndroidFacet facet) {
        ResourceExplorerFile vFile;
        if (project == null) {
            ResourceExplorerFile.$$$reportNull$$$0(1);
        }
        if ((vFile = (ResourceExplorerFile)((Object)facet.getUserData(KEY))) == null) {
            vFile = ResourceExplorerFile.getResourceEditorVirtualFileFromCache(facet);
            if (vFile == null) {
                vFile = new ResourceExplorerFile(facet);
            }
            vFile.myParent = project.getBaseDir();
            facet.putUserData(KEY, (Object)vFile);
        }
        ResourceExplorerFile resourceExplorerFile = vFile;
        if (resourceExplorerFile == null) {
            ResourceExplorerFile.$$$reportNull$$$0(2);
        }
        return resourceExplorerFile;
    }

    @Nullable
    private static ResourceExplorerFile getResourceEditorVirtualFileFromCache(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ResourceExplorerFile.$$$reportNull$$$0(3);
        }
        if (facet.getUserData(CACHE_LOOKUP_KEY) == null) {
            facet.putUserData(CACHE_LOOKUP_KEY, true);
            String url = AndroidFakeFileSystem.INSTANCE.getProtocol() + "://" + AndroidFakeFileSystem.constructPathForFile(FILENAME, facet.getModule());
            VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(url, (Disposable)facet, null);
            return (ResourceExplorerFile)pointer.getFile();
        }
        return null;
    }

    @Nullable
    public VirtualFile getParent() {
        return this.myParent;
    }

    @NotNull
    public FileType getFileType() {
        ResourceEditorFileType resourceEditorFileType = ResourceEditorFileType.INSTANCE;
        if (resourceEditorFileType == null) {
            ResourceExplorerFile.$$$reportNull$$$0(4);
        }
        return resourceEditorFileType;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = AndroidFakeFileSystem.INSTANCE;
        if (virtualFileSystem == null) {
            ResourceExplorerFile.$$$reportNull$$$0(5);
        }
        return virtualFileSystem;
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            ResourceExplorerFile.$$$reportNull$$$0(6);
        }
        return androidFacet;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            ResourceExplorerFile.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/resourceExplorer/ResourceExplorerFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/resourceExplorer/ResourceExplorerFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceEditorFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getResourceEditorFile";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResourceEditorVirtualFileFromCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ResourceEditorFileType
    extends FakeFileType {
        public static final ResourceEditorFileType INSTANCE = new ResourceEditorFileType();

        private ResourceEditorFileType() {
        }

        public boolean isMyFileType(@NotNull VirtualFile file) {
            if (file == null) {
                ResourceEditorFileType.$$$reportNull$$$0(0);
            }
            return file.getFileType() instanceof ResourceEditorFileType;
        }

        @NotNull
        public String getName() {
            if ("" == null) {
                ResourceEditorFileType.$$$reportNull$$$0(1);
            }
            return "";
        }

        @NotNull
        public String getDescription() {
            if ("" == null) {
                ResourceEditorFileType.$$$reportNull$$$0(2);
            }
            return "";
        }

        public Icon getIcon() {
            return StudioIcons.NewResourceFile.VERSION;
        }

        public boolean isBinary() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/resourceExplorer/ResourceExplorerFile$ResourceEditorFileType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/resourceExplorer/ResourceExplorerFile$ResourceEditorFileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isMyFileType";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

