/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.tools.idea.rendering.LayoutMetadata;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutFilePullParser
extends KXmlParser
implements ILayoutPullParser {
    private final LayoutlibCallback myLayoutlibCallback;
    private String myFragmentLayout = null;

    public static LayoutFilePullParser create(@NotNull LayoutlibCallback layoutlibCallback, @NotNull File xml) throws XmlPullParserException, IOException {
        if (layoutlibCallback == null) {
            LayoutFilePullParser.$$$reportNull$$$0(0);
        }
        if (xml == null) {
            LayoutFilePullParser.$$$reportNull$$$0(1);
        }
        String xmlText = Files.toString((File)xml, (Charset)Charsets.UTF_8);
        return LayoutFilePullParser.create(layoutlibCallback, xmlText);
    }

    @NotNull
    public static LayoutFilePullParser create(@NotNull LayoutlibCallback layoutlibCallback, @NotNull String xmlText) throws XmlPullParserException {
        if (layoutlibCallback == null) {
            LayoutFilePullParser.$$$reportNull$$$0(2);
        }
        if (xmlText == null) {
            LayoutFilePullParser.$$$reportNull$$$0(3);
        }
        LayoutFilePullParser parser = new LayoutFilePullParser(layoutlibCallback);
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        parser.setInput(new StringReader(xmlText));
        LayoutFilePullParser layoutFilePullParser = parser;
        if (layoutFilePullParser == null) {
            LayoutFilePullParser.$$$reportNull$$$0(4);
        }
        return layoutFilePullParser;
    }

    private LayoutFilePullParser(LayoutlibCallback layoutlibCallback) {
        this.myLayoutlibCallback = layoutlibCallback;
    }

    @Deprecated
    public ILayoutPullParser getParser(String layoutName) {
        return this.myLayoutlibCallback.getParser(layoutName);
    }

    @Nullable
    public Object getViewCookie() {
        String name = super.getName();
        if (name == null) {
            return null;
        }
        if ("ListView".equals(name) || "ExpandableListView".equals(name) || "GridView".equals(name) || "Spinner".equals(name)) {
            HashMap map = null;
            int count = this.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                String attribute;
                String namespace = this.getAttributeNamespace(i);
                if (namespace == null || !namespace.equals("http://schemas.android.com/tools") || (attribute = this.getAttributeName(i)).equals("ignore")) continue;
                if (map == null) {
                    map = Maps.newHashMapWithExpectedSize((int)4);
                }
                map.put(attribute, this.getAttributeValue(i));
            }
            return map;
        }
        return null;
    }

    public String getName() {
        String name = super.getName();
        if ("fragment".equals(name)) {
            this.myFragmentLayout = LayoutMetadata.getProperty((XmlPullParser)this, "layout");
            if (this.myFragmentLayout != null) {
                return "include";
            }
        } else {
            this.myFragmentLayout = null;
        }
        return name;
    }

    @Nullable
    public String getAttributeValue(String namespace, String localName) {
        if ("layout".equals(localName) && this.myFragmentLayout != null) {
            return this.myFragmentLayout;
        }
        String value = super.getAttributeValue(namespace, localName);
        if ("match_parent".equals(value) && ("layout_width".equals(localName) || "layout_height".equals(localName)) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
            return "fill_parent";
        }
        if (namespace != null) {
            if (namespace.equals("http://schemas.android.com/apk/res/android")) {
                String designValue = super.getAttributeValue("http://schemas.android.com/tools", localName);
                if (designValue != null) {
                    value = value != null && designValue.isEmpty() ? null : designValue;
                }
            } else if (value == null) {
                value = super.getAttributeValue("http://schemas.android.com/apk/res-auto", localName);
            }
        }
        if (value != null) {
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                char c = value.charAt(i);
                if (c != '&' && c != '\\') continue;
                value = ValueXmlHelper.unescapeResourceString((String)value, (boolean)true, (boolean)false);
                break;
            }
        }
        return value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutlibCallback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/LayoutFilePullParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/LayoutFilePullParser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

