/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project.messages;

import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueEvent;
import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueFileEvent;
import com.android.tools.idea.gradle.project.sync.idea.IdeaGradleSync;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.ui.QuickFixNotificationListener;
import com.android.tools.idea.util.PositionInFile;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSyncMessages
implements Disposable {
    private static final NotificationSource NOTIFICATION_SOURCE = NotificationSource.PROJECT_SYNC;
    private Project myProject;
    @NotNull
    private final List<AndroidSyncIssueEvent> myCurrentEvents;

    protected AbstractSyncMessages(@NotNull Project project) {
        if (project == null) {
            AbstractSyncMessages.$$$reportNull$$$0(0);
        }
        this.myCurrentEvents = new ArrayList<AndroidSyncIssueEvent>();
        this.myProject = project;
        this.myCurrentEvents.clear();
    }

    public int getErrorCount() {
        int total = 0;
        for (AndroidSyncIssueEvent event : this.myCurrentEvents) {
            if (event.getKind() != MessageEvent.Kind.ERROR) continue;
            ++total;
        }
        return total;
    }

    public int getMessageCount(@NotNull String groupName) {
        if (groupName == null) {
            AbstractSyncMessages.$$$reportNull$$$0(1);
        }
        int total = 0;
        for (AndroidSyncIssueEvent event : this.myCurrentEvents) {
            if (event.getGroup() != groupName) continue;
            ++total;
        }
        return total;
    }

    public boolean isEmpty() {
        return this.myCurrentEvents.isEmpty();
    }

    public void removeAllMessages() {
        this.clearEvents();
    }

    public void removeMessages(String ... groupNames) {
        if (groupNames == null) {
            AbstractSyncMessages.$$$reportNull$$$0(2);
        }
        HashSet<String> groupSet = new HashSet<String>(Arrays.asList(groupNames));
        this.myCurrentEvents.removeIf(event -> groupSet.contains(event.getGroup()));
    }

    public void report(@NotNull SyncMessage message) {
        if (message == null) {
            AbstractSyncMessages.$$$reportNull$$$0(3);
        }
        String title = message.getGroup();
        String text = StringUtil.join((String[])message.getText(), (String)"\n");
        NotificationCategory category = message.getType().convertToCategory();
        PositionInFile position = message.getPosition();
        NotificationData notification = this.createNotification(title, text, category, position);
        Navigatable navigatable = message.getNavigatable();
        notification.setNavigatable(navigatable);
        List<NotificationHyperlink> quickFixes = message.getQuickFixes();
        if (!quickFixes.isEmpty()) {
            this.updateNotification(notification, text, quickFixes);
        }
        this.report(notification);
    }

    @NotNull
    public NotificationData createNotification(@NotNull String title, @NotNull String text, @NotNull NotificationCategory category, @Nullable PositionInFile position) {
        if (title == null) {
            AbstractSyncMessages.$$$reportNull$$$0(4);
        }
        if (text == null) {
            AbstractSyncMessages.$$$reportNull$$$0(5);
        }
        if (category == null) {
            AbstractSyncMessages.$$$reportNull$$$0(6);
        }
        NotificationSource source = NotificationSource.PROJECT_SYNC;
        if (position != null) {
            String filePath = VfsUtilCore.virtualToIoFile((VirtualFile)position.file).getPath();
            NotificationData notificationData = new NotificationData(title, text, category, source, filePath, position.line, position.column, false);
            if (notificationData == null) {
                AbstractSyncMessages.$$$reportNull$$$0(7);
            }
            return notificationData;
        }
        NotificationData notificationData = new NotificationData(title, text, category, source);
        if (notificationData == null) {
            AbstractSyncMessages.$$$reportNull$$$0(8);
        }
        return notificationData;
    }

    public void updateNotification(@NotNull NotificationData notification, @NotNull String text, @NotNull List<NotificationHyperlink> quickFixes) {
        if (notification == null) {
            AbstractSyncMessages.$$$reportNull$$$0(9);
        }
        if (text == null) {
            AbstractSyncMessages.$$$reportNull$$$0(10);
        }
        if (quickFixes == null) {
            AbstractSyncMessages.$$$reportNull$$$0(11);
        }
        String message = text;
        int hyperlinkCount = quickFixes.size();
        if (hyperlinkCount > 0) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < hyperlinkCount; ++i) {
                b.append(quickFixes.get(i).toHtml());
                if (i >= hyperlinkCount - 1) continue;
                b.append("<br>");
            }
            message = message + '\n' + b.toString();
        }
        notification.setMessage(message);
        this.addNotificationListener(notification, quickFixes);
    }

    public void addNotificationListener(@NotNull NotificationData notification, @NotNull List<NotificationHyperlink> quickFixes) {
        if (notification == null) {
            AbstractSyncMessages.$$$reportNull$$$0(12);
        }
        if (quickFixes == null) {
            AbstractSyncMessages.$$$reportNull$$$0(13);
        }
        for (NotificationHyperlink quickFix : quickFixes) {
            notification.setListener(quickFix.getUrl(), (NotificationListener)new QuickFixNotificationListener(this.myProject, quickFix));
        }
    }

    public void report(@NotNull NotificationData notificationData) {
        ExternalSystemTaskId id;
        if (notificationData == null) {
            AbstractSyncMessages.$$$reportNull$$$0(14);
        }
        if ((id = (ExternalSystemTaskId)this.myProject.getUserData(IdeaGradleSync.LAST_SYNC_TASK_ID_KEY)) != null) {
            String title = notificationData.getTitle();
            String[] lines = notificationData.getMessage().split(SystemProperties.getLineSeparator());
            if (lines.length > 0) {
                title = lines[0];
            }
            AndroidSyncIssueEvent issueEvent = notificationData.getFilePath() != null ? new AndroidSyncIssueFileEvent(id, notificationData, title) : new AndroidSyncIssueEvent(id, notificationData, title);
            this.myCurrentEvents.add(issueEvent);
            ((SyncViewManager)ServiceManager.getService((Project)this.myProject, SyncViewManager.class)).onEvent((BuildEvent)issueEvent);
        }
    }

    @NotNull
    protected abstract ProjectSystemId getProjectSystemId();

    @NotNull
    protected Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractSyncMessages.$$$reportNull$$$0(15);
        }
        return project;
    }

    @NotNull
    public List<AndroidSyncIssueEvent> getEvents() {
        List<AndroidSyncIssueEvent> list = this.myCurrentEvents;
        if (list == null) {
            AbstractSyncMessages.$$$reportNull$$$0(16);
        }
        return list;
    }

    protected void clearEvents() {
        this.myCurrentEvents.clear();
    }

    public void dispose() {
        this.myProject = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 7: 
            case 8: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/project/messages/AbstractSyncMessages";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/project/messages/AbstractSyncMessages";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMessageCount";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeMessages";
                break;
            }
            case 3: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 7: 
            case 8: 
            case 15: 
            case 16: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateNotification";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addNotificationListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

