/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.datastore.DataStoreService;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.perfd.PerfdProxy;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.profiler.proto.Agent;
import com.google.common.base.Charsets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.net.NetUtils;
import io.grpc.ManagedChannel;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.internal.ManagedChannelImpl;
import io.grpc.netty.NettyChannelBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.download.AndroidProfilerDownloader;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

class StudioProfilerDeviceManager
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener,
IdeSdks.IdeSdkChangeListener {
    private static int LIVE_ALLOCATION_STACK_DEPTH = Integer.getInteger("profiler.alloc.stack.depth", 50);
    private static final String BOOT_COMPLETE_PROPERTY = "dev.bootcomplete";
    private static final String BOOT_COMPLETE_MESSAGE = "1";
    private static final int MAX_MESSAGE_SIZE = 0x1FFFFFFF;
    private static final int DEVICE_PORT = 12389;
    private static final String DEVICE_SOCKET_NAME = "AndroidStudioProfiler";
    private static final String AGENT_CONFIG_FILE = "agent.config";
    @NotNull
    private final DataStoreService myDataStoreService;
    private boolean isAdbInitialized;
    private Map<IDevice, PerfdProxy> myDeviceProxies;

    private static Logger getLogger() {
        return Logger.getInstance(StudioProfilerDeviceManager.class);
    }

    StudioProfilerDeviceManager(@NotNull DataStoreService dataStoreService) {
        if (dataStoreService == null) {
            StudioProfilerDeviceManager.$$$reportNull$$$0(0);
        }
        this.myDataStoreService = dataStoreService;
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.isAdbInitialized = false;
        this.myDeviceProxies = new HashMap<IDevice, PerfdProxy>();
    }

    @Override
    public void sdkPathChanged(@NotNull File newSdkPath) {
        if (newSdkPath == null) {
            StudioProfilerDeviceManager.$$$reportNull$$$0(1);
        }
        this.isAdbInitialized = false;
    }

    public void initialize(@NotNull Project project) {
        if (project == null) {
            StudioProfilerDeviceManager.$$$reportNull$$$0(2);
        }
        if (this.isAdbInitialized) {
            return;
        }
        final File adb = AndroidSdkUtils.getAdb(project);
        if (adb != null) {
            Futures.addCallback(AdbService.getInstance().getDebugBridge(adb), (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

                public void onSuccess(AndroidDebugBridge result) {
                    StudioProfilerDeviceManager.this.isAdbInitialized = true;
                }

                public void onFailure(Throwable t) {
                    StudioProfilerDeviceManager.getLogger().warn(String.format("getDebugBridge %s failed", adb.getAbsolutePath()));
                }
            }, (Executor)EdtExecutor.INSTANCE);
        } else {
            StudioProfilerDeviceManager.getLogger().warn("No adb available");
        }
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        if (bridge != null) {
            for (IDevice device : bridge.getDevices()) {
                this.deviceConnected(device);
            }
        } else {
            for (PerfdProxy proxy : this.myDeviceProxies.values()) {
                proxy.disconnect();
            }
        }
    }

    public void deviceConnected(IDevice device) {
        if (device.isOnline()) {
            this.spawnPerfd(device);
        }
    }

    public void deviceDisconnected(IDevice device) {
    }

    public void deviceChanged(IDevice device, int changeMask) {
        if ((changeMask & 1) != 0 && device.isOnline()) {
            this.spawnPerfd(device);
        }
    }

    private void spawnPerfd(IDevice device) {
        PerfdThread thread = new PerfdThread(device, this.myDataStoreService);
        thread.start();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStoreService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSdkPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/profilers/StudioProfilerDeviceManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "sdkPathChanged";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initialize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ChmodOutputListener
    implements IShellOutputReceiver {
        private static final String BAD_MODE = "Bad mode";
        private boolean myHasErrors;

        private ChmodOutputListener() {
        }

        public void addOutput(byte[] data, int offset, int length) {
            String s = new String(data, Charsets.UTF_8);
            this.myHasErrors = s.contains(BAD_MODE);
        }

        public void flush() {
        }

        public boolean isCancelled() {
            return false;
        }

        private boolean hasErrors() {
            return this.myHasErrors;
        }
    }

    private class PerfdThread
    extends Thread {
        private final DataStoreService myDataStore;
        private final IDevice myDevice;
        private int myLocalPort;
        private PerfdProxy myPerfdProxy;

        PerfdThread(@NotNull IDevice device, DataStoreService datastore) {
            if (device == null) {
                PerfdThread.$$$reportNull$$$0(0);
            }
            if (datastore == null) {
                PerfdThread.$$$reportNull$$$0(1);
            }
            super("Perfd Thread: " + device.getSerialNumber());
            this.myDataStore = datastore;
            this.myDevice = device;
            this.myLocalPort = 0;
        }

        @Override
        public void run() {
            if (!AndroidProfilerDownloader.makeSureProfilerIsInPlace()) {
                return;
            }
            try {
                if (!this.waitForBootComplete()) {
                    throw new TimeoutException("Timed out waiting for device to be ready.");
                }
                String deviceDir = "/data/local/tmp/perfd/";
                this.copyFileToDevice("perfd", "plugins/android/resources/perfd", "../../bazel-bin/tools/base/profiler/native/perfd/android", deviceDir, true);
                if (this.isAtLeastO(this.myDevice)) {
                    if (((Boolean)StudioFlags.PROFILER_USE_JVMTI.get()).booleanValue()) {
                        String productionRoot = "plugins/android/resources";
                        String devRoot = "../../bazel-genfiles/tools/base/profiler/app";
                        this.copyFileToDevice("perfa.jar", productionRoot, devRoot, deviceDir, false);
                        this.copyFileToDevice("perfa_okhttp.dex", productionRoot, devRoot, deviceDir, false);
                        this.pushJvmtiAgentNativeLibraries(deviceDir);
                    }
                    if (((Boolean)StudioFlags.PROFILER_USE_SIMPLEPERF.get()).booleanValue()) {
                        this.pushSimpleperfIfSupported(deviceDir);
                    }
                }
                this.pushAgentConfig(StudioProfilerDeviceManager.AGENT_CONFIG_FILE, deviceDir);
                this.myDevice.executeShellCommand(deviceDir + "perfd -config_file=" + deviceDir + StudioProfilerDeviceManager.AGENT_CONFIG_FILE, new IShellOutputReceiver(){

                    public void addOutput(byte[] data, int offset, int length) {
                        String s = new String(data, offset, length, Charsets.UTF_8);
                        StudioProfilerDeviceManager.getLogger().info("[perfd]: " + s);
                        if (StudioProfilerDeviceManager.this.myDeviceProxies.containsKey(PerfdThread.this.myDevice)) {
                            StudioProfilerDeviceManager.getLogger().info(String.format("PerfdProxy was already created for device: %s", PerfdThread.this.myDevice));
                            return;
                        }
                        if (PerfdThread.this.myDevice.getVersion().getApiLevel() >= 21 && !s.startsWith("Server listening on")) {
                            return;
                        }
                        PerfdThread.this.createPerfdProxy();
                        StudioProfilerDeviceManager.getLogger().info(String.format("PerfdProxy successfully created for device: %s", PerfdThread.this.myDevice));
                    }

                    public void flush() {
                    }

                    public boolean isCancelled() {
                        return false;
                    }
                }, 0L, null);
                StudioProfilerDeviceManager.getLogger().info("Terminating perfd thread");
            }
            catch (ShellCommandUnresponsiveException | SyncException | TimeoutException | InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (AdbCommandRejectedException | IOException e) {
                StudioProfilerDeviceManager.getLogger().warn("Error when trying to spawn perfd:");
                StudioProfilerDeviceManager.getLogger().warn(e);
            }
        }

        private void copyFileToDevice(String fileName, String hostReleaseDir, String hostDevDir, String deviceDir, boolean executable) throws AdbCommandRejectedException, IOException {
            File dir = new File(PathManager.getHomePath(), hostReleaseDir);
            if (!dir.exists() && !(dir = new File(PathManager.getHomePath(), hostDevDir)).exists()) {
                dir = AndroidProfilerDownloader.getHostDir(hostReleaseDir);
            }
            File file = null;
            if (executable) {
                for (String abi : this.myDevice.getAbis()) {
                    File candidate = new File(dir, abi + "/" + fileName);
                    if (!candidate.exists()) continue;
                    file = candidate;
                    break;
                }
            } else {
                File candidate = new File(dir, fileName);
                if (candidate.exists()) {
                    file = candidate;
                }
            }
            this.pushFileToDevice(file, fileName, deviceDir, executable);
        }

        private void pushFileToDevice(File file, String fileName, String deviceDir, boolean executable) throws AdbCommandRejectedException, IOException {
            try {
                if (file == null) {
                    throw new RuntimeException(String.format("File %s could not be found for device: %s", fileName, this.myDevice));
                }
                StudioProfilerDeviceManager.getLogger().info(String.format("Pushing %s to %s...", fileName, deviceDir));
                this.myDevice.executeShellCommand("rm -f " + deviceDir + fileName, (IShellOutputReceiver)new NullOutputReceiver());
                this.myDevice.executeShellCommand("mkdir -p " + deviceDir, (IShellOutputReceiver)new NullOutputReceiver());
                this.myDevice.pushFile(file.getAbsolutePath(), deviceDir + fileName);
                if (executable) {
                    ChmodOutputListener chmodListener = new ChmodOutputListener();
                    this.myDevice.executeShellCommand("chmod +x " + deviceDir + fileName, (IShellOutputReceiver)chmodListener);
                    if (chmodListener.hasErrors()) {
                        this.myDevice.executeShellCommand("chmod 777 " + deviceDir + fileName, (IShellOutputReceiver)new NullOutputReceiver());
                    }
                }
                StudioProfilerDeviceManager.getLogger().info(String.format("Successfully pushed %s to %s.", fileName, deviceDir));
            }
            catch (ShellCommandUnresponsiveException | SyncException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        }

        private void pushJvmtiAgentNativeLibraries(String devicePath) throws AdbCommandRejectedException, IOException {
            String jvmtiResourcesReleasePath = "plugins/android/resources/perfa";
            String jvmtiResourcesDevPath = "../../bazel-bin/tools/base/profiler/native/perfa/android";
            String libperfaFilename = "libperfa.so";
            String libperfaDeviceFilenameFormat = "libperfa_%s.so";
            this.pushAbiDependentBinaryFiles(devicePath, jvmtiResourcesReleasePath, jvmtiResourcesDevPath, libperfaFilename, libperfaDeviceFilenameFormat);
        }

        private void pushAbiDependentBinaryFiles(String devicePath, String hostReleaseDir, String hostDevDir, String hostFilename, String deviceFilenameFormat) throws AdbCommandRejectedException, IOException {
            File dir = new File(PathManager.getHomePath(), hostReleaseDir);
            if (!dir.exists()) {
                dir = new File(PathManager.getHomePath(), hostDevDir);
            }
            HashSet<String> cpuArchSet = new HashSet<String>();
            for (String abi : this.myDevice.getAbis()) {
                String abiCpuArch;
                File candidate = new File(dir, abi + "/" + hostFilename);
                if (!candidate.exists() || cpuArchSet.contains(abiCpuArch = Abi.getEnum((String)abi).getCpuArch())) continue;
                this.pushFileToDevice(candidate, String.format(deviceFilenameFormat, abiCpuArch), devicePath, true);
                cpuArchSet.add(abiCpuArch);
            }
        }

        private void pushSimpleperfIfSupported(String devicePath) throws AdbCommandRejectedException, IOException {
            String simpleperfBinariesReleasePath = "plugins/android/resources/simpleperf";
            String simpleperfBinariesDevPath = "../../prebuilts/tools/common/simpleperf";
            String simpleperfFilename = "simpleperf";
            String simpleperfDeviceFilenameFormat = "simpleperf_%s";
            this.pushAbiDependentBinaryFiles(devicePath, simpleperfBinariesReleasePath, simpleperfBinariesDevPath, simpleperfFilename, simpleperfDeviceFilenameFormat);
        }

        private void pushAgentConfig(@NotNull String fileName, @NotNull String devicePath) throws AdbCommandRejectedException, IOException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
            if (fileName == null) {
                PerfdThread.$$$reportNull$$$0(2);
            }
            if (devicePath == null) {
                PerfdThread.$$$reportNull$$$0(3);
            }
            Agent.SocketType socketType = (Boolean)StudioFlags.PROFILER_USE_JVMTI.get() != false && this.isAtLeastO(this.myDevice) ? Agent.SocketType.ABSTRACT_SOCKET : Agent.SocketType.UNSPECIFIED_SOCKET;
            Agent.AgentConfig agentConfig = Agent.AgentConfig.newBuilder().setUseJvmti(((Boolean)StudioFlags.PROFILER_USE_JVMTI.get()).booleanValue()).setMemConfig(Agent.AgentConfig.MemoryConfig.newBuilder().setUseLiveAlloc(((Boolean)StudioFlags.PROFILER_USE_LIVE_ALLOCATIONS.get()).booleanValue()).setMaxStackDepth(LIVE_ALLOCATION_STACK_DEPTH).setTrackGlobalJniRefs(((Boolean)StudioFlags.PROFILER_TRACK_JNI_REFS.get()).booleanValue()).build()).setProfilerNetworkRequestPayload(((Boolean)StudioFlags.PROFILER_NETWORK_REQUEST_PAYLOAD.get()).booleanValue()).setSocketType(socketType).setServiceAddress("127.0.0.1:12389").setServiceSocketName("@AndroidStudioProfiler").build();
            File configFile = FileUtil.createTempFile((String)fileName, null, (boolean)true);
            FileOutputStream oStream = new FileOutputStream(configFile);
            agentConfig.writeTo((OutputStream)oStream);
            this.myDevice.executeShellCommand("rm -f " + devicePath + fileName, (IShellOutputReceiver)new NullOutputReceiver());
            this.myDevice.pushFile(configFile.getAbsolutePath(), devicePath + fileName);
        }

        private void createPerfdProxy() {
            try {
                this.myLocalPort = NetUtils.findAvailableSocketPort();
                if (this.myLocalPort < 0) {
                    throw new RuntimeException("Unable to find available socket port");
                }
                if (this.isAtLeastO(this.myDevice) && ((Boolean)StudioFlags.PROFILER_USE_JVMTI.get()).booleanValue()) {
                    this.myDevice.createForward(this.myLocalPort, StudioProfilerDeviceManager.DEVICE_SOCKET_NAME, IDevice.DeviceUnixSocketNamespace.ABSTRACT);
                } else {
                    this.myDevice.createForward(this.myLocalPort, 12389);
                }
                StudioProfilerDeviceManager.getLogger().info(String.format("Port forwarding created for port: %d", this.myLocalPort));
                ClassLoader stashedContextClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(NettyChannelBuilder.class.getClassLoader());
                ManagedChannelImpl perfdChannel = NettyChannelBuilder.forAddress((String)"localhost", (int)this.myLocalPort).usePlaintext(true).maxMessageSize(0x1FFFFFFF).build();
                Thread.currentThread().setContextClassLoader(stashedContextClassLoader);
                String channelName = this.myDevice.getSerialNumber();
                this.myPerfdProxy = new PerfdProxy(this.myDevice, (ManagedChannel)perfdChannel, channelName);
                this.myPerfdProxy.connect();
                StudioProfilerDeviceManager.this.myDeviceProxies.put(this.myDevice, this.myPerfdProxy);
                this.myPerfdProxy.setOnDisconnectCallback(() -> {
                    if (StudioProfilerDeviceManager.this.myDeviceProxies.containsKey(this.myDevice)) {
                        StudioProfilerDeviceManager.this.myDeviceProxies.remove(this.myDevice);
                    }
                });
                ManagedChannelImpl proxyChannel = InProcessChannelBuilder.forName((String)channelName).build();
                this.myDataStore.connect((ManagedChannel)proxyChannel);
            }
            catch (AdbCommandRejectedException | TimeoutException | IOException e) {
                if (this.myPerfdProxy != null) {
                    this.myPerfdProxy.disconnect();
                }
                throw new RuntimeException(e);
            }
        }

        private boolean isAtLeastO(IDevice device) {
            return device.getVersion().getFeatureLevel() >= 26;
        }

        private boolean waitForBootComplete() throws InterruptedException {
            for (int i = 0; i < 60; ++i) {
                String state = this.myDevice.getProperty(StudioProfilerDeviceManager.BOOT_COMPLETE_PROPERTY);
                if (StudioProfilerDeviceManager.BOOT_COMPLETE_MESSAGE.equals(state)) {
                    return true;
                }
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "datastore";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "devicePath";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/profilers/StudioProfilerDeviceManager$PerfdThread";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pushAgentConfig";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

