/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.diagnostics.exception.NoPiiException;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.IntellijProfilerPreferences;
import com.android.tools.idea.profilers.TemporaryProfilerPreferences;
import com.android.tools.idea.profilers.analytics.StudioFeatureTracker;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilingConfigService;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilingConfigurationsDialog;
import com.android.tools.idea.profilers.stacktrace.IntellijCodeNavigator;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.profilers.FeatureConfig;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerPreferences;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.CpuProfilerConfigModel;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijProfilerServices
implements IdeProfilerServices {
    private final IntellijCodeNavigator myCodeNavigator;
    private final StudioFeatureTracker myFeatureTracker;
    @NotNull
    private final Project myProject;
    @NotNull
    private final IntellijProfilerPreferences myPersistentPreferences;
    @NotNull
    private final TemporaryProfilerPreferences myTemporaryPreferences;

    private static Logger getLogger() {
        return Logger.getInstance(IntellijProfilerServices.class);
    }

    public IntellijProfilerServices(@NotNull Project project) {
        if (project == null) {
            IntellijProfilerServices.$$$reportNull$$$0(0);
        }
        this.myFeatureTracker = new StudioFeatureTracker();
        this.myProject = project;
        this.myCodeNavigator = new IntellijCodeNavigator(project, this.myFeatureTracker);
        this.myPersistentPreferences = new IntellijProfilerPreferences();
        this.myTemporaryPreferences = new TemporaryProfilerPreferences();
    }

    @NotNull
    public Executor getMainExecutor() {
        Executor executor = arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0);
        if (executor == null) {
            IntellijProfilerServices.$$$reportNull$$$0(1);
        }
        return executor;
    }

    @NotNull
    public Executor getPoolExecutor() {
        Executor executor = arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0);
        if (executor == null) {
            IntellijProfilerServices.$$$reportNull$$$0(2);
        }
        return executor;
    }

    public void saveFile(@NotNull File file, @NotNull Consumer<FileOutputStream> fileOutputStreamConsumer, @Nullable Runnable postRunnable) {
        File parentDir;
        if (file == null) {
            IntellijProfilerServices.$$$reportNull$$$0(3);
        }
        if (fileOutputStreamConsumer == null) {
            IntellijProfilerServices.$$$reportNull$$$0(4);
        }
        if (!(parentDir = file.getParentFile()).exists()) {
            parentDir.mkdirs();
        }
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    IntellijProfilerServices.getLogger().error("Could not create new file at: " + file.getPath());
                    return;
                }
            }
            catch (IOException e) {
                IntellijProfilerServices.getLogger().error((Throwable)e);
            }
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            fileOutputStreamConsumer.accept(fos);
        }
        catch (IOException e) {
            IntellijProfilerServices.getLogger().error((Throwable)e);
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        if (virtualFile != null) {
            virtualFile.refresh(true, false, postRunnable);
        }
    }

    @NotNull
    public CodeNavigator getCodeNavigator() {
        IntellijCodeNavigator intellijCodeNavigator = this.myCodeNavigator;
        if (intellijCodeNavigator == null) {
            IntellijProfilerServices.$$$reportNull$$$0(5);
        }
        return intellijCodeNavigator;
    }

    @NotNull
    public FeatureTracker getFeatureTracker() {
        StudioFeatureTracker studioFeatureTracker = this.myFeatureTracker;
        if (studioFeatureTracker == null) {
            IntellijProfilerServices.$$$reportNull$$$0(6);
        }
        return studioFeatureTracker;
    }

    public void enableAdvancedProfiling() {
        RunnerAndConfigurationSettings configurationSettings;
        AndroidRunConfigurationBase androidConfiguration = null;
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        if (runManager != null && (configurationSettings = runManager.getSelectedConfiguration()) != null && configurationSettings.getConfiguration() instanceof AndroidRunConfigurationBase) {
            androidConfiguration = (AndroidRunConfigurationBase)configurationSettings.getConfiguration();
            androidConfiguration.getProfilerState().setCheckAdvancedProfiling(true);
        }
        EditConfigurationsDialog dialog = new EditConfigurationsDialog(this.myProject);
        dialog.show();
        if (androidConfiguration != null) {
            androidConfiguration.getProfilerState().setCheckAdvancedProfiling(false);
        }
    }

    @NotNull
    public FeatureConfig getFeatureConfig() {
        FeatureConfig featureConfig = new FeatureConfig(){

            public boolean isAtraceEnabled() {
                return (Boolean)StudioFlags.PROFILER_USE_ATRACE.get();
            }

            public boolean isCpuCaptureFilterEnabled() {
                return (Boolean)StudioFlags.PROFILER_CPU_CAPTURE_FILTER.get();
            }

            public boolean isEnergyProfilerEnabled() {
                return (Boolean)StudioFlags.PROFILER_ENERGY_PROFILER_ENABLED.get();
            }

            public boolean isJniReferenceTrackingEnabled() {
                return (Boolean)StudioFlags.PROFILER_TRACK_JNI_REFS.get();
            }

            public boolean isJvmtiAgentEnabled() {
                return (Boolean)StudioFlags.PROFILER_USE_JVMTI.get();
            }

            public boolean isLiveAllocationsEnabled() {
                return (Boolean)StudioFlags.PROFILER_USE_JVMTI.get() != false && (Boolean)StudioFlags.PROFILER_USE_LIVE_ALLOCATIONS.get() != false;
            }

            public boolean isMemoryCaptureFilterEnabled() {
                return (Boolean)StudioFlags.PROFILER_MEMORY_CAPTURE_FILTER.get();
            }

            public boolean isMemorySnapshotEnabled() {
                return (Boolean)StudioFlags.PROFILER_MEMORY_SNAPSHOT.get();
            }

            public boolean isNetworkRequestPayloadEnabled() {
                return (Boolean)StudioFlags.PROFILER_NETWORK_REQUEST_PAYLOAD.get();
            }

            public boolean isNetworkThreadViewEnabled() {
                return (Boolean)StudioFlags.PROFILER_SHOW_THREADS_VIEW.get();
            }

            public boolean isSimplePerfEnabled() {
                return (Boolean)StudioFlags.PROFILER_USE_SIMPLEPERF.get();
            }
        };
        if (featureConfig == null) {
            IntellijProfilerServices.$$$reportNull$$$0(7);
        }
        return featureConfig;
    }

    @NotNull
    public ProfilerPreferences getTemporaryProfilerPreferences() {
        TemporaryProfilerPreferences temporaryProfilerPreferences = this.myTemporaryPreferences;
        if (temporaryProfilerPreferences == null) {
            IntellijProfilerServices.$$$reportNull$$$0(8);
        }
        return temporaryProfilerPreferences;
    }

    @NotNull
    public ProfilerPreferences getPersistentProfilerPreferences() {
        IntellijProfilerPreferences intellijProfilerPreferences = this.myPersistentPreferences;
        if (intellijProfilerPreferences == null) {
            IntellijProfilerServices.$$$reportNull$$$0(9);
        }
        return intellijProfilerPreferences;
    }

    public void openCpuProfilingConfigurationsDialog(CpuProfilerConfigModel model, int deviceLevel, Consumer<ProfilingConfiguration> dialogCallback) {
        CpuProfilingConfigurationsDialog dialog = new CpuProfilingConfigurationsDialog(this.myProject, deviceLevel, model, dialogCallback, this.myFeatureTracker);
        dialog.show();
    }

    public void openParseLargeTracesDialog(Runnable yesCallback, Runnable noCallback) {
        int dialogResult = Messages.showYesNoDialog((Project)this.myProject, (String)"The trace file generated is large, and Android Studio may become unresponsive while it parses the data. Do you want to continue?\n\nWarning: If you select \"No\", Android Studio discards the trace data and you will need to capture a new method trace.", (String)"Trace File Too Large", (Icon)Messages.getWarningIcon());
        if (dialogResult == 0) {
            yesCallback.run();
        } else {
            noCallback.run();
        }
    }

    public List<ProfilingConfiguration> getCpuProfilingConfigurations() {
        return CpuProfilingConfigService.getInstance(this.myProject).getConfigurations();
    }

    public boolean isNativeProfilingConfigurationPreferred() {
        ImmutableList nativeExtensions = ImmutableList.of((Object)"c", (Object)"cc", (Object)"cpp", (Object)"cxx", (Object)"c++", (Object)"h", (Object)"hh", (Object)"hpp", (Object)"hxx", (Object)"h++");
        return Arrays.stream(FileEditorManager.getInstance((Project)this.myProject).getSelectedFiles()).anyMatch(file -> {
            String extension = file.getExtension();
            return extension != null && nativeExtensions.contains((Object)extension.toLowerCase());
        });
    }

    public void showErrorBalloon(@NotNull String title, @NotNull String text) {
        if (title == null) {
            IntellijProfilerServices.$$$reportNull$$$0(10);
        }
        if (text == null) {
            IntellijProfilerServices.$$$reportNull$$$0(11);
        }
        AndroidNotification.getInstance(this.myProject).showBalloon(title, text, NotificationType.ERROR);
    }

    public void reportNoPiiException(@NotNull Throwable ex) {
        if (ex == null) {
            IntellijProfilerServices.$$$reportNull$$$0(12);
        }
        IntellijProfilerServices.getLogger().error((Throwable)new NoPiiException(ex));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/IntellijProfilerServices";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOutputStreamConsumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/IntellijProfilerServices";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainExecutor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPoolExecutor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeNavigator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureTracker";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureConfig";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemporaryProfilerPreferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistentProfilerPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showErrorBalloon";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reportNoPiiException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

