/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory;
import com.android.tools.idea.profilers.IntellijProfilerComponents;
import com.android.tools.idea.profilers.IntellijProfilerServices;
import com.android.tools.idea.profilers.ProfilerService;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.ProfilerLayeredPane;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProfilerToolWindow
extends AspectObserver
implements Disposable {
    @NotNull
    private final StudioProfilersView myView;
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProfilerLayeredPane myLayeredPane;

    public AndroidProfilerToolWindow(@NotNull Project project) {
        if (project == null) {
            AndroidProfilerToolWindow.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        ProfilerService service = ProfilerService.getInstance(this.myProject);
        ProfilerClient client = service.getProfilerClient();
        this.myProfilers = new StudioProfilers(client, (IdeProfilerServices)new IntellijProfilerServices(this.myProject));
        this.myView = new StudioProfilersView(this.myProfilers, (IdeProfilerComponents)new IntellijProfilerComponents(this.myProject));
        this.myLayeredPane = new ProfilerLayeredPane();
        service.getDataStoreService().setNoPiiExceptionHanlder(arg_0 -> ((IdeProfilerServices)this.myProfilers.getIdeServices()).reportNoPiiException(arg_0));
        this.initializeUi();
        this.myProfilers.addDependency((AspectObserver)this).onChange((Enum)ProfilerAspect.MODE, this::updateToolWindow).onChange((Enum)ProfilerAspect.STAGE, this::updateToolWindow);
    }

    private void initializeUi() {
        final JPanel content = this.myView.getComponent();
        this.myLayeredPane.add((Component)content, (Object)JLayeredPane.DEFAULT_LAYER);
        this.myLayeredPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                content.setBounds(0, 0, AndroidProfilerToolWindow.this.myLayeredPane.getWidth(), AndroidProfilerToolWindow.this.myLayeredPane.getHeight());
                content.revalidate();
                content.repaint();
            }
        });
    }

    public void profileProject(@NotNull Project project) {
        if (project == null) {
            AndroidProfilerToolWindow.$$$reportNull$$$0(1);
        }
        this.myProfilers.setPreferredProcessName(this.getPreferredProcessName(project));
    }

    public void updateToolWindow() {
        boolean maximize;
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow window = manager.getToolWindow("Android Profiler");
        boolean bl = maximize = this.myProfilers.getMode() == ProfilerMode.EXPANDED;
        if (maximize != manager.isMaximized(window)) {
            manager.setMaximized(window, maximize);
        }
        if (this.myProfilers.isStopped()) {
            AndroidProfilerToolWindowFactory.removeContent(this.myProject, window);
        }
    }

    public void dispose() {
        this.myProfilers.removeDependencies((AspectObserver)this);
        this.myProfilers.stop();
    }

    public JComponent getComponent() {
        return this.myLayeredPane;
    }

    @Nullable
    private String getPreferredProcessName(Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            String pkg;
            AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(module);
            if (moduleInfo == null || (pkg = moduleInfo.getPackage()) == null) continue;
            return pkg;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/android/tools/idea/profilers/AndroidProfilerToolWindow";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "profileProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

