/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.resources.Density;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.LauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.NotificationIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureIconPanel;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureIconView;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureLauncherIconPanel;
import com.android.tools.idea.npw.assetstudio.ui.PreviewIconsPanel;
import com.android.tools.idea.npw.assetstudio.wizard.CheckeredBackgroundPanel;
import com.android.tools.idea.npw.assetstudio.wizard.IconGenerationProcessor;
import com.android.tools.idea.npw.assetstudio.wizard.ImagePreviewPanel;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentStateUtil;
import com.android.tools.idea.npw.assetstudio.wizard.WrappedFlowLayout;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.projectsystem.AndroidModuleTemplate;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GenerateImageAssetPanel
extends JPanel
implements Disposable,
PersistentStateComponent<PersistentState> {
    private static final String OUTPUT_ICON_TYPE_PROPERTY = "outputIconType";
    @NotNull
    private final AndroidModuleTemplate myDefaultPaths;
    private final ValidatorPanel myValidatorPanel;
    @NotNull
    private final BindingsManager myBindings;
    @NotNull
    private final ListenerManager myListeners;
    private final Map<AndroidIconType, PreviewIconsPanel> myOutputPreviewPanels;
    private final ObjectProperty<AndroidIconType> myOutputIconType;
    private final StringProperty myOutputName;
    private JPanel myRootPanel;
    private JComboBox<AndroidIconType> myIconTypeCombo;
    private JPanel myConfigureIconPanels;
    private Map<AndroidIconType, ConfigureIconView> myConfigureIconViews;
    private CheckeredBackgroundPanel myOutputPreviewPanel;
    private TitledSeparator myOutputPreviewLabel;
    private JBScrollPane myOutputPreviewScrollPane;
    private JSplitPane mySplitPane;
    private JCheckBox myShowGrid;
    private JCheckBox myShowSafeZone;
    private JComboBox<Density> myPreviewResolutionComboBox;
    private JPanel myPreviewPanel;
    private JPanel myIconTypePanel;
    private JPanel myPreviewTitlePanel;
    private JPanel myPreviewContentsPanel;
    private JPanel myOutputIconTypePanel;
    private SelectedProperty myShowGridProperty;
    private SelectedProperty myShowSafeZoneProperty;
    private AbstractProperty<Density> myPreviewDensityProperty;
    private JBLoadingPanel myLoadingPanel;
    @NotNull
    private AndroidModuleTemplate myPaths;
    @NotNull
    private final IconGenerationProcessor myIconGenerationProcessor;

    public GenerateImageAssetPanel(@NotNull Disposable disposableParent, @NotNull AndroidFacet facet, @NotNull AndroidModuleTemplate defaultPaths, AndroidIconType ... supportedTypes) {
        if (disposableParent == null) {
            GenerateImageAssetPanel.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            GenerateImageAssetPanel.$$$reportNull$$$0(1);
        }
        if (defaultPaths == null) {
            GenerateImageAssetPanel.$$$reportNull$$$0(2);
        }
        if (supportedTypes == null) {
            GenerateImageAssetPanel.$$$reportNull$$$0(3);
        }
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myOutputName = new StringValueProperty();
        this.myConfigureIconViews = new TreeMap<AndroidIconType, ConfigureIconView>();
        this.myIconGenerationProcessor = new IconGenerationProcessor();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), panel -> new LoadingDecorator((JComponent)panel, this, -1){

            protected NonOpaquePanel customizeLoadingLayer(JPanel parent, JLabel text, AsyncProcessIcon icon) {
                NonOpaquePanel panel = super.customizeLoadingLayer(parent, text, icon);
                Font font = text.getFont();
                text.setFont(font.deriveFont(font.getStyle(), font.getSize() + 6));
                text.setForeground(ColorUtil.toAlpha((Color)Color.BLACK, (int)100));
                panel.setOpaque(true);
                return panel;
            }
        });
        this.myLoadingPanel.add((Component)this.myOutputPreviewPanel);
        this.myOutputPreviewScrollPane.getViewport().setView((Component)this.myLoadingPanel);
        this.myLoadingPanel.setLoadingText("Rendering preview images");
        this.myLoadingPanel.startLoading();
        this.myPaths = this.myDefaultPaths = defaultPaths;
        if (supportedTypes.length == 0) {
            supportedTypes = AndroidIconType.values();
        }
        DefaultComboBoxModel<AndroidIconType> supportedTypesModel = new DefaultComboBoxModel<AndroidIconType>(supportedTypes);
        this.myIconTypeCombo.setModel(supportedTypesModel);
        this.myIconTypeCombo.setVisible(supportedTypes.length > 1);
        this.myOutputIconType = ObjectProperty.wrap(new SelectedItemProperty(this.myIconTypeCombo));
        this.myOutputPreviewPanel.setName("PreviewIconsPanel");
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myRootPanel);
        this.myPreviewResolutionComboBox.setRenderer((ListCellRenderer<Density>)new ListCellRendererWrapper<Density>(){

            public void customize(JList list, Density value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value.getResourceValue());
                }
            }
        });
        DefaultComboBoxModel<Density> densitiesModel = new DefaultComboBoxModel<Density>();
        densitiesModel.addElement(Density.MEDIUM);
        densitiesModel.addElement(Density.HIGH);
        densitiesModel.addElement(Density.XHIGH);
        densitiesModel.addElement(Density.XXHIGH);
        densitiesModel.addElement(Density.XXXHIGH);
        this.myPreviewResolutionComboBox.setModel(densitiesModel);
        this.myPreviewDensityProperty = ObjectProperty.wrap(new SelectedItemProperty(this.myPreviewResolutionComboBox));
        this.myShowGridProperty = new SelectedProperty(this.myShowGrid);
        this.myShowSafeZoneProperty = new SelectedProperty(this.myShowSafeZone);
        AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance(facet);
        int minSdkVersion2 = androidModuleInfo.getMinSdkVersion().getApiLevel();
        assert (this.myConfigureIconPanels.getLayout() instanceof CardLayout);
        for (AndroidIconType iconType : supportedTypes) {
            JPanel view;
            switch (iconType) {
                case LAUNCHER: {
                    view = new ConfigureLauncherIconPanel(this, facet, this.myShowGridProperty, this.myShowSafeZoneProperty, this.myPreviewDensityProperty, this.myValidatorPanel);
                    break;
                }
                case LAUNCHER_LEGACY: 
                case ACTIONBAR: 
                case NOTIFICATION: {
                    view = new ConfigureIconPanel(this, iconType, minSdkVersion2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid icon type");
                }
            }
            this.myConfigureIconViews.put(iconType, (ConfigureIconView)((Object)view));
            this.myConfigureIconPanels.add((Component)view.getRootComponent(), iconType.toString());
        }
        ImmutableMap.Builder previewPanelBuilder = ImmutableMap.builder();
        previewPanelBuilder.put((Object)AndroidIconType.LAUNCHER, (Object)new LauncherIconsPreviewPanel());
        previewPanelBuilder.put((Object)AndroidIconType.LAUNCHER_LEGACY, (Object)new LauncherLegacyIconsPreviewPanel());
        previewPanelBuilder.put((Object)AndroidIconType.ACTIONBAR, (Object)new ActionBarIconsPreviewPanel());
        previewPanelBuilder.put((Object)AndroidIconType.NOTIFICATION, (Object)new NotificationIconsPreviewPanel());
        this.myOutputPreviewPanels = previewPanelBuilder.build();
        WrappedFlowLayout previewLayout = new WrappedFlowLayout(3);
        previewLayout.setAlignOnBaseline(true);
        this.myOutputPreviewPanel.setLayout(previewLayout);
        this.myOutputPreviewScrollPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                GenerateImageAssetPanel.this.myOutputPreviewPanel.revalidate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/npw/assetstudio/wizard/GenerateImageAssetPanel$3", "componentResized"));
            }
        });
        this.mySplitPane.setDividerLocation(this.mySplitPane.getLeftComponent().getPreferredSize().width);
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.mySplitPane);
        this.initializeListenersAndBindings();
        this.initializeValidators();
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myValidatorPanel);
        this.add((Component)this.myValidatorPanel);
    }

    private void initializeListenersAndBindings() {
        ActionListener onAssetModified = actionEvent -> this.renderIconPreviews();
        for (ConfigureIconView view : this.myConfigureIconViews.values()) {
            view.addAssetListener(onAssetModified);
        }
        Runnable updatePreview = () -> {
            ConfigureIconView iconView = this.getActiveIconView();
            this.myBindings.bind(this.myOutputName, iconView.outputName());
            if (this.myOutputIconType.get() == AndroidIconType.NOTIFICATION) {
                this.myOutputPreviewLabel.setText("Preview (API 11+)");
            } else {
                this.myOutputPreviewLabel.setText("Preview");
            }
            this.renderIconPreviews();
        };
        this.myListeners.receiveAndFire(this.myOutputIconType, iconType -> {
            ((CardLayout)this.myConfigureIconPanels.getLayout()).show(this.myConfigureIconPanels, iconType.toString());
            updatePreview.run();
        });
        this.myListeners.receiveAndFire(this.myShowGridProperty, selected -> updatePreview.run());
        this.myListeners.receiveAndFire(this.myShowSafeZoneProperty, selected -> updatePreview.run());
        this.myListeners.receiveAndFire(this.myPreviewDensityProperty, value -> updatePreview.run());
        BooleanExpression isAdaptiveIconOutput = BooleanExpression.create(() -> this.myOutputIconType.get() == AndroidIconType.LAUNCHER, this.myOutputIconType);
        this.myBindings.bind(new VisibleProperty(this.myShowGrid), isAdaptiveIconOutput);
        this.myBindings.bind(new VisibleProperty(this.myShowSafeZone), isAdaptiveIconOutput);
        this.myBindings.bind(new VisibleProperty(this.myPreviewResolutionComboBox), isAdaptiveIconOutput);
    }

    private void updateOutputPreviewPanel() {
        this.myOutputPreviewPanel.removeAll();
        PreviewIconsPanel iconsPanel = this.myOutputPreviewPanels.get(this.myOutputIconType.get());
        for (PreviewIconsPanel.IconPreviewInfo previewInfo : iconsPanel.getIconPreviewInfos()) {
            ImagePreviewPanel previewPanel = new ImagePreviewPanel();
            previewPanel.getComponent().setName("IconPanel");
            previewPanel.setLabelText(previewInfo.getLabel());
            previewPanel.setImage(previewInfo.getImage());
            previewPanel.setImageBackground(previewInfo.getImageBackground());
            previewPanel.setImageOpaque(previewInfo.isImageOpaque());
            if (this.myOutputIconType.get() != AndroidIconType.LAUNCHER) {
                previewPanel.setImageBorder(previewInfo.getImageBorder());
            }
            this.myOutputPreviewPanel.add(previewPanel.getComponent());
        }
        this.myOutputPreviewPanel.revalidate();
        this.myOutputPreviewPanel.repaint();
    }

    @NotNull
    private ConfigureIconView getActiveIconView() {
        for (ConfigureIconView view : this.myConfigureIconViews.values()) {
            if (!view.getRootComponent().isVisible()) continue;
            ConfigureIconView configureIconView = view;
            if (configureIconView == null) {
                GenerateImageAssetPanel.$$$reportNull$$$0(4);
            }
            return configureIconView;
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " is configured incorrectly. Please report this error.");
    }

    private void initializeValidators() {
        this.myValidatorPanel.registerValidator((ObservableValue)this.myOutputName, outputName -> {
            String trimmedName = outputName.trim();
            if (trimmedName.isEmpty()) {
                return new Validator.Result(Validator.Severity.ERROR, "Icon name must be set");
            }
            if (this.iconExists()) {
                return new Validator.Result(Validator.Severity.WARNING, "An icon with the same name already exists and will be overwritten.");
            }
            return Validator.Result.OK;
        });
    }

    public void setProjectPaths(@Nullable AndroidModuleTemplate projectPaths) {
        this.myPaths = projectPaths != null ? projectPaths : this.myDefaultPaths;
    }

    public void setOutputName(@NotNull String name) {
        if (name == null) {
            GenerateImageAssetPanel.$$$reportNull$$$0(5);
        }
        this.getActiveIconView().outputName().set(name);
    }

    @NotNull
    public IconGenerator getIconGenerator() {
        IconGenerator iconGenerator = this.getActiveIconView().getIconGenerator();
        if (iconGenerator == null) {
            GenerateImageAssetPanel.$$$reportNull$$$0(6);
        }
        return iconGenerator;
    }

    @NotNull
    public ObservableBool hasErrors() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors();
        if (observableBool == null) {
            GenerateImageAssetPanel.$$$reportNull$$$0(7);
        }
        return observableBool;
    }

    private boolean iconExists() {
        Map<File, GeneratedIcon> pathImageMap = this.getIconGenerator().generateIconPlaceholders(this.myPaths);
        for (File path : pathImageMap.keySet()) {
            if (!path.exists()) continue;
            return true;
        }
        return false;
    }

    private void renderIconPreviews() {
        GenerateImageAssetPanel.invokeVeryLate(this::enqueueGenerateNotificationIcons, ModalityState.any(), o -> Disposer.isDisposed((Disposable)this));
    }

    private void enqueueGenerateNotificationIcons() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        AndroidIconType iconType = (AndroidIconType)((Object)this.myOutputIconType.get());
        IconGenerator iconGenerator = this.getActiveIconView().getIconGenerator();
        this.myIconGenerationProcessor.enqueue(iconType, iconGenerator, iconGeneratorResult -> {
            if (iconGeneratorResult == null) {
                return;
            }
            this.myLoadingPanel.stopLoading();
            this.myOutputPreviewPanels.get((Object)iconType).showPreviewImages((IconGeneratorResult)iconGeneratorResult);
            if (Objects.equals((Object)iconType, this.myOutputIconType.get())) {
                this.updateOutputPreviewPanel();
            }
        });
    }

    private static void invokeVeryLate(@NotNull Runnable runnable, @NotNull ModalityState state, @NotNull Condition expired) {
        if (runnable == null) {
            GenerateImageAssetPanel.$$$reportNull$$$0(8);
        }
        if (state == null) {
            GenerateImageAssetPanel.$$$reportNull$$$0(9);
        }
        if (expired == null) {
            GenerateImageAssetPanel.$$$reportNull$$$0(10);
        }
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            if (runnable == null) {
                GenerateImageAssetPanel.$$$reportNull$$$0(14);
            }
            if (state == null) {
                GenerateImageAssetPanel.$$$reportNull$$$0(15);
            }
            if (expired == null) {
                GenerateImageAssetPanel.$$$reportNull$$$0(16);
            }
            application.invokeLater(runnable, state, expired);
        }, state, expired);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state = new PersistentState();
        state.set(OUTPUT_ICON_TYPE_PROPERTY, (Enum)this.myOutputIconType.get(), AndroidIconType.LAUNCHER);
        for (Map.Entry<AndroidIconType, ConfigureIconView> entry : this.myConfigureIconViews.entrySet()) {
            state.setChild(AssetStudioUtils.toLowerCamelCase(entry.getKey()), (PersistentState)entry.getValue().getState());
        }
        PersistentState persistentState = state;
        if (persistentState == null) {
            GenerateImageAssetPanel.$$$reportNull$$$0(11);
        }
        return persistentState;
    }

    public void loadState(@NotNull PersistentState state) {
        if (state == null) {
            GenerateImageAssetPanel.$$$reportNull$$$0(12);
        }
        this.myOutputIconType.set(state.get(OUTPUT_ICON_TYPE_PROPERTY, AndroidIconType.LAUNCHER));
        ApplicationManager.getApplication().invokeLater(() -> {
            if (state == null) {
                GenerateImageAssetPanel.$$$reportNull$$$0(13);
            }
            for (Map.Entry<AndroidIconType, ConfigureIconView> entry : this.myConfigureIconViews.entrySet()) {
                PersistentStateUtil.load((PersistentStateComponent<PersistentState>)((PersistentStateComponent)entry.getValue()), state.getChild(AssetStudioUtils.toLowerCamelCase(entry.getKey())));
            }
        }, ModalityState.any());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedTypes";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/wizard/GenerateImageAssetPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/wizard/GenerateImageAssetPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveIconView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconGenerator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "hasErrors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setOutputName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invokeVeryLate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadState$12";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invokeVeryLate$11";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        CheckeredBackgroundPanel checkeredBackgroundPanel;
        JBScrollPane jBScrollPane;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        TitledSeparator titledSeparator;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JSplitPane jSplitPane;
        JPanel jPanel7;
        this.myRootPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerSize(10);
        ((Component)jSplitPane).setEnabled(true);
        jPanel7.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myIconTypePanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel6);
        this.myOutputIconTypePanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 1, 1, 1, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Icon Type:");
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(60, -1), null, null));
        JComboBox jComboBox = new JComboBox();
        this.myIconTypeCombo = jComboBox;
        jPanel5.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myConfigureIconPanels = jPanel4 = new JPanel();
        jPanel4.setLayout(new CardLayout(0, 0));
        jPanel6.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 3, new Dimension(350, -1), null, null));
        this.myPreviewPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 2, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel3);
        this.myPreviewTitlePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 2, 1, 3, 0, null, null, null));
        this.myOutputPreviewLabel = titledSeparator = new TitledSeparator();
        titledSeparator.setText("Preview");
        jPanel2.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myShowGrid = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Show Grid");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShowSafeZone = jCheckBox = new JCheckBox();
        jCheckBox.setText("Show Safe Zone");
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myPreviewResolutionComboBox = jComboBox2;
        jPanel2.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPreviewContentsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myOutputPreviewScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOutputPreviewPanel = checkeredBackgroundPanel = new CheckeredBackgroundPanel();
        jBScrollPane.setViewportView(checkeredBackgroundPanel);
        jBLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static class NotificationIconsPreviewPanel
    extends PreviewIconsPanel {
        NotificationIconsPreviewPanel() {
            super("", PreviewIconsPanel.Theme.DARK, new CategoryIconMap.NotificationFilter(NotificationIconGenerator.Version.V11));
        }

        @Override
        public void showPreviewImages(@NotNull IconGeneratorResult iconGeneratorResult) {
            if (iconGeneratorResult == null) {
                NotificationIconsPreviewPanel.$$$reportNull$$$0(0);
            }
            Collection<GeneratedIcon> generatedIcons = iconGeneratorResult.getIcons();
            List list = generatedIcons.stream().filter(x -> x instanceof GeneratedImageIcon).map(x -> (GeneratedImageIcon)x).filter(x -> x.getCategory() == IconCategory.NOTIFICATION_V11 || x.getCategory() == IconCategory.NONE).map(x -> Pair.of((Object)x.getDensity(), (Object)x.getImage())).collect(Collectors.toList());
            this.showPreviewImagesWithDensity(list.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconGeneratorResult", "com/android/tools/idea/npw/assetstudio/wizard/GenerateImageAssetPanel$NotificationIconsPreviewPanel", "showPreviewImages"));
        }
    }

    private static class ActionBarIconsPreviewPanel
    extends PreviewIconsPanel {
        ActionBarIconsPreviewPanel() {
            super("", PreviewIconsPanel.Theme.TRANSPARENT);
        }
    }

    private static class LauncherLegacyIconsPreviewPanel
    extends PreviewIconsPanel {
        LauncherLegacyIconsPreviewPanel() {
            super("", PreviewIconsPanel.Theme.TRANSPARENT);
        }

        @Override
        public void showPreviewImages(@NotNull IconGeneratorResult iconGeneratorResult) {
            if (iconGeneratorResult == null) {
                LauncherLegacyIconsPreviewPanel.$$$reportNull$$$0(0);
            }
            Collection<GeneratedIcon> generatedIcons = iconGeneratorResult.getIcons();
            List list = generatedIcons.stream().filter(icon -> icon instanceof GeneratedImageIcon).map(icon -> (GeneratedImageIcon)icon).filter(icon -> icon.getDensity() != Density.NODPI).map(icon -> Pair.of((Object)icon.getDensity(), (Object)icon.getImage())).collect(Collectors.toList());
            this.showPreviewImagesWithDensity(list.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconGeneratorResult", "com/android/tools/idea/npw/assetstudio/wizard/GenerateImageAssetPanel$LauncherLegacyIconsPreviewPanel", "showPreviewImages"));
        }
    }

    private static class LauncherIconsPreviewPanel
    extends PreviewIconsPanel {
        LauncherIconsPreviewPanel() {
            super("", PreviewIconsPanel.Theme.TRANSPARENT);
        }

        @Override
        public void showPreviewImages(@NotNull IconGeneratorResult result) {
            if (result == null) {
                LauncherIconsPreviewPanel.$$$reportNull$$$0(0);
            }
            Collection<GeneratedIcon> generatedIcons = result.getIcons();
            List<Pair<String, BufferedImage>> list = generatedIcons.stream().filter(icon -> icon instanceof GeneratedImageIcon).map(icon -> (GeneratedImageIcon)icon).filter(icon -> {
                if (result == null) {
                    LauncherIconsPreviewPanel.$$$reportNull$$$0(9);
                }
                return this.filterPreviewIcon((GeneratedImageIcon)icon, ((LauncherIconGenerator.LauncherIconOptions)result.getOptions()).previewDensity);
            }).map(pair -> Pair.of((Object)((Object)LauncherIconsPreviewPanel.getPreviewShapeFromId(pair.getName())), (Object)pair.getImage())).sorted((pair1, pair2) -> LauncherIconsPreviewPanel.comparePreviewShapes((LauncherIconGenerator.PreviewShape)((Object)((Object)pair1.getFirst())), (LauncherIconGenerator.PreviewShape)((Object)((Object)pair2.getFirst())))).map(pair -> Pair.of((Object)((LauncherIconGenerator.PreviewShape)((Object)((Object)pair.getFirst()))).displayName, (Object)pair.getSecond())).collect(Collectors.toList());
            this.showPreviewImagesImpl(list);
        }

        protected boolean filterPreviewIcon(@NotNull GeneratedImageIcon icon, @NotNull Density density) {
            if (icon == null) {
                LauncherIconsPreviewPanel.$$$reportNull$$$0(1);
            }
            if (density == null) {
                LauncherIconsPreviewPanel.$$$reportNull$$$0(2);
            }
            return Objects.equals((Object)IconCategory.PREVIEW, (Object)icon.getCategory()) && Objects.equals(icon.getDensity(), density);
        }

        private static int comparePreviewShapes(@NotNull LauncherIconGenerator.PreviewShape x, @NotNull LauncherIconGenerator.PreviewShape y) {
            if (x == null) {
                LauncherIconsPreviewPanel.$$$reportNull$$$0(3);
            }
            if (y == null) {
                LauncherIconsPreviewPanel.$$$reportNull$$$0(4);
            }
            return Integer.compare(LauncherIconsPreviewPanel.getPreviewShapeDisplayOrder(x), LauncherIconsPreviewPanel.getPreviewShapeDisplayOrder(y));
        }

        private static int getPreviewShapeDisplayOrder(@NotNull LauncherIconGenerator.PreviewShape previewShape) {
            if (previewShape == null) {
                LauncherIconsPreviewPanel.$$$reportNull$$$0(5);
            }
            switch (previewShape) {
                case CIRCLE: {
                    return 1;
                }
                case SQUIRCLE: {
                    return 2;
                }
                case ROUNDED_SQUARE: {
                    return 3;
                }
                case SQUARE: {
                    return 4;
                }
                case FULL_BLEED: {
                    return 5;
                }
                case LEGACY: {
                    return 6;
                }
                case LEGACY_ROUND: {
                    return 7;
                }
                case WEB: {
                    return 8;
                }
            }
            return 1000;
        }

        @NotNull
        private static LauncherIconGenerator.PreviewShape getPreviewShapeFromId(@NotNull String previewShapeId) {
            if (previewShapeId == null) {
                LauncherIconsPreviewPanel.$$$reportNull$$$0(6);
            }
            for (LauncherIconGenerator.PreviewShape shape : LauncherIconGenerator.PreviewShape.values()) {
                if (!Objects.equals(shape.id, previewShapeId)) continue;
                LauncherIconGenerator.PreviewShape previewShape = shape;
                if (previewShape == null) {
                    LauncherIconsPreviewPanel.$$$reportNull$$$0(7);
                }
                return previewShape;
            }
            LauncherIconGenerator.PreviewShape previewShape = LauncherIconGenerator.PreviewShape.SQUARE;
            if (previewShape == null) {
                LauncherIconsPreviewPanel.$$$reportNull$$$0(8);
            }
            return previewShape;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "density";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "x";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "y";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewShape";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewShapeId";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/assetstudio/wizard/GenerateImageAssetPanel$LauncherIconsPreviewPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/assetstudio/wizard/GenerateImageAssetPanel$LauncherIconsPreviewPanel";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreviewShapeFromId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "showPreviewImages";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "filterPreviewIcon";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "comparePreviewShapes";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getPreviewShapeDisplayOrder";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getPreviewShapeFromId";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$showPreviewImages$2";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

