/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.sdklib.devices.Device;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import icons.AndroidIcons;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum FormFactor {
    MOBILE("Mobile", "Phone and Tablet", 15, 14, 27, Lists.newArrayList((Object[])new Integer[]{20}), Lists.newArrayList((Object[])new IdDisplay[]{SystemImage.DEFAULT_TAG, SystemImage.GOOGLE_APIS_TAG, SystemImage.GOOGLE_APIS_X86_TAG}), null, AndroidIcons.FormFactors.Mobile_64, AndroidIcons.FormFactors.Mobile_128),
    WEAR("Wear", "Wear", 21, 20, 23, null, Lists.newArrayList((Object[])new IdDisplay[]{SystemImage.WEAR_TAG}), null, AndroidIcons.FormFactors.Wear_64, AndroidIcons.FormFactors.Wear_128),
    TV("TV", "TV", 21, 21, 24, null, Lists.newArrayList((Object[])new IdDisplay[]{SystemImage.TV_TAG}), null, AndroidIcons.FormFactors.Tv_64, AndroidIcons.FormFactors.Tv_128),
    CAR("Car", "Android Auto", 21, 21, 21, null, null, MOBILE, AndroidIcons.FormFactors.Car_64, AndroidIcons.FormFactors.Car_128),
    THINGS("Things", "Android Things", 24, 24, 27, null, null, null, AndroidIcons.FormFactors.Things_64, AndroidIcons.FormFactors.Things_128),
    GLASS("Glass", "Glass", 19, -1, -1, null, Lists.newArrayList((Object[])new IdDisplay[]{SystemImage.GLASS_TAG}), null, AndroidIcons.FormFactors.Glass_64, AndroidIcons.FormFactors.Glass_128);

    private static final Map<String, FormFactor> myFormFactors;
    public final String id;
    @Nullable
    private String myDisplayName;
    public final int defaultApi;
    @NotNull
    private final List<Integer> myApiBlacklist;
    @NotNull
    private final List<IdDisplay> myTags;
    private final int myMinOfflineApiLevel;
    private final int myMaxOfflineApiLevel;
    @Nullable
    public final FormFactor baseFormFactor;
    @NotNull
    private final Icon myIcon64;
    @NotNull
    private final Icon myIcon128;

    private FormFactor(String id, String displayName, int defaultApi, @Nullable int minOfflineApiLevel, @Nullable int maxOfflineApiLevel, @Nullable List<Integer> apiBlacklist, @NotNull List<IdDisplay> apiTags, @NotNull FormFactor baseFormFactor, Icon icon64, Icon icon128) {
        if (id == null) {
            FormFactor.$$$reportNull$$$0(0);
        }
        if (icon64 == null) {
            FormFactor.$$$reportNull$$$0(1);
        }
        if (icon128 == null) {
            FormFactor.$$$reportNull$$$0(2);
        }
        this.id = id;
        this.myDisplayName = displayName;
        this.defaultApi = defaultApi;
        this.myMinOfflineApiLevel = minOfflineApiLevel;
        this.myIcon64 = icon64;
        this.myIcon128 = icon128;
        this.myMaxOfflineApiLevel = Math.min(maxOfflineApiLevel, 26);
        this.myApiBlacklist = apiBlacklist != null ? apiBlacklist : Collections.emptyList();
        this.myTags = apiTags != null ? apiTags : Collections.emptyList();
        this.baseFormFactor = baseFormFactor;
    }

    @NotNull
    public static FormFactor get(@NotNull String id) {
        FormFactor result;
        if (id == null) {
            FormFactor.$$$reportNull$$$0(3);
        }
        FormFactor formFactor = (result = myFormFactors.get(id)) == null ? MOBILE : result;
        if (formFactor == null) {
            FormFactor.$$$reportNull$$$0(4);
        }
        return formFactor;
    }

    @NotNull
    public static FormFactor getFormFactor(@NotNull Device device) {
        if (device == null) {
            FormFactor.$$$reportNull$$$0(5);
        }
        if (HardwareConfigHelper.isWear((Device)device)) {
            FormFactor formFactor = WEAR;
            if (formFactor == null) {
                FormFactor.$$$reportNull$$$0(6);
            }
            return formFactor;
        }
        if (HardwareConfigHelper.isTv((Device)device)) {
            FormFactor formFactor = TV;
            if (formFactor == null) {
                FormFactor.$$$reportNull$$$0(7);
            }
            return formFactor;
        }
        if (HardwareConfigHelper.isThings((Device)device)) {
            FormFactor formFactor = THINGS;
            if (formFactor == null) {
                FormFactor.$$$reportNull$$$0(8);
            }
            return formFactor;
        }
        FormFactor formFactor = MOBILE;
        if (formFactor == null) {
            FormFactor.$$$reportNull$$$0(9);
        }
        return formFactor;
    }

    public String toString() {
        return this.myDisplayName == null ? this.id : this.myDisplayName;
    }

    public int getMinOfflineApiLevel() {
        return this.myMinOfflineApiLevel;
    }

    public int getMaxOfflineApiLevel() {
        return this.myMaxOfflineApiLevel;
    }

    @NotNull
    public Icon getLargeIcon() {
        Icon icon = this.myIcon128;
        if (icon == null) {
            FormFactor.$$$reportNull$$$0(10);
        }
        return icon;
    }

    public boolean hasEmulator() {
        return this != GLASS;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myIcon64;
        if (icon == null) {
            FormFactor.$$$reportNull$$$0(11);
        }
        return icon;
    }

    public boolean isSupported(@Nullable IdDisplay tag, int targetSdkLevel) {
        if (!this.myTags.isEmpty() && !this.myTags.contains(tag)) {
            return false;
        }
        return !this.myApiBlacklist.contains(targetSdkLevel);
    }

    static {
        myFormFactors = new ImmutableMap.Builder().put((Object)FormFactor.MOBILE.id, (Object)MOBILE).put((Object)FormFactor.WEAR.id, (Object)WEAR).put((Object)FormFactor.TV.id, (Object)TV).put((Object)FormFactor.CAR.id, (Object)CAR).put((Object)FormFactor.THINGS.id, (Object)THINGS).put((Object)FormFactor.GLASS.id, (Object)GLASS).build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon64";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon128";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/FormFactor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/FormFactor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormFactor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLargeIcon";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFormFactor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

