/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.common.property.inspector.InspectorComponent;
import com.android.tools.idea.common.property.inspector.InspectorPanel;
import com.android.tools.idea.common.property.inspector.InspectorProvider;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.property.NavPropertiesManager;
import com.android.tools.idea.naveditor.surface.NavDesignSurface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NavPropertiesInspectorProvider
implements InspectorProvider<NavPropertiesManager> {
    private final Map<String, InspectorComponent<NavPropertiesManager>> myInspectors;
    private final Map<String, String> myPropertyNameUiNameMap;
    private final String myTitle;

    protected NavPropertiesInspectorProvider(@NotNull Map<String, String> uiNamePropertyNameMap, @Nullable String title) {
        if (uiNamePropertyNameMap == null) {
            NavPropertiesInspectorProvider.$$$reportNull$$$0(0);
        }
        this.myInspectors = new HashMap<String, InspectorComponent<NavPropertiesManager>>();
        this.myPropertyNameUiNameMap = uiNamePropertyNameMap;
        this.myTitle = title;
    }

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NavPropertiesManager propertiesManager) {
        if (components == null) {
            NavPropertiesInspectorProvider.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            NavPropertiesInspectorProvider.$$$reportNull$$$0(2);
        }
        if (propertiesManager == null) {
            NavPropertiesInspectorProvider.$$$reportNull$$$0(3);
        }
        if (components.isEmpty()) {
            return false;
        }
        String tagName = components.get(0).getTag().getName();
        if (properties.keySet().stream().noneMatch(name -> this.myPropertyNameUiNameMap.containsKey(name))) {
            return false;
        }
        if (this.myInspectors.containsKey(tagName)) {
            return true;
        }
        this.myInspectors.put(tagName, new NavigationInspectorComponent(properties, propertiesManager, this.myPropertyNameUiNameMap, this.myTitle));
        return true;
    }

    @Override
    @NotNull
    public InspectorComponent<NavPropertiesManager> createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NavPropertiesManager propertiesManager) {
        if (components == null) {
            NavPropertiesInspectorProvider.$$$reportNull$$$0(4);
        }
        if (properties == null) {
            NavPropertiesInspectorProvider.$$$reportNull$$$0(5);
        }
        if (propertiesManager == null) {
            NavPropertiesInspectorProvider.$$$reportNull$$$0(6);
        }
        String tagName = components.get(0).getTagName();
        InspectorComponent<NavPropertiesManager> inspector = this.myInspectors.get(tagName);
        assert (inspector != null);
        inspector.updateProperties(components, properties, propertiesManager);
        InspectorComponent<NavPropertiesManager> inspectorComponent = inspector;
        if (inspectorComponent == null) {
            NavPropertiesInspectorProvider.$$$reportNull$$$0(7);
        }
        return inspectorComponent;
    }

    @Override
    public void resetCache() {
        this.myInspectors.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiNamePropertyNameMap";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/property/inspector/NavPropertiesInspectorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/property/inspector/NavPropertiesInspectorProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomInspector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCustomInspector";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NavigationInspectorComponent
    implements InspectorComponent<NavPropertiesManager> {
        private final List<NlComponentEditor> myEditors;
        private final Map<String, String> myPropertyNameUiNameMap;
        private final String myTitle;

        NavigationInspectorComponent(@NotNull Map<String, NlProperty> properties, @NotNull NavPropertiesManager propertiesManager, Map<String, String> propertyNameUiNameMap, String title) {
            if (properties == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(0);
            }
            if (propertiesManager == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(1);
            }
            this.myEditors = new ArrayList<NlComponentEditor>(propertyNameUiNameMap.size());
            this.myPropertyNameUiNameMap = propertyNameUiNameMap;
            this.myTitle = title;
            this.createEditors(properties, propertiesManager);
        }

        private void createEditors(@NotNull Map<String, NlProperty> properties, @NotNull NavPropertiesManager propertiesManager) {
            if (properties == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(2);
            }
            if (propertiesManager == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(3);
            }
            for (String propertyName : this.myPropertyNameUiNameMap.keySet()) {
                NlProperty property2 = properties.get(propertyName);
                if (property2 == null || propertyName.equals("startDestination") && property2.getComponents().stream().anyMatch(component2 -> {
                    if (propertiesManager == null) {
                        NavigationInspectorComponent.$$$reportNull$$$0(9);
                    }
                    return NavComponentHelperKt.getDestinationType(component2) == NavigationSchema.DestinationType.NAVIGATION && ((NavDesignSurface)propertiesManager.getDesignSurface()).getCurrentNavigation() != component2;
                })) continue;
                NlComponentEditor editor = propertiesManager.getPropertyEditors().create(property2);
                editor.setProperty(property2);
                this.myEditors.add(editor);
            }
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NavPropertiesManager propertiesManager) {
            if (components == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(4);
            }
            if (properties == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(5);
            }
            if (propertiesManager == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(6);
            }
            this.myEditors.clear();
            this.createEditors(properties, propertiesManager);
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            List<NlComponentEditor> list = this.myEditors;
            if (list == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(7);
            }
            return list;
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1 + this.myEditors.size();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            if (inspector == null) {
                NavigationInspectorComponent.$$$reportNull$$$0(8);
            }
            this.refresh();
            if (this.myTitle != null) {
                inspector.addTitle(this.myTitle);
            }
            for (NlComponentEditor editor : this.myEditors) {
                String propertyName;
                NlProperty property2 = editor.getProperty();
                JLabel existing = editor.getLabel();
                String string = propertyName = existing != null ? existing.getText() : this.myPropertyNameUiNameMap.get(property2.getName());
                if (propertyName == null) {
                    propertyName = property2.getName();
                }
                JLabel label = inspector.addComponent(propertyName, property2.getTooltipText(), editor.getComponent());
                editor.setLabel(label);
            }
        }

        @Override
        public void refresh() {
            this.myEditors.forEach(NlComponentEditor::refresh);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertiesManager";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/naveditor/property/inspector/NavPropertiesInspectorProvider$NavigationInspectorComponent";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/naveditor/property/inspector/NavPropertiesInspectorProvider$NavigationInspectorComponent";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createEditors";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateProperties";
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "attachToInspector";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$createEditors$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

