/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddDeeplinkDialog
extends DialogWrapper {
    private JTextField myUriField;
    private JCheckBox myAutoVerify;
    private JPanel myContentPanel;

    public AddDeeplinkDialog(@Nullable NlComponent existing) {
        super(false);
        this.$$$setupUI$$$();
        if (existing != null) {
            this.myUriField.setText(existing.getAttribute("http://schemas.android.com/apk/res-auto", "uri"));
            this.myAutoVerify.setSelected(Boolean.parseBoolean(existing.getAttribute("http://schemas.android.com/apk/res-auto", "autoVerify")));
        }
        this.init();
        if (existing == null) {
            this.myOKAction.putValue("Name", "Add");
            this.setTitle("Add Deep Link");
        } else {
            this.myOKAction.putValue("Name", "Update");
            this.setTitle("Update Deep Link");
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.myUriField.getText().isEmpty()) {
            return new ValidationInfo("URI must be set!", (JComponent)this.myUriField);
        }
        try {
            new URI(this.myUriField.getText());
        }
        catch (URISyntaxException e) {
            return new ValidationInfo("Invalid URI!", (JComponent)this.myUriField);
        }
        return null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    public String getUri() {
        return this.myUriField.getText();
    }

    public boolean getAutoVerify() {
        return this.myAutoVerify.isSelected();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            AddDeeplinkDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/naveditor/property/inspector/AddDeeplinkDialog", "createActions"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(15, 7, 0, 7), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("URI");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Auto Verify");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAutoVerify = jCheckBox = new JCheckBox();
        jCheckBox.setText("");
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, new Dimension(20, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUriField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel2.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(300, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

